/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils.converters;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import jakarta.xml.bind.DatatypeConverter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Converter
public class StringListConverter
implements AttributeConverter<List<String>, String> {
    private static final String SPLIT_CHAR = ";";

    public String convertToDatabaseColumn(List<String> stringList) {
        return stringList != null ? String.join((CharSequence)SPLIT_CHAR, stringList) : "";
    }

    public List<String> convertToEntityAttribute(String string) {
        if (string != null) {
            if (string.startsWith("\uaced")) {
                byte[] bytes = string.getBytes(StandardCharsets.UTF_16);
                String hex = Integer.toHexString(bytes[0]);
                byte[] bytes3 = DatatypeConverter.parseHexBinary((String)hex);
                return new ArrayList<String>();
            }
            return Arrays.asList(string.split(SPLIT_CHAR));
        }
        return Collections.emptyList();
    }
}

