/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.utils.TextImageGenerator;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

/*
 * Exception performing whole class analysis ignored.
 */
public class TextImageGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage renderTextImage(String[] lines, int width, int height, String fontFamily, int fontStyle, int basePointSize, int minPointSize, int paddingPx, VERTICAL_ALIGNMENT verticalAlignment) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Invalid image size.");
        }
        if (paddingPx < 0) {
            paddingPx = 0;
        }
        if (lines == null) {
            lines = new String[]{};
        }
        BufferedImage img = new BufferedImage(width, height, 1);
        Graphics2D g2 = img.createGraphics();
        try {
            float totalTextHeight;
            List layouts;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, width, height);
            int availW = Math.max(1, width - 2 * paddingPx);
            int availH = Math.max(1, height - 2 * paddingPx);
            int pointSize = Math.max(minPointSize, basePointSize);
            Font baseFont = new Font("Arial", 0, 1);
            if (TextImageGenerator.fontExists((String)fontFamily)) {
                baseFont = new Font(fontFamily, 0, 1);
            }
            while (true) {
                Font font = baseFont.deriveFont(fontStyle, pointSize);
                LayoutResult lr = TextImageGenerator.layoutLines((Graphics2D)g2, (String[])lines, (Font)font, (int)availW);
                layouts = lr.layouts;
                totalTextHeight = lr.totalHeight;
                if (lr.allLinesFitWidth && totalTextHeight <= (float)availH || pointSize <= minPointSize) break;
                --pointSize;
            }
            System.out.println("Final font size used: " + pointSize + " pt");
            float y = switch (1.$SwitchMap$cz$polreich$spagetka$utils$TextImageGenerator$VERTICAL_ALIGNMENT[verticalAlignment.ordinal()]) {
                default -> throw new IncompatibleClassChangeError();
                case 1 -> paddingPx;
                case 2 -> (float)paddingPx + Math.max(0.0f, ((float)availH - totalTextHeight) / 2.0f);
                case 3 -> (float)(height - paddingPx) - totalTextHeight;
            };
            g2.setColor(Color.BLACK);
            for (TextLayout layout : layouts) {
                float x = (float)paddingPx + Math.max(0.0f, ((float)availW - layout.getAdvance()) / 2.0f);
                layout.draw(g2, x, y += layout.getAscent());
                y += layout.getDescent() + layout.getLeading();
            }
        }
        finally {
            g2.dispose();
        }
        return img;
    }

    private static boolean fontExists(String family) {
        String[] available;
        for (String name : available = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames()) {
            if (!name.equalsIgnoreCase(family)) continue;
            return true;
        }
        return false;
    }

    private static LayoutResult layoutLines(Graphics2D g2, String[] lines, Font font, int availW) {
        FontRenderContext frc = g2.getFontRenderContext();
        ArrayList<TextLayout> layouts = new ArrayList<TextLayout>(lines.length);
        boolean allFit = true;
        float totalH = 0.0f;
        for (String raw : lines) {
            String s = raw == null ? "" : raw;
            TextLayout layout = new TextLayout(s.isEmpty() ? " " : s, font, frc);
            layouts.add(layout);
            if (layout.getAdvance() > (float)availW + 0.01f) {
                allFit = false;
            }
            totalH += layout.getAscent() + layout.getDescent() + layout.getLeading();
        }
        return new LayoutResult(layouts, totalH, allFit);
    }

    public static void main(String[] args) throws Exception {
        CharSequence[] lines = new String[]{"Se \u0161pen\u00e1tem", "a ku\u0159ec\u00edm masem"};
        int width = 300;
        int height = 150;
        byte[] imageBytes = TextImageGenerator.getImageBytesForText((String[])lines, (int)width, (int)height);
        try (FileOutputStream fos = new FileOutputStream(new File("C:\\Users\\polre\\Downloads\\" + String.join((CharSequence)" ", lines).replace(" ", "-") + "_image.png"));){
            fos.write(imageBytes);
        }
        System.out.println("Saved to text_image.png");
    }

    public static byte[] getImageBytesForText(String[] lines, int width, int height) throws IOException {
        String fontFamily = "DejaVu Sans";
        int fontStyle = 1;
        int basePointSize = 46;
        int minPointSize = 10;
        int paddingPx = 0;
        BufferedImage img = TextImageGenerator.renderTextImage((String[])lines, (int)width, (int)height, (String)fontFamily, (int)fontStyle, (int)basePointSize, (int)minPointSize, (int)paddingPx, (VERTICAL_ALIGNMENT)VERTICAL_ALIGNMENT.TOP);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)img, "png", baos);
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
    }
}

