/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import com.fasterxml.jackson.annotation.JsonFormat;
import cz.polreich.spagetka.DTO.StockMovementLogItemDTO;
import cz.polreich.spagetka.models.StockMovementLogItem;
import cz.polreich.spagetka.restControllers.BaseRestController;
import cz.polreich.spagetka.service.StockMovementLogItemsService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/stockMovementLogs"})
@Tag(name="Stock Movement Logs API", description="Handles Stock Movement Logs operations")
public class StockMovementLogItemsController
extends BaseRestController {
    @Autowired
    public StockMovementLogItemsService stockMovementLogItemService;

    @GetMapping
    @ResponseBody
    @Operation(summary="Returns all Stock Movement Log Items")
    public ResponseEntity<List<StockMovementLogItemDTO>> getAll(@RequestHeader Map<String, String> headers, @RequestParam(required=false, name="fromDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String fromDateTimeString, @RequestParam(required=false, name="toDateTime") @DateTimeFormat(pattern="dd.MM.yyyy'T'HH:mm:ss") String toDateTimeString) {
        return this.processRequest(headers, () -> new BaseRestController.DateRangeHandler((BaseRestController)this).handleDateRange(fromDateTimeString, toDateTimeString, arg_0 -> ((StockMovementLogItemsService)this.stockMovementLogItemService).findAllFromDateTime(arg_0), arg_0 -> ((StockMovementLogItemsService)this.stockMovementLogItemService).findAllToDateTime(arg_0), (arg_0, arg_1) -> ((StockMovementLogItemsService)this.stockMovementLogItemService).findAllInDateTimeFrame(arg_0, arg_1), () -> ((StockMovementLogItemsService)this.stockMovementLogItemService).findAll(), StockMovementLogItemDTO::new));
    }

    @GetMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Returns one Stock Movement Log item with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=StockMovementLogItemDTO.class))}), @ApiResponse(responseCode="404", description="Not Found - The Stock Movement Log Item with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public ResponseEntity<StockMovementLogItemDTO> getOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            if (this.stockMovementLogItemService.existsById(id)) {
                return new StockMovementLogItemDTO(this.stockMovementLogItemService.findById(id));
            }
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Stock Movement Log Item with ID: " + id + " not found!");
        });
    }

    @PostMapping
    @JsonFormat(with={JsonFormat.Feature.ACCEPT_SINGLE_VALUE_AS_ARRAY})
    @ResponseBody
    @Operation(summary="Save one or multiple new Stock Movement Log Items", description="Both Array and Single object instance can be provided")
    public ResponseEntity<List<StockMovementLogItemDTO>> saveAll(@RequestHeader Map<String, String> headers, @RequestBody List<StockMovementLogItemDTO> dtos) {
        return this.processRequest(headers, () -> {
            ArrayList<StockMovementLogItem> categories = new ArrayList<StockMovementLogItem>();
            for (StockMovementLogItemDTO dto : dtos) {
                StockMovementLogItem stockMovementLogItem = new StockMovementLogItem(dto);
                categories.add(stockMovementLogItem);
            }
            this.stockMovementLogItemService.saveAll(categories);
            return dtos;
        });
    }

    @PutMapping(value={"/{id}"})
    @ResponseBody
    @Operation(summary="Replace one Stock Movement Log Item with specified ID", description="Updates existing or creates a new Stock Movement Log Item in case none found with provided ID")
    public ResponseEntity<StockMovementLogItemDTO> replaceOne(@RequestHeader Map<String, String> headers, @RequestBody StockMovementLogItemDTO newItem, @PathVariable String id) {
        return this.processRequest(headers, () -> {
            newItem.setId(id);
            this.stockMovementLogItemService.save(new StockMovementLogItem(newItem));
            return newItem;
        });
    }

    @DeleteMapping(value={"/{id}"})
    @Operation(summary="Deletes one Stock Movement Log item with specified ID")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Not Found - The Stock Movement Log Item with specified ID was not found", content={@Content(schema=@Schema(implementation=ResponseStatusException.class))})})
    public void deleteOne(@RequestHeader Map<String, String> headers, @PathVariable String id) {
        if (this.isValidRequest(headers)) {
            if (!this.stockMovementLogItemService.existsById(id)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Stock Movement Log Item with ID: " + id + " not found!");
            }
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        this.stockMovementLogItemService.deleteById(id);
    }
}

