/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.factory;

import cz.polreich.spagetka.DTO.CategoryDTO;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.CategoryPackagingSettings;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import jakarta.xml.bind.DatatypeConverter;
import org.springframework.stereotype.Component;

@Component
public class CategoryFactory {
    private final ResourceHelper resourceHelper;

    public CategoryFactory(ResourceHelper resourceHelper) {
        this.resourceHelper = resourceHelper;
    }

    public Category create(CategoryDTO dto) {
        return this.create(dto, false);
    }

    public Category create(CategoryDTO dto, boolean fromExternal) {
        Category category = new Category();
        category.setId(dto.getId());
        category.setName(dto.getName());
        category.setImageFilePath(fromExternal ? this.resourceHelper.convertImagePathFromExternal(dto.getImageFilePath()) : dto.getImageFilePath());
        category.setRemoteImagePath(dto.getImageFilePath());
        category.setImageBytes(ValidationUtils.isStringNotNullOrEmpty((String)dto.getImageBytesBase64()) ? DatatypeConverter.parseBase64Binary((String)dto.getImageBytesBase64()) : new byte[]{});
        category.setCookPosition(dto.getCookPosition());
        for (String key : dto.getPackaging().keySet()) {
            category.getPackaging().add(new CategoryPackagingSettings(key, category.getId(), ((Integer)dto.getPackaging().get(key)).intValue()));
        }
        return category;
    }
}

