/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.orderConfirmationController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerOrderConfirmationController;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.utils.LayoutUtils;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Window;

public class ConfirmationPopup
extends Popup {
    private CustomerOrderConfirmationController orderConfirmationController;
    private Label titleLabel;
    private FlowPane textFlowPane;
    private Label textLabel1;
    private Label textLabel2;
    private FlowPane buttonFlowPane;
    private ConfirmButton endButton;
    private VBox orderNumberVBox;
    private Label orderNumberTitleLabel;
    private Label orderNumberValueLabel;

    public ConfirmationPopup(CustomerOrderConfirmationController orderConfirmationController) {
        this.orderConfirmationController = orderConfirmationController;
        double maxPopupWidth = (double)orderConfirmationController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.9;
        AnchorPane popupAnchor = new AnchorPane();
        this.titleLabel = new Label();
        AnchorPane.setTopAnchor((Node)this.titleLabel, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)this.titleLabel, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.titleLabel, (Double)100.0);
        this.titleLabel.setAlignment(Pos.CENTER);
        this.titleLabel.setPadding(new Insets(20.0));
        this.titleLabel.setFont(orderConfirmationController.titleFont);
        this.orderNumberVBox = new VBox();
        this.orderNumberVBox.setMaxWidth(maxPopupWidth - 20.0);
        this.orderNumberVBox.setAlignment(Pos.CENTER);
        this.orderNumberVBox.setSpacing(20.0);
        this.orderNumberTitleLabel = new Label("\u010c\u00edslo objedn\u00e1vky");
        this.orderNumberTitleLabel.setFont(orderConfirmationController.titleFont);
        this.orderNumberTitleLabel.setMaxWidth(maxPopupWidth - 20.0);
        this.orderNumberTitleLabel.setAlignment(Pos.CENTER);
        this.orderNumberTitleLabel.setTextAlignment(TextAlignment.CENTER);
        this.orderNumberValueLabel = new Label();
        this.orderNumberValueLabel.setFont(orderConfirmationController.confirmationOrderNumberFont);
        this.orderNumberValueLabel.setMaxWidth(maxPopupWidth - 20.0);
        this.orderNumberValueLabel.setAlignment(Pos.CENTER);
        this.orderNumberValueLabel.setTextAlignment(TextAlignment.CENTER);
        this.orderNumberVBox.getChildren().addAll((Object[])new Node[]{this.orderNumberTitleLabel, this.orderNumberValueLabel});
        AnchorPane.setTopAnchor((Node)this.orderNumberVBox, (Double)200.0);
        AnchorPane.setLeftAnchor((Node)this.orderNumberVBox, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.orderNumberVBox, (Double)0.0);
        this.textFlowPane = new FlowPane();
        this.textFlowPane.setAlignment(Pos.CENTER);
        this.textFlowPane.setOrientation(Orientation.VERTICAL);
        this.textFlowPane.setVgap(30.0);
        this.textFlowPane.setMaxWidth(maxPopupWidth - 20.0);
        this.textFlowPane.setPadding(LayoutUtils.getInsets((double)0.0, (double)0.0, (double)30.0, (double)0.0));
        AnchorPane.setTopAnchor((Node)this.textFlowPane, (Double)450.0);
        AnchorPane.setLeftAnchor((Node)this.textFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.textFlowPane, (Double)0.0);
        this.textLabel1 = new Label();
        this.textLabel1.setAlignment(Pos.CENTER);
        this.textLabel1.setTextAlignment(TextAlignment.CENTER);
        this.textLabel1.setMaxWidth(maxPopupWidth - 20.0);
        this.textLabel1.setWrapText(true);
        this.textLabel1.setFont(orderConfirmationController.payByCashTextFont);
        this.textLabel2 = new Label();
        this.textLabel2.setAlignment(Pos.CENTER);
        this.textLabel2.setTextAlignment(TextAlignment.CENTER);
        this.textLabel2.setMaxWidth(maxPopupWidth - 20.0);
        this.textLabel2.setPadding(LayoutUtils.getInsets((double)0.0, (double)0.0, (double)40.0, (double)0.0));
        this.textLabel2.setWrapText(true);
        this.textLabel2.setFont(orderConfirmationController.payByCashTextFont);
        this.textFlowPane.getChildren().addAll((Object[])new Node[]{this.textLabel1, this.textLabel2});
        this.buttonFlowPane = new FlowPane();
        AnchorPane.setBottomAnchor((Node)this.buttonFlowPane, (Double)40.0);
        AnchorPane.setLeftAnchor((Node)this.buttonFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.buttonFlowPane, (Double)0.0);
        this.buttonFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.buttonFlowPane.setAlignment(Pos.CENTER);
        this.endButton = new ConfirmButton();
        this.endButton.setMinSize(160.0, 40.0);
        this.endButton.setFont(orderConfirmationController.titleFont);
        this.buttonFlowPane.getChildren().add((Object)this.endButton);
        popupAnchor.setMinWidth(300.0);
        popupAnchor.setMinHeight(300.0);
        popupAnchor.setMaxWidth(maxPopupWidth);
        popupAnchor.setMaxWidth(maxPopupWidth);
        popupAnchor.getStyleClass().add((Object)"popup-main-pane");
        popupAnchor.setStyle("-fx-background-color: " + orderConfirmationController.popupBackgroundColor + ";");
        popupAnchor.getChildren().addAll((Object[])new Node[]{this.titleLabel, this.orderNumberVBox, this.textFlowPane, this.buttonFlowPane});
        this.getContent().add((Object)popupAnchor);
        this.endButton.setOnMouseClicked(mouseEvent -> {
            this.hide();
            orderConfirmationController.resetToMainScene();
        });
        this.endButton.setOnTouchPressed(touchEvent -> {
            this.hide();
            orderConfirmationController.resetToMainScene();
        });
    }

    public void loadPopup(Order order, PAYMENT_METHOD paymentMethod) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.orderConfirmationController.activeConfig.getOpenedPopups().add(this);
        this.orderNumberValueLabel.setText(order.getOrderNumber());
        if (paymentMethod.equals((Object)PAYMENT_METHOD.CASH)) {
            this.titleLabel.setText(this.orderConfirmationController.strings.getString("confirmation.cash.label.title"));
            this.textLabel1.setText(this.orderConfirmationController.strings.getString("confirmation.cash.text.section1"));
            this.textLabel2.setText(this.orderConfirmationController.strings.getString("confirmation.cash.text.section2"));
            this.endButton.setText(this.orderConfirmationController.strings.getString("confirmation.cash.button.ok"));
        }
        if (paymentMethod.equals((Object)PAYMENT_METHOD.CARD)) {
            this.titleLabel.setText(this.orderConfirmationController.strings.getString("confirmation.card.label.title"));
            this.textLabel1.setText(this.orderConfirmationController.strings.getString("confirmation.card.text.section1"));
            this.textLabel2.setText(this.orderConfirmationController.strings.getString("confirmation.card.text.section2"));
            this.endButton.setText(this.orderConfirmationController.strings.getString("confirmation.card.button.ok"));
        }
        this.show((Window)this.orderConfirmationController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void hide() {
        this.orderConfirmationController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }
}

