/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController.inventoryPopup;

import cz.polreich.spagetka.factory.ErrorTypeFactory;
import cz.polreich.spagetka.models.ErrorType;
import cz.polreich.spagetka.models.enums.STOCK_OUT_ERROR_TYPE;
import cz.polreich.spagetka.utils.InventoryUtils;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;

public class ErrorAnchorPane {
    private final ErrorTypeFactory errorTypeFactory = new ErrorTypeFactory();
    private Pane parentElement;
    private TextField locationTextField;
    private TextField itemTextField;
    private final String locationText = "Lokace:";
    private final String itemText = "Polo\u017eka:";

    public ErrorAnchorPane(Pane parentElement, TextField locationTextField, TextField itemTextField) {
        this.parentElement = parentElement;
        this.locationTextField = locationTextField;
        this.itemTextField = itemTextField;
    }

    public <T> void create(STOCK_OUT_ERROR_TYPE stockOutErrorType, T value) {
        ErrorType errorType = this.errorTypeFactory.getErrorType(stockOutErrorType, value);
        this.generateErrorAnchorPane(errorType);
    }

    public void create(STOCK_OUT_ERROR_TYPE stockOutErrorType) {
        ErrorType errorType = this.errorTypeFactory.getErrorType(stockOutErrorType);
        this.generateErrorAnchorPane(errorType);
    }

    private void generateErrorAnchorPane(ErrorType errorType) {
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setPrefWidth(this.parentElement.getMaxWidth());
        anchorPane.setPrefHeight(this.parentElement.getMaxHeight());
        anchorPane.setStyle("-fx-background-color: white");
        Label locationLabel = new Label("Lokace: " + InventoryUtils.trimInventoryLocation((String)this.locationTextField.getText()));
        locationLabel.setAlignment(Pos.CENTER);
        locationLabel.setPadding(new Insets(20.0));
        locationLabel.setStyle("-fx-font-size: 40px;");
        locationLabel.setWrapText(true);
        AnchorPane.setTopAnchor((Node)locationLabel, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)locationLabel, (Double)20.0);
        Label itemLabel = new Label("Polo\u017eka: " + this.itemTextField.getText());
        itemLabel.setAlignment(Pos.CENTER);
        itemLabel.setPadding(new Insets(20.0));
        itemLabel.setStyle("-fx-font-size: 40px;");
        itemLabel.setWrapText(true);
        AnchorPane.setTopAnchor((Node)itemLabel, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)itemLabel, (Double)20.0);
        Label labelError = new Label();
        labelError.setText(errorType.getDescription() + " " + errorType.getValue());
        labelError.setAlignment(Pos.CENTER);
        labelError.setPadding(new Insets(20.0));
        labelError.setStyle("-fx-font-size: 40px;-fx-text-fill: red;");
        labelError.setWrapText(true);
        AnchorPane.setTopAnchor((Node)labelError, (Double)250.0);
        AnchorPane.setLeftAnchor((Node)labelError, (Double)20.0);
        AnchorPane.setRightAnchor((Node)labelError, (Double)20.0);
        Button buttonOk = new Button("OK");
        buttonOk.getStyleClass().add((Object)"login_button");
        buttonOk.setPrefWidth(300.0);
        buttonOk.setPrefHeight(50.0);
        AnchorPane.setBottomAnchor((Node)buttonOk, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)buttonOk, (Double)20.0);
        AnchorPane.setRightAnchor((Node)buttonOk, (Double)20.0);
        buttonOk.setOnTouchPressed(event -> this.parentElement.getChildren().remove((Object)anchorPane));
        buttonOk.setOnMouseClicked(event -> this.parentElement.getChildren().remove((Object)anchorPane));
        anchorPane.getChildren().addAll((Object[])new Node[]{labelError, buttonOk, itemLabel, locationLabel});
        this.parentElement.getChildren().add((Object)anchorPane);
    }
}

