/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.layout.cashierController;

import cz.polreich.spagetka.controllers.layout.cashierController.OrderCashierSection;
import cz.polreich.spagetka.controllers.popup.cashierController.OrderCashierSectionService;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.ORDER_TYPE;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.time.LocalDateTime;
import java.util.List;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class OrderCashierSection {
    private static final Logger log = LoggerFactory.getLogger(OrderCashierSection.class);
    private final FlowPane ordersFlowPane;
    private boolean isFlowPaneExtended = false;
    private List<Order> orders;
    private Image imageEatIn;
    private Image imageTakeAway;
    private Image imageDelivery;
    private Image imagePickup;
    private Image imageOnline;
    private Image imageUnknown;
    private Image imageCustomerNote;
    private Image imageFirstOrder;
    private Image imageNotRegistered;
    private Image imageNoPhone;
    private Font normalFont;
    private Font titleFont;
    private Font subtitleFont;
    private final OrderCashierSectionService orderCashierSectionService;
    private FlowPane collapsedOrdersFlowPane = new FlowPane();
    private final ScrollPane orderScrollPane;
    private double orderTileWidth = 524.0;
    private final Button extendOrdersListButton;
    private final List<String> showCollapsed;
    private Boolean OrderScrollPaneScrolling = false;

    public OrderCashierSection(OrderCashierSectionService orderCashierSectionService, FlowPane ordersFlowPane, ScrollPane orderScrollPane, Font normalFont, Font titleFont, Font subtitleFont, Image imageEatIn, Image imageTakeAway, Image imageDelivery, Image imagePickup, Image imageOnline, Image imageUnknown, Image imageCustomerNote, Image imageFirstOrder, Image imageNotRegistered, Image imageNoPhone) {
        this.orderCashierSectionService = orderCashierSectionService;
        this.showCollapsed = orderCashierSectionService.getCollapsedOrders();
        this.normalFont = normalFont;
        this.titleFont = titleFont;
        this.subtitleFont = subtitleFont;
        this.imageEatIn = imageEatIn;
        this.imageTakeAway = imageTakeAway;
        this.imageDelivery = imageDelivery;
        this.imagePickup = imagePickup;
        this.imageOnline = imageOnline;
        this.imageUnknown = imageUnknown;
        this.imageCustomerNote = imageCustomerNote;
        this.imageFirstOrder = imageFirstOrder;
        this.imageNotRegistered = imageNotRegistered;
        this.imageNoPhone = imageNoPhone;
        this.ordersFlowPane = ordersFlowPane;
        this.orderScrollPane = this.setUpOrderScrollPane(orderScrollPane);
        this.ordersFlowPane.setPadding(new Insets(6.0));
        this.ordersFlowPane.setVgap(10.0);
        this.ordersFlowPane.setHgap(20.0);
        this.ordersFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.ordersFlowPane.setPrefWrapLength(this.orderTileWidth);
        this.extendOrdersListButton = new Button(this.orderCashierSectionService.getValueFromProperties("extendOrderList"));
        this.extendOrdersListButton.getStyleClass().add((Object)"order_anchor_pane_extension_button_extension");
        this.extendOrdersListButton.setPrefHeight(40.0);
        this.extendOrdersListButton.setPrefWidth(500.0);
        this.extendOrdersListButton.setOnMouseClicked(mouseEvent -> this.toggleExtendedFlowPane());
        this.collapsedOrdersFlowPane.setPrefWidth(520.0);
        this.collapsedOrdersFlowPane.setPrefHeight(0.0);
        this.collapsedOrdersFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.collapsedOrdersFlowPane.setHgap(10.0);
        this.collapsedOrdersFlowPane.setVgap(10.0);
    }

    public void loadNewOrders(List<Order> orders) {
        this.orders = orders;
        this.orderCashierSectionAction();
    }

    private void orderCashierSectionAction() {
        this.ordersFlowPane.getChildren().clear();
        this.collapsedOrdersFlowPane.getChildren().clear();
        this.ordersFlowPane.getChildren().addAll((Object[])new Node[]{this.extendOrdersListButton, this.collapsedOrdersFlowPane});
        for (int i = 0; i < this.orders.size(); ++i) {
            Order order = (Order)this.orders.get(i);
            if (this.showCollapsed.contains(order.getId())) {
                try {
                    this.createCollapsedOrderCashierSection(order);
                }
                catch (Exception e) {
                    log.error("[CREATING COLLAPSE ORDER SECTION ERROR] - {}", (Throwable)e);
                    ExceptionHandler.logException((Exception)e);
                }
                continue;
            }
            try {
                this.createOrderCashierSection(order);
                continue;
            }
            catch (Exception e) {
                log.error("[CREATING ORDER SECTION ERROR] - {}", (Throwable)e);
                ExceptionHandler.logException((Exception)e);
            }
        }
    }

    private void toggleExtendedFlowPane() {
        if (this.isFlowPaneExtended) {
            AnchorPane.setLeftAnchor((Node)this.orderScrollPane, (Double)480.0);
            AnchorPane.setTopAnchor((Node)this.orderScrollPane, (Double)125.0);
            this.collapsedOrdersFlowPane.setPrefWidth(520.0);
            this.isFlowPaneExtended = false;
            this.ordersFlowPane.setOrientation(Orientation.HORIZONTAL);
            this.orderTileWidth = 524.0;
            this.extendOrdersListButton.setText(this.orderCashierSectionService.getValueFromProperties("extendOrderList"));
        } else {
            AnchorPane.setLeftAnchor((Node)this.orderScrollPane, (Double)10.0);
            AnchorPane.setTopAnchor((Node)this.orderScrollPane, (Double)10.0);
            this.collapsedOrdersFlowPane.setPrefWidth(1000.0);
            this.isFlowPaneExtended = true;
            this.ordersFlowPane.setOrientation(Orientation.HORIZONTAL);
            this.orderTileWidth = 480.0;
            this.extendOrdersListButton.setText(this.orderCashierSectionService.getValueFromProperties("retractOrderList"));
        }
        this.orderCashierSectionAction();
    }

    private void createCollapsedOrderCashierSection(Order order) {
        AnchorPane anchorPane = this.createBaseAnchorPane();
        boolean isLate = this.orderCashierSectionService.isOrderLate(order);
        char firstChar = order.getOrderNumber().charAt(0);
        if (Character.isLetter(firstChar)) {
            this.createPlatformOrderBlock(anchorPane, order, firstChar, isLate);
        } else {
            this.createSimpleOrderBlock(anchorPane, order, isLate);
        }
        this.applyBackgroundColor(anchorPane, order);
        anchorPane.setOnMouseClicked(event -> this.toggleCollapsed(order));
        this.collapsedOrdersFlowPane.getChildren().add((Object)anchorPane);
    }

    private AnchorPane createBaseAnchorPane() {
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMinHeight(40.0);
        anchorPane.setPrefHeight(86.0);
        anchorPane.setMinWidth(20.0);
        anchorPane.setPrefWidth(100.0);
        anchorPane.setMaxWidth(300.0);
        anchorPane.getStyleClass().add((Object)"order_anchor_pane");
        return anchorPane;
    }

    private void createPlatformOrderBlock(AnchorPane root, Order order, char firstChar, boolean isLate) {
        VBox box = new VBox(0.0);
        box.setPadding(LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)0.0));
        box.setSpacing(0.0);
        box.setAlignment(Pos.CENTER);
        box.setMaxWidth(96.0);
        String type = switch (firstChar) {
            case 'W' -> "Wolt";
            case 'F' -> "Food";
            case 'B' -> "Bolt";
            default -> "";
        };
        Label orderType = new Label(type);
        orderType.setFont(this.normalFont);
        orderType.setAlignment(Pos.CENTER);
        Label orderNumber = new Label(order.getCleanOrderNumber(false));
        orderNumber.setAlignment(Pos.CENTER);
        FontUtils.setIdealFont((Label)orderNumber, (Font)this.titleFont);
        box.getChildren().addAll((Object[])new Node[]{orderType, orderNumber});
        AnchorPane.setTopAnchor((Node)box, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)box, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)box, (Double)0.0);
        AnchorPane.setRightAnchor((Node)box, (Double)0.0);
        if (isLate) {
            orderType.setStyle("-fx-text-fill: #B40F0F;");
            orderNumber.setStyle("-fx-text-fill: #B40F0F;");
        }
        root.getChildren().add((Object)box);
    }

    private void createSimpleOrderBlock(AnchorPane root, Order order, boolean isLate) {
        Label orderNumber = new Label(order.getCleanOrderNumber(false));
        orderNumber.setAlignment(Pos.CENTER);
        if (orderNumber.getText().length() > 2) {
            orderNumber.setFont(this.subtitleFont);
        } else {
            orderNumber.setFont(this.titleFont);
        }
        AnchorPane.setTopAnchor((Node)orderNumber, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)orderNumber, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)orderNumber, (Double)0.0);
        AnchorPane.setRightAnchor((Node)orderNumber, (Double)0.0);
        if (isLate) {
            orderNumber.setStyle("-fx-text-fill: #B40F0F;");
        }
        root.getChildren().add((Object)orderNumber);
    }

    private void applyBackgroundColor(AnchorPane pane, Order order) {
        switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_STATUS[order.getOrderStatus().ordinal()]) {
            case 1: {
                pane.setStyle("-fx-background-color: #A9A9A9");
                break;
            }
            case 2: {
                pane.setStyle("-fx-background-color: #F8F8F8");
                break;
            }
            case 3: 
            case 4: {
                pane.setStyle("-fx-background-color: #9FE2BF");
            }
        }
    }

    private void createOrderCashierSection(Order order) {
        boolean isLate = this.orderCashierSectionService.isOrderLate(order);
        VBox outerVBox = new VBox(10.0);
        AnchorPane orderPane = this.createOrderPane(order);
        Label orderName = this.createOrderNameLabel(order);
        Label orderNumber = this.createOrderNumberLabel(order);
        Label pickupTimeLabel = this.createPickupTimeLabel(order);
        Label priceLabel = this.createPriceLabel(order);
        ImageView orderTypeIcon = this.createOrderTypeIcon(order);
        Label orderTypeLabel = this.createOrderTypeText(order);
        this.addLateOrderStyling(isLate, new Label[]{orderName, orderNumber, pickupTimeLabel, priceLabel});
        ImageView[] extraIcons = this.buildExtraIcons(order);
        VBox orderItemsVBox = this.createOrderItemVBox(order);
        orderPane.getChildren().add((Object)orderItemsVBox);
        orderPane.getChildren().addAll((Object[])new Node[]{orderNumber, orderName, orderTypeIcon, priceLabel, pickupTimeLabel, orderTypeLabel});
        for (ImageView icon : extraIcons) {
            if (icon == null) continue;
            orderPane.getChildren().add((Object)icon);
        }
        orderPane.setOnMouseClicked(e -> this.toggleCollapsed(order));
        HBox buttons = this.buildButtons(orderPane, order);
        this.applyBackgroundColor(orderPane, order);
        outerVBox.getChildren().addAll((Object[])new Node[]{orderPane, buttons});
        this.ordersFlowPane.getChildren().add((Object)outerVBox);
    }

    private AnchorPane createOrderPane(Order order) {
        AnchorPane pane = new AnchorPane();
        pane.getStyleClass().add((Object)"order_anchor_pane");
        pane.setPrefWidth(this.orderTileWidth);
        pane.setMaxWidth(this.orderTileWidth);
        return pane;
    }

    private Label createOrderNameLabel(Order order) {
        Label lbl = new Label(order.getCustomerFullName());
        lbl.setStyle("-fx-font-size: 16px;");
        AnchorPane.setLeftAnchor((Node)lbl, (Double)10.0);
        AnchorPane.setTopAnchor((Node)lbl, (Double)30.0);
        return lbl;
    }

    private Label createOrderNumberLabel(Order order) {
        Label lbl = new Label(order.getOrderNumber());
        lbl.setStyle("-fx-font-size: 16px;");
        AnchorPane.setLeftAnchor((Node)lbl, (Double)10.0);
        AnchorPane.setTopAnchor((Node)lbl, (Double)10.0);
        return lbl;
    }

    private Label createPickupTimeLabel(Order order) {
        Label lbl = new Label(FormatUtils.formatTime((LocalDateTime)order.getToBeFinishedDateTime()));
        lbl.setStyle("-fx-font-size: 16px;");
        AnchorPane.setRightAnchor((Node)lbl, (Double)10.0);
        AnchorPane.setTopAnchor((Node)lbl, (Double)10.0);
        return lbl;
    }

    private Label createPriceLabel(Order order) {
        Label lbl = new Label("Celkem: " + FormatUtils.formatCurrency((double)order.getTotalPrice(), (String)this.orderCashierSectionService.getCurrencySymbol()));
        lbl.setStyle("-fx-font-size: 16px;");
        AnchorPane.setRightAnchor((Node)lbl, (Double)10.0);
        AnchorPane.setTopAnchor((Node)lbl, (Double)30.0);
        return lbl;
    }

    private ImageView createOrderTypeIcon(Order order) {
        ImageView icon = new ImageView();
        icon.setFitWidth(30.0);
        icon.setFitHeight(30.0);
        AnchorPane.setLeftAnchor((Node)icon, (Double)190.0);
        AnchorPane.setTopAnchor((Node)icon, (Double)10.0);
        if (order.getOrderType() == null) {
            icon.setImage(this.imageUnknown);
        } else if (order.getOrderType() == ORDER_TYPE.PERSONAL_HERE) {
            icon.setImage(this.imageEatIn);
        } else if (order.getOrderType() == ORDER_TYPE.PERSONAL_TAKE_AWAY) {
            icon.setImage(this.imageTakeAway);
        } else if (order.isDelivery()) {
            icon.setImage(this.imageDelivery);
        } else if (order.getOrderType() == ORDER_TYPE.ONLINE) {
            icon.setImage(this.imageOnline);
        } else if (order.isPickup()) {
            icon.setImage(this.imagePickup);
        } else {
            icon.setImage(this.imageUnknown);
        }
        return icon;
    }

    private Label createOrderTypeText(Order order) {
        Label lbl = new Label();
        AnchorPane.setLeftAnchor((Node)lbl, (Double)180.0);
        AnchorPane.setTopAnchor((Node)lbl, (Double)40.0);
        lbl.setText(this.resolveOrderTypeText(order));
        return lbl;
    }

    private String resolveOrderTypeText(Order order) {
        if (order.getOrderType() == null) {
            return this.orderCashierSectionService.getValueFromProperties("unknown");
        }
        if (order.getOrderType() == ORDER_TYPE.PERSONAL_HERE) {
            return this.orderCashierSectionService.getValueFromProperties("eatIn");
        }
        if (order.getOrderType() == ORDER_TYPE.PERSONAL_TAKE_AWAY) {
            return this.orderCashierSectionService.getValueFromProperties("takeAway");
        }
        if (order.isDelivery()) {
            String t = this.orderCashierSectionService.getValueFromProperties("delivery");
            return t + this.resolvePartnerAppendix(order);
        }
        if (order.isPickup()) {
            String t = this.orderCashierSectionService.getValueFromProperties("pickup");
            return t + this.resolvePartnerAppendix(order);
        }
        if (order.getOrderType() == ORDER_TYPE.ONLINE) {
            return this.orderCashierSectionService.getValueFromProperties("online");
        }
        return this.orderCashierSectionService.getValueFromProperties("unknown");
    }

    private String resolvePartnerAppendix(Order order) {
        return switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_TYPE[order.getOrderType().ordinal()]) {
            case 1, 2 -> " Wolt";
            case 3, 4 -> " Foodora";
            case 5, 6 -> " Bolt";
            default -> "";
        };
    }

    private ImageView[] buildExtraIcons(Order order) {
        ImageView noteIcon = null;
        ImageView firstIcon = null;
        ImageView regIcon = null;
        ImageView phoneIcon = null;
        if (ValidationUtils.isStringNotNullOrEmpty((String)order.getCustomerDescription())) {
            noteIcon = this.positionedIcon(this.imageCustomerNote, 240.0);
        }
        if (Boolean.TRUE.equals(order.isCustomerEvaluated())) {
            if (Boolean.TRUE.equals(order.isCustomerFirstOrder())) {
                firstIcon = this.positionedIcon(this.imageFirstOrder, 280.0);
            }
            if (Boolean.FALSE.equals(order.isCustomerRegistered())) {
                regIcon = this.positionedIcon(this.imageNotRegistered, 320.0);
            }
        }
        if (order.getCustomerPhoneNumber() == null || order.getCustomerPhoneNumber().trim().isEmpty()) {
            phoneIcon = this.positionedIcon(this.imageNoPhone, 280.0);
        }
        return new ImageView[]{noteIcon, firstIcon, regIcon, phoneIcon};
    }

    private ImageView positionedIcon(Image img, double left) {
        ImageView iv = new ImageView(img);
        iv.setFitHeight(30.0);
        iv.setFitWidth(30.0);
        AnchorPane.setLeftAnchor((Node)iv, (Double)left);
        AnchorPane.setTopAnchor((Node)iv, (Double)10.0);
        return iv;
    }

    private HBox buildButtons(AnchorPane pane, Order order) {
        Button done = this.buildButton("done", 150.0, e -> this.finishOrderButtonAction(pane, order));
        Button pickup = this.buildButton("retrieved", 210.0, null);
        pickup.setOnMouseReleased(e -> this.forPickupButtonAction(order, pickup, done));
        Button manage = this.buildButton("manage", 210.0, e -> this.orderCashierSectionService.switchToOrderManagementScene(order.getId()));
        pickup.setVisible(false);
        HBox box = new HBox(10.0);
        switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_STATUS[order.getOrderStatus().ordinal()]) {
            case 1: {
                pickup.setVisible(true);
                box.getChildren().addAll((Object[])new Node[]{pickup, manage});
                break;
            }
            case 2: {
                pickup.setVisible(true);
                box.getChildren().addAll((Object[])new Node[]{pickup, manage});
                break;
            }
            case 3: 
            case 4: {
                box.getChildren().addAll((Object[])new Node[]{manage, done});
            }
        }
        return box;
    }

    private Button buildButton(String textKey, double width, EventHandler<? super MouseEvent> handler) {
        Button btn = new Button(this.orderCashierSectionService.getValueFromProperties(textKey));
        btn.getStyleClass().add((Object)"order_anchor_pane_button");
        btn.setPrefWidth(width);
        if (handler != null) {
            btn.setOnMouseReleased(handler);
        }
        return btn;
    }

    private void addLateOrderStyling(boolean late, Label ... labels) {
        if (!late) {
            return;
        }
        for (Label lbl : labels) {
            lbl.setStyle("-fx-text-fill : #B40F0F;");
        }
    }

    private void toggleCollapsed(Order order) {
        if (this.showCollapsed.contains(order.getId())) {
            this.showCollapsed.remove(order.getId());
        } else {
            this.showCollapsed.add(order.getId());
        }
        this.orderCashierSectionAction();
    }

    private VBox createOrderItemVBox(Order order) {
        VBox orderItemsVBox = new VBox();
        AnchorPane.setTopAnchor((Node)orderItemsVBox, (Double)65.0);
        AnchorPane.setLeftAnchor((Node)orderItemsVBox, (Double)10.0);
        orderItemsVBox.setSpacing(10.0);
        orderItemsVBox.setPadding(new Insets(10.0));
        orderItemsVBox.setStyle("-fx-border-style: solid none none none ;-fx-border-color: #C0C0C0;");
        for (OrderItem orderItem : order.getOrderItems()) {
            if (orderItem.getMainProduct().getPackagingItem().booleanValue()) continue;
            HBox orderItemsHBox = LayoutUtils.createOrderItemsList((OrderItem)orderItem, (String)this.orderCashierSectionService.getCurrencySymbol(), (double)(this.orderTileWidth - 60.0));
            orderItemsVBox.getChildren().add((Object)orderItemsHBox);
        }
        return orderItemsVBox;
    }

    private void forPickupButtonAction(Order order, Button showOrderButton, Button finishOrderButton) {
        if (!this.OrderScrollPaneScrolling.booleanValue()) {
            this.orderCashierSectionService.prepareOrderForPickup(order);
            showOrderButton.setVisible(false);
            finishOrderButton.setVisible(true);
            this.orderCashierSectionAction();
        }
    }

    private void finishOrderButtonAction(AnchorPane orderAnchorPane, Order order) {
        if (!this.OrderScrollPaneScrolling.booleanValue()) {
            order.setOrderStatus(ORDER_STATUS.DONE);
            order.setUserFinished(this.orderCashierSectionService.getLoggedUser());
            this.orderCashierSectionService.updateOrder(order);
            this.orders.remove(order);
            orderAnchorPane.setVisible(false);
            this.orderCashierSectionAction();
        }
    }

    private void createFXElementsByOrderStatus(Order order, AnchorPane orderAnchorPane, Button acceptOrderButton, Button finishOrderButton, Button managementOrderButton) {
        switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_STATUS[order.getOrderStatus().ordinal()]) {
            case 5: {
                managementOrderButton.setVisible(true);
                break;
            }
            case 2: {
                orderAnchorPane.setStyle("-fx-background-color: #90EE90; -fx-background-radius : 10 10 10 10;\n    -fx-font-size : 15px;\n    -fx-font-family: \"Century Gothic\";");
                orderAnchorPane.setPrefHeight(50.0);
                orderAnchorPane.setMinWidth(464.0);
                orderAnchorPane.setMaxWidth(464.0);
                acceptOrderButton.setVisible(false);
                finishOrderButton.setVisible(true);
                managementOrderButton.setVisible(true);
                break;
            }
            case 1: {
                managementOrderButton.setVisible(true);
                break;
            }
            case 3: {
                managementOrderButton.setVisible(true);
                orderAnchorPane.setStyle("-fx-background-color: #9FE2BF");
            }
        }
    }

    private ScrollPane setUpOrderScrollPane(ScrollPane scrollPane) {
        scrollPane.setFitToWidth(true);
        scrollPane.setOnScrollStarted(e -> {
            this.OrderScrollPaneScrolling = true;
            e.consume();
        });
        scrollPane.setOnScrollFinished(e -> {
            this.OrderScrollPaneScrolling = false;
            e.consume();
        });
        scrollPane.setStyle("-fx-background-color: #393F56;");
        return scrollPane;
    }

    public List<Order> getOrders() {
        return this.orders;
    }

    public void setOrders(List<Order> orders) {
        this.orders = orders;
    }

    public Image getImageEatIn() {
        return this.imageEatIn;
    }

    public Image getImageTakeAway() {
        return this.imageTakeAway;
    }

    public Image getImageDelivery() {
        return this.imageDelivery;
    }

    public Image getImagePickup() {
        return this.imagePickup;
    }

    public Image getImageOnline() {
        return this.imageOnline;
    }

    public Image getImageUnknown() {
        return this.imageUnknown;
    }

    public Image getImageCustomerNote() {
        return this.imageCustomerNote;
    }

    public Image getImageFirstOrder() {
        return this.imageFirstOrder;
    }

    public Image getImageNotRegistered() {
        return this.imageNotRegistered;
    }

    public Image getImageNoPhone() {
        return this.imageNoPhone;
    }

    public OrderCashierSectionService getOrderCashierSectionService() {
        return this.orderCashierSectionService;
    }

    public List<String> getShowCollapsed() {
        return this.showCollapsed;
    }
}

