/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.controllers.Controller;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.MenuOptionsPackagingSettings;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.ProductService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javafx.beans.property.LongProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class CustomerBaseController
extends Controller {
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private ProductService productService;
    public CustomerConfig activeConfig;
    public Font titleFont;
    public Font subtitleFont;
    public Font priceLabelFont;
    public Font normalFont;
    public Font productTitleFont;
    public Font cartProductTitleFont;
    public Font cartAddItemsLabelFont;
    public Font cartQuantityLabelFont;
    public Font payByCashTextFont;
    public Font popupTitleFont;
    public Font confirmationOrderNumberFont;
    public Font welcomeMainTitleFont;
    public Font welcomeLogoTitleFont;
    public Font welcomeSubtitleFont;
    public Font keyboardButtonsFont;
    public String mainBackgroundColor;
    public String popupBackgroundColor;
    public static long lastPressTime = System.currentTimeMillis();
    protected static int resetInterval = 120;
    protected static LongProperty timeToTimeout = new SimpleLongProperty(System.currentTimeMillis() - lastPressTime);
    protected List<Popup> popups = new ArrayList();

    @PostConstruct
    public void init() {
        super.init();
        this.activeConfig = this.config.getCustomer();
        this.activeConfig = this.activeConfig;
    }

    public void setupScene() {
        super.setupScene();
        resetInterval = this.activeConfig.getResetIntervalSeconds();
        this.stringBundleName = "resources/strings/customer";
        this.strings = ResourceBundle.getBundle(this.stringBundleName, this.activeConfig.getSelectedLocale());
        this.stage.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            lastPressTime = System.currentTimeMillis();
        });
        this.stage.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            lastPressTime = System.currentTimeMillis();
        });
    }

    public void setupColors() {
        super.setupColors();
        this.mainBackgroundColor = this.activeConfig.getColors().getMainBackground();
        this.popupBackgroundColor = this.activeConfig.getColors().getPopupBackground();
    }

    public void setupFonts() {
        super.setupFonts();
        this.registerFonts(this.activeConfig.getFonts());
        this.titleFont = this.setupCustomerFont("title");
        this.subtitleFont = this.setupCustomerFont("subtitle");
        this.priceLabelFont = this.setupCustomerFont("priceLabel");
        this.normalFont = this.setupCustomerFont("normal");
        this.productTitleFont = this.setupCustomerFont("productTitle");
        this.cartProductTitleFont = this.setupCustomerFont("cartProductTitle");
        this.cartAddItemsLabelFont = this.setupCustomerFont("cartAddItemsLabel");
        this.cartQuantityLabelFont = this.setupCustomerFont("cartQuantityLabel");
        this.payByCashTextFont = this.setupCustomerFont("payByCashText");
        this.popupTitleFont = this.setupCustomerFont("popupTitle");
        this.confirmationOrderNumberFont = this.setupCustomerFont("confirmationOrderNumberFont");
        this.welcomeMainTitleFont = this.setupCustomerFont("welcomeMainTitle");
        this.welcomeLogoTitleFont = this.setupCustomerFont("welcomeLogoTitle");
        this.welcomeSubtitleFont = this.setupCustomerFont("welcomeSubtitle");
        this.keyboardButtonsFont = this.setupCustomerFont("keyboardButtons");
    }

    public void resetToMainScene() {
        ArrayList openedPopups = new ArrayList(this.activeConfig.getOpenedPopups());
        for (Popup popup : openedPopups) {
            if (popup == null) continue;
            popup.hide();
        }
        super.resetToMainScene();
    }

    void refreshPackaging() {
        HashMap<String, Integer> packagingMap = new HashMap<String, Integer>();
        for (OrderItem orderItem : this.activeConfig.getCurrentOrder().getOrderItems()) {
            if (orderItem.getMainProduct().getPackagingItem().booleanValue()) continue;
            if (orderItem.isMenu()) {
                MenuOption menuOption = orderItem.getMenuOption();
                for (MenuOptionsPackagingSettings packagingSettings : menuOption.getPackaging()) {
                    if (packagingSettings.getQuantity() <= 0) continue;
                    String mapKey = packagingSettings.getPackagingSettingsId().getPackagingProductId();
                    packagingMap.merge(mapKey, packagingSettings.getQuantity() * orderItem.getQuantity(), Integer::sum);
                }
                continue;
            }
            Category category = this.categoryService.findById(Integer.valueOf(orderItem.getMainProduct().getCategory()));
            if (category == null) continue;
            for (MenuOptionsPackagingSettings packagingSettings : category.getPackaging()) {
                if (packagingSettings.getQuantity() <= 0) continue;
                for (int i = 0; i < packagingSettings.getQuantity(); ++i) {
                    String mapKey = packagingSettings.getPackagingSettingsId().getPackagingProductId();
                    packagingMap.merge(mapKey, packagingSettings.getQuantity() * orderItem.getQuantity(), Integer::sum);
                }
            }
        }
        ArrayList oldItems = new ArrayList(this.activeConfig.getCurrentOrder().getOrderItems());
        this.activeConfig.getCurrentOrder().getOrderItems().clear();
        for (OrderItem orderItem : oldItems) {
            if (orderItem.getMainProduct().getPackagingItem().booleanValue()) continue;
            this.activeConfig.getCurrentOrder().getOrderItems().add(orderItem);
        }
        for (Map.Entry entry : packagingMap.entrySet()) {
            OrderItem newItem = new OrderItem(this.productService.findById((String)entry.getKey()));
            newItem.setQuantity(((Integer)entry.getValue()).intValue());
            this.activeConfig.getCurrentOrder().getOrderItems().add(newItem);
        }
    }
}

