/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.models.RecipeStep;
import cz.polreich.spagetka.models.enums.PREPARATION_TYPE;

public class RecipeStepDTO {
    private String id;
    private String productId;
    private int stepOrder;
    private String ingredientId;
    private Double quantity;
    private PREPARATION_TYPE preparationType;

    public RecipeStepDTO(RecipeStep recipeStep) {
        this.id = recipeStep.getId();
        this.productId = recipeStep.getProduct().getId();
        this.stepOrder = recipeStep.getStepOrder();
        this.ingredientId = recipeStep.getIngredient().getId();
        this.quantity = recipeStep.getQuantity();
        this.preparationType = recipeStep.getPreparationType();
    }

    public RecipeStepDTO() {
    }

    public RecipeStepDTO(String id, String productId, int stepOrder, String ingredientId, Double quantity, PREPARATION_TYPE preparationType) {
        this.id = id;
        this.productId = productId;
        this.stepOrder = stepOrder;
        this.ingredientId = ingredientId;
        this.quantity = quantity;
        this.preparationType = preparationType;
    }

    public String getId() {
        return this.id;
    }

    public String getProductId() {
        return this.productId;
    }

    public int getStepOrder() {
        return this.stepOrder;
    }

    public String getIngredientId() {
        return this.ingredientId;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public PREPARATION_TYPE getPreparationType() {
        return this.preparationType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setStepOrder(int stepOrder) {
        this.stepOrder = stepOrder;
    }

    public void setIngredientId(String ingredientId) {
        this.ingredientId = ingredientId;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setPreparationType(PREPARATION_TYPE preparationType) {
        this.preparationType = preparationType;
    }
}

