/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.internet;

import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.event.DummyEvent;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.utils.ExceptionHandler;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Optional;
import javafx.scene.image.Image;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class InternetConnectivityService {
    private static final Logger log = LoggerFactory.getLogger(InternetConnectivityService.class);
    private boolean internetAvailable;
    private boolean partnerWebAvailable;
    private PartnerServerRestClient partnerServerRestClient;
    private Image noPwImage;
    private Image internetImage;
    private Image noInternetImage;
    @Autowired
    private ApplicationEventPublisher publisher;
    private ImageFactory imageFactory;

    @PostConstruct
    private void init() {
        this.checkInternet();
        this.loadImages();
    }

    @Scheduled(fixedRate=30000L)
    @Async
    public void scheduledCheckInternet() {
        log.debug("[SCHEDULED CHECK INTERNET] - executes checking internet");
        this.checkInternet();
        this.publisher.publishEvent((ApplicationEvent)new DummyEvent((Object)this));
        log.debug("[SCHEDULED CHECK INTERNET] - finished checking internet");
    }

    public void checkInternet() {
        if (this.checkPartnerWebReachable()) {
            log.debug("[CHECK INTERNET] - Partner Web is available");
            this.internetAvailable = true;
            this.partnerWebAvailable = true;
        } else if (this.checkInternetAvailable()) {
            log.debug("[CHECK INTERNET] - Partner Web is not available available");
            log.debug("[CHECK INTERNET] - Internet is  available available");
            this.internetAvailable = true;
            this.partnerWebAvailable = false;
        } else {
            log.debug("[CHECK INTERNET] - No Internet");
            this.internetAvailable = false;
            this.partnerWebAvailable = false;
        }
    }

    public Optional<Image> getImage() {
        if (!this.isInternetAvailable()) {
            return Optional.ofNullable(this.noInternetImage);
        }
        if (!this.isPartnerWebAvailable()) {
            return Optional.ofNullable(this.noPwImage);
        }
        return Optional.empty();
    }

    public boolean checkInternetAvailable() {
        this.partnerWebAvailable = this.checkWebsiteReachable("https://www.google.com/");
        return this.partnerWebAvailable;
    }

    public boolean checkPartnerWebReachable() {
        this.partnerWebAvailable = this.partnerServerRestClient.isPartnerWebAvailable();
        return this.partnerWebAvailable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkWebsiteReachable(String urlLink) {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlLink);
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod("HEAD");
            connection.setConnectTimeout(3000);
            connection.setReadTimeout(3000);
            int responseCode = connection.getResponseCode();
            boolean bl = 200 <= responseCode && responseCode <= 399;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private void loadImages() {
        this.noPwImage = this.loadImage("/resources/images/internet/no-pw_80.png");
        this.noInternetImage = this.loadImage("/resources/images/internet/no-internet_80.png");
    }

    private Image loadImage(String path) {
        try {
            Image image = (Image)this.imageFactory.create(path).get();
            log.debug("[CREATING AN IMAGE] - Created new Image with path - {}", (Object)image.getUrl());
            return image;
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            log.error("[CREATING AN IMAGE] - Failed to load image from path: {}", (Object)path, (Object)e);
            return null;
        }
    }

    @Autowired
    public void setPartnerServerRestClient(PartnerServerRestClient partnerServerRestClient) {
        this.partnerServerRestClient = partnerServerRestClient;
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }

    public boolean isInternetAvailable() {
        return this.internetAvailable;
    }

    public boolean isPartnerWebAvailable() {
        return this.partnerWebAvailable;
    }

    public PartnerServerRestClient getPartnerServerRestClient() {
        return this.partnerServerRestClient;
    }

    public Image getNoPwImage() {
        return this.noPwImage;
    }

    public Image getInternetImage() {
        return this.internetImage;
    }

    public Image getNoInternetImage() {
        return this.noInternetImage;
    }

    public ApplicationEventPublisher getPublisher() {
        return this.publisher;
    }

    public ImageFactory getImageFactory() {
        return this.imageFactory;
    }

    public void setInternetAvailable(boolean internetAvailable) {
        this.internetAvailable = internetAvailable;
    }

    public void setPartnerWebAvailable(boolean partnerWebAvailable) {
        this.partnerWebAvailable = partnerWebAvailable;
    }

    public void setNoPwImage(Image noPwImage) {
        this.noPwImage = noPwImage;
    }

    public void setInternetImage(Image internetImage) {
        this.internetImage = internetImage;
    }

    public void setNoInternetImage(Image noInternetImage) {
        this.noInternetImage = noInternetImage;
    }

    public void setPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

