/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.repository;

import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.ORDER_TYPE;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface OrderRepository
extends JpaRepository<Order, String> {
    public List<Order> findByOrderStatus(ORDER_STATUS var1);

    public Order findByOrderNumber(String var1);

    public void deleteByOrderType(ORDER_TYPE var1);

    @Query(value="SELECT o FROM Order o WHERE o.id = :id")
    public Order findByIdQuery(@Param(value="id") String var1);

    @Query(value="SELECT count(id) FROM Order o where day(o.creationDateTime) =:day and month(o.creationDateTime) = :month and year(o.creationDateTime) = :year")
    public long countOrdersByCurrentDate(@Param(value="day") int var1, @Param(value="month") int var2, @Param(value="year") int var3);

    @Query(value="SELECT count(id) FROM Order o where o.creationDateTime >= :date")
    public long countOrderSinceDate(@Param(value="date") LocalDateTime var1);

    @Query(value="SELECT o FROM Order o where o.orderStatus = :order_status and day(o.creationDateTime) =:day and month(o.creationDateTime) = :month and year(o.creationDateTime) = :year ORDER BY o.creationDateTime ASC")
    public List<Order> findAllOrdersByTodayAndOrdersStatus(@Param(value="order_status") ORDER_STATUS var1, @Param(value="day") int var2, @Param(value="month") int var3, @Param(value="year") int var4);

    @Query(value="SELECT o FROM Order o where day(o.creationDateTime) =:day and month(o.creationDateTime) = :month and year(o.creationDateTime) = :year ORDER BY o.creationDateTime ASC")
    public List<Order> findAllOrdersByToday(@Param(value="day") int var1, @Param(value="month") int var2, @Param(value="year") int var3);

    @Query(value="SELECT o FROM Order o where o.orderStatus != :order_status and day(o.creationDateTime) =:day and month(o.creationDateTime) = :month and year(o.creationDateTime) = :year ORDER BY o.creationDateTime ASC")
    public List<Order> findAllOrdersByTodayWithoutOrderStatus(@Param(value="order_status") ORDER_STATUS var1, @Param(value="day") int var2, @Param(value="month") int var3, @Param(value="year") int var4);

    @Query(value="SELECT o FROM Order o WHERE o.creationDateTime >= ?1 AND o.creationDateTime < ?2 ORDER BY o.creationDateTime ASC")
    public List<Order> findCreatedOrdersBetweenDateTimes(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT o FROM Order o WHERE o.creationDateTime >= ?1 AND o.creationDateTime < ?2 and o.orderStatus = ?3 ORDER BY o.creationDateTime ASC")
    public List<Order> findOrdersCreatedBetweenWithOrderStatus(LocalDateTime var1, LocalDateTime var2, ORDER_STATUS var3);

    @Query(value="SELECT count(o.id) FROM Order o where  day(o.creationDateTime) =?1 and month(o.creationDateTime) = ?2 and year(o.creationDateTime) = ?3 and o.orderStatus IN ?4")
    public int countAllOrdersByTodayAndOrdersStatusList(int var1, int var2, int var3, List<ORDER_STATUS> var4);

    @Query(value="SELECT o FROM Order o WHERE o.creationDateTime >= ?1 AND o.creationDateTime < ?2 and o.orderStatus IN ?3 ORDER BY o.creationDateTime ASC")
    public List<Order> findOrdersCreatedBetweenWithOrderStatuses(LocalDateTime var1, LocalDateTime var2, List<ORDER_STATUS> var3);

    @Query(value="SELECT o FROM Order o WHERE o.creationDateTime >= ?1 AND o.creationDateTime < ?2 and o.orderStatus != ?3 ORDER BY o.creationDateTime ASC")
    public List<Order> findOrdersCreatedBetweenWithoutOrderStatus(LocalDateTime var1, LocalDateTime var2, ORDER_STATUS var3);

    @Query(value="SELECT o FROM Order o WHERE o.creationDateTime >= ?1 AND o.creationDateTime < ?2 and o.orderStatus NOT IN ?3 ORDER BY o.creationDateTime ASC")
    public List<Order> findOrdersCreatedBetweenWithoutOrderStatuses(LocalDateTime var1, LocalDateTime var2, List<ORDER_STATUS> var3);

    @Query(value="SELECT o FROM Order o WHERE o.toBeFinishedDateTime >= ?1 AND o.toBeFinishedDateTime < ?2 ORDER BY o.toBeFinishedDateTime ASC")
    public List<Order> findToBeFinishedOrdersBetweenDateTimes(LocalDateTime var1, LocalDateTime var2);

    @Query(value="SELECT o FROM Order o WHERE o.toBeFinishedDateTime >= ?1 AND o.toBeFinishedDateTime < ?2 and o.orderStatus = ?3 ORDER BY o.toBeFinishedDateTime ASC")
    public List<Order> findOrdersToBeFinishedBetweenWithOrderStatus(LocalDateTime var1, LocalDateTime var2, ORDER_STATUS var3);

    @Query(value="SELECT o FROM Order o WHERE o.toBeFinishedDateTime >= ?1 AND o.toBeFinishedDateTime < ?2 and o.orderStatus IN ?3 ORDER BY o.toBeFinishedDateTime ASC")
    public List<Order> findOrdersToBeFinishedBetweenWithOrderStatuses(LocalDateTime var1, LocalDateTime var2, List<ORDER_STATUS> var3);

    @Query(value="SELECT o FROM Order o WHERE o.toBeFinishedDateTime >= ?1 AND o.toBeFinishedDateTime < ?2 and o.orderStatus != ?3 ORDER BY o.toBeFinishedDateTime ASC")
    public List<Order> findOrdersToBeFinishedBetweenWithoutOrderStatus(LocalDateTime var1, LocalDateTime var2, ORDER_STATUS var3);

    @Query(value="SELECT o FROM Order o WHERE o.toBeFinishedDateTime >= ?1 AND o.toBeFinishedDateTime < ?2 and o.orderStatus NOT IN ?3 ORDER BY o.toBeFinishedDateTime ASC")
    public List<Order> findOrdersToBeFinishedBetweenWithoutOrderStatuses(LocalDateTime var1, LocalDateTime var2, List<ORDER_STATUS> var3);

    @Query(value="SELECT o FROM Order o where o.orderNumber = :order_number and day(o.creationDateTime) =:day and month(o.creationDateTime) = :month and year(o.creationDateTime) = :year")
    public Order findByOrderNumberByToday(@Param(value="order_number") String var1, @Param(value="day") int var2, @Param(value="month") int var3, @Param(value="year") int var4);

    @Query(value="    SELECT o FROM Order o\n    WHERE o.orderStatus IN :order_statuses\n      AND DAY(o.creationDateTime) = :day\n      AND MONTH(o.creationDateTime) = :month\n      AND YEAR(o.creationDateTime) = :year\n    ORDER BY o.toBeFinishedDateTime DESC\n")
    public List<Order> findByOrderStatusesAndByTodayAndTheNewestOnTHeTop(@Param(value="order_statuses") List<ORDER_STATUS> var1, @Param(value="day") int var2, @Param(value="month") int var3, @Param(value="year") int var4);

    @Query(value="SELECT o.id FROM Order o")
    public List<String> findAllIds();

    @Query(value="SELECT o FROM Order o WHERE o.id = :id")
    public Order findByIdNamed(@Param(value="id") String var1);

    @Query(value="SELECT o FROM Order o WHERE o.toBeFinishedDateTime <= :date_time AND o.orderStatus IN :order_statuses ORDER BY o.toBeFinishedDateTime ASC")
    public List<Order> findOrderWithToBeFinishedInBeforeDateTimeWithOrderStatuses(@Param(value="date_time") LocalDateTime var1, @Param(value="order_statuses") List<ORDER_STATUS> var2);

    public List<Order> findByOrderTypeInAndOrderStatusIn(List<ORDER_TYPE> var1, List<ORDER_STATUS> var2);

    @Query(value="Select o from Order o where o.orderNumber = :orderNumber")
    public List<Order> findAllByOrderNumber(@Param(value="orderNumber") String var1);

    @Query(value="SELECT DISTINCT o.orderNumber FROM Order o where o.creationDateTime >= :date")
    public Set<String> findAllOrderNumbersSinceDate(@Param(value="date") LocalDateTime var1);

    @Modifying
    @Query(value="UPDATE Order o SET o.announced = :newValue WHERE o.id = :id")
    public void setAnnounced(@Param(value="newValue") boolean var1, String var2);
}

