/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.CountryPrefix;
import cz.polreich.spagetka.models.config.BaseConfig;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.CommonConfig;
import cz.polreich.spagetka.models.config.CookConfig;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    @JsonProperty
    private CommonConfig common;
    @JsonProperty
    private CashierConfig cashier;
    @JsonProperty
    private CustomerConfig customer;
    @JsonProperty
    private CookConfig cook;
    @JsonIgnore
    public BaseConfig selectedConfig;
    @JsonIgnore
    public LocalDateTime successMonitoringReportTime;
    private ResourceHelper resourceHelper;
    private ImageFactory imageFactory;

    public void setCashierSelected() {
        this.setSelectedConfig((BaseConfig)this.cashier);
    }

    public void setCustomerSelected() {
        this.setSelectedConfig((BaseConfig)this.customer);
    }

    public void setCookSelected() {
        this.setSelectedConfig((BaseConfig)this.cook);
    }

    public void setSelectedConfig(BaseConfig selectedConfig) {
        this.selectedConfig = selectedConfig;
        if (this.common != null) {
            BeanUtils.copyProperties((Object)this.common, (Object)this.selectedConfig);
        }
    }

    public List<CountryPrefix> loadCountryPrefixes() {
        ObjectMapper objectMapper = new ObjectMapper();
        Collection countryPrefixDataList = null;
        InputStream resourceStream = this.resourceHelper.getResourceAsStream("/resources/countries.json");
        try {
            countryPrefixDataList = (List)objectMapper.readValue((Reader)new InputStreamReader(resourceStream), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
        }
        if (countryPrefixDataList != null) {
            return countryPrefixDataList.stream().map(data -> new CountryPrefix(data.getCountry(), data.getPrefix(), (Image)this.imageFactory.create("/resources/images/flags/" + data.getCountryCode() + ".png").get(), data.getPattern())).collect(Collectors.toList());
        }
        return new ArrayList<CountryPrefix>();
    }

    @Autowired
    public void setResourceHelper(ResourceHelper resourceHelper) {
        this.resourceHelper = resourceHelper;
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }

    public CommonConfig getCommon() {
        return this.common;
    }

    @JsonProperty
    public void setCommon(CommonConfig common) {
        this.common = common;
    }

    public CashierConfig getCashier() {
        return this.cashier;
    }

    @JsonProperty
    public void setCashier(CashierConfig cashier) {
        this.cashier = cashier;
    }

    public CustomerConfig getCustomer() {
        return this.customer;
    }

    @JsonProperty
    public void setCustomer(CustomerConfig customer) {
        this.customer = customer;
    }

    public CookConfig getCook() {
        return this.cook;
    }

    @JsonProperty
    public void setCook(CookConfig cook) {
        this.cook = cook;
    }

    public BaseConfig getSelectedConfig() {
        return this.selectedConfig;
    }

    public LocalDateTime getSuccessMonitoringReportTime() {
        return this.successMonitoringReportTime;
    }

    @JsonIgnore
    public void setSuccessMonitoringReportTime(LocalDateTime successMonitoringReportTime) {
        this.successMonitoringReportTime = successMonitoringReportTime;
    }
}

