/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.OrderDTO;
import cz.polreich.spagetka.models.DeliveryAddress;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.ORDER_TYPE;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.service.UserService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import cz.polreich.spagetka.utils.ExceptionHandler;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.security.InvalidParameterException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.springframework.stereotype.Component;

@Entity
@Component
@Access(value=AccessType.PROPERTY)
@Table(name="Orders")
public class Order {
    private String id;
    private String customerFirstName;
    private String customerLastName;
    @Transient
    private StringProperty customerPhoneNumber = new SimpleStringProperty("");
    private int customerId;
    private String orderNumber;
    private LocalDateTime creationDateTime;
    private LocalDateTime toBeFinishedDateTime;
    private ORDER_TYPE orderType;
    @Transient
    private ListProperty<OrderItem> orderItems = new SimpleListProperty(FXCollections.observableArrayList());
    private ORDER_STATUS orderStatus;
    private double subTotalPrice;
    private DoubleProperty tip = new SimpleDoubleProperty(0.0);
    private DoubleProperty deliveryCost = new SimpleDoubleProperty(0.0);
    private DoubleProperty discountPercentage = new SimpleDoubleProperty(0.0);
    private DoubleProperty discount = new SimpleDoubleProperty(0.0);
    private PAYMENT_METHOD paymentMethod;
    @Transient
    private SimpleDoubleProperty totalPrice = new SimpleDoubleProperty(0.0);
    private Boolean announced = false;
    private User userConfirmed;
    private User userFinished;
    private String discountCode;
    private String customerDescription;
    private LocalDateTime expectedResponseTime;
    @Transient
    private String cleanOrderNumber;
    private Boolean stickersPrinted = false;
    private Boolean customerRegistered;
    private Boolean customerFirstOrder;
    private Boolean customerEvaluated = false;
    private DeliveryAddress deliveryAddress;
    private LocalDateTime deliveryTime;

    public Order() {
        this.orderItems.addListener((observable, oldValue, newValue) -> {
            this.updateTotalPrice();
            this.listenToQuantityChanges(newValue);
        });
        this.discountPercentage.addListener((observable, oldValue, newValue) -> this.updateTotalPrice());
        this.discount.addListener((observable, oldValue, newValue) -> this.updateTotalPrice());
        this.tip.addListener((observable, oldValue, newValue) -> this.updateTotalPrice());
    }

    private void updateTotalPrice() {
        this.subTotalPrice = this.orderItems.stream().mapToDouble(o -> o.getFinalPrice() * (double)o.getQuantity()).sum();
        if (this.discountPercentage.get() > 0.0) {
            this.discount.set(Math.ceil(this.subTotalPrice / 100.0 * this.discountPercentage.get()));
            if (this.discount.get() <= this.subTotalPrice) {
                this.setTotalPrice(Double.valueOf(this.subTotalPrice - this.discount.get() + this.tip.get()));
            } else {
                this.setTotalPrice(Double.valueOf(this.tip.get()));
            }
        } else if (this.discount.get() <= this.subTotalPrice) {
            this.setTotalPrice(Double.valueOf(this.subTotalPrice - this.discount.get() + this.tip.get()));
        } else {
            this.setTotalPrice(Double.valueOf(this.tip.get()));
        }
    }

    private void listenToQuantityChanges(ObservableList<OrderItem> items) {
        for (OrderItem item : items) {
            item.quantityProperty().addListener((observable, oldValue, newValue) -> this.updateTotalPrice());
        }
    }

    public DoubleProperty discountPercentageProperty() {
        return this.discountPercentage;
    }

    @Column(name="discountPercentage")
    public double getDiscountPercentage() {
        return this.discountPercentage == null ? 0.0 : this.discountPercentage.get();
    }

    public void setDiscountPercentage(Double value) {
        if (this.discountPercentage == null) {
            this.discountPercentage = new SimpleDoubleProperty(0.0);
        }
        this.discountPercentage.set(value == null ? 0.0 : value);
    }

    public SimpleDoubleProperty totalPriceProperty() {
        return this.totalPrice;
    }

    @Column(name="totalPrice")
    public double getTotalPrice() {
        return this.totalPrice == null ? 0.0 : this.totalPrice.get();
    }

    public void setTotalPrice(Double value) {
        if (this.totalPrice == null) {
            this.totalPrice = new SimpleDoubleProperty(0.0);
        }
        this.totalPrice.set(value == null ? 0.0 : value);
    }

    public ListProperty<OrderItem> orderItemsProperty() {
        return this.orderItems;
    }

    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="ItemsOfOrders", joinColumns={@JoinColumn(name="orderId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="itemId", referencedColumnName="id")})
    public List<OrderItem> getOrderItems() {
        return (List)this.orderItems.get();
    }

    public void setOrderItems(List<OrderItem> value) {
        if (!value.isEmpty()) {
            ObservableList list = FXCollections.observableArrayList(value);
            this.orderItems.set((Object)list);
        }
    }

    @OneToOne(cascade={CascadeType.ALL})
    @JoinColumn(name="addressId", referencedColumnName="id")
    public DeliveryAddress getDeliveryAddress() {
        return this.deliveryAddress;
    }

    @Column(name="tip")
    public double getTip() {
        return this.tip == null ? 0.0 : this.tip.get();
    }

    public void setTip(Double value) {
        if (this.tip == null) {
            this.tip = new SimpleDoubleProperty(0.0);
        }
        this.tip.set(value == null ? 0.0 : value);
    }

    @Column(name="delivery_cost")
    public double getDeliveryCost() {
        return this.deliveryCost == null ? 0.0 : this.deliveryCost.get();
    }

    public void setDeliveryCost(Double value) {
        if (this.deliveryCost == null) {
            this.deliveryCost = new SimpleDoubleProperty(0.0);
        }
        this.deliveryCost.set(value == null ? 0.0 : value);
    }

    @Column(name="delivery_time")
    public LocalDateTime getDeliveryTime() {
        return this.deliveryTime;
    }

    public Order(OrderDTO dto) {
        this.id = dto.getId();
        this.customerFirstName = dto.getCustomerFirstName();
        this.customerLastName = dto.getCustomerLastName();
        this.customerPhoneNumber.set((Object)dto.getCustomerPhoneNumber());
        this.customerId = dto.getCustomerId();
        this.orderNumber = dto.getOrderNumber();
        this.creationDateTime = LocalDateTime.parse(dto.getCreationDateTime());
        this.toBeFinishedDateTime = LocalDateTime.parse(dto.getToBeFinishedDateTime());
        this.orderType = ORDER_TYPE.valueOf((String)dto.getOrderType());
        this.setOrderItems(dto.getOrderItems().stream().map(OrderItem::new).toList());
        this.orderStatus = ORDER_STATUS.valueOf((String)dto.getOrderStatus());
        this.subTotalPrice = dto.getSubTotalPrice();
        this.setDiscount(dto.getDiscount());
        this.paymentMethod = PAYMENT_METHOD.valueOf((String)dto.getPaymentMethod());
        this.totalPrice.set(dto.getTotalPrice().doubleValue());
        UserService userService = (UserService)ApplicationContextUtils.getApplicationContext().getBean(UserService.class);
        if (dto.getUserConfirmedId() != null) {
            if (userService.existsById(dto.getUserConfirmedId().intValue())) {
                this.userConfirmed = userService.findById(dto.getUserConfirmedId().intValue());
            } else {
                throw new InvalidParameterException("User with ID " + dto.getUserConfirmedId() + " not found.");
            }
        }
        if (dto.getUserFinishedId() != null) {
            if (userService.existsById(dto.getUserFinishedId().intValue())) {
                this.userFinished = userService.findById(dto.getUserFinishedId().intValue());
            } else {
                throw new InvalidParameterException("User with ID " + dto.getUserFinishedId() + " not found.");
            }
        }
        this.discountCode = dto.getDiscountCode();
        this.customerDescription = dto.getCustomerDescription();
        this.deliveryAddress = new DeliveryAddress(dto.getDeliveryAddress());
        this.tip.set(dto.getTipAmount().doubleValue());
        this.deliveryCost.set(dto.getDeliveryCost().doubleValue());
        if (dto.getDeliveryAddress().getDeliveryTime() != null) {
            this.deliveryTime = LocalDateTime.parse(dto.getDeliveryAddress().getDeliveryTime(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        }
    }

    public void addOrderItem(OrderItem orderItem) {
        this.addOrderItem(orderItem, true);
    }

    public void addOrderItem(OrderItem orderItem, boolean stack) {
        boolean orderItemExists = this.orderItems.stream().anyMatch(o -> o.areSameProductAndMenuOption(orderItem));
        if (orderItemExists && stack) {
            this.orderItems.stream().filter(o -> o.areSameProductAndMenuOption(orderItem)).forEach(n -> n.setQuantity(n.getQuantity() + orderItem.getQuantity()));
        } else {
            this.orderItems.add((Object)orderItem);
        }
    }

    public void removeOrderItem(OrderItem orderItem) {
        OrderItem existingOrderItem = this.orderItems.stream().filter(o -> o.getMainProduct().getId().equals(orderItem.getMainProduct().getId()) && o.getFinalPrice() == orderItem.getFinalPrice() && o.areSameProductAndMenuOption(orderItem)).findFirst().orElse(null);
        if (existingOrderItem != null) {
            this.orderItems.remove((Object)existingOrderItem);
        }
    }

    @Column
    public double getSubTotalPrice() {
        return this.subTotalPrice;
    }

    @Id
    public String getId() {
        return this.id;
    }

    @Column
    public String getCustomerFirstName() {
        return this.customerFirstName;
    }

    @Column
    public String getCustomerLastName() {
        return this.customerLastName;
    }

    @Transient
    public String getCustomerFullName() {
        if (this.customerLastName != null && !this.customerLastName.trim().isEmpty()) {
            return this.customerFirstName + " " + this.customerLastName;
        }
        if (this.customerFirstName != null && !this.customerFirstName.trim().isEmpty()) {
            return this.customerFirstName;
        }
        return "";
    }

    public StringProperty customerPhoneNumberProperty() {
        return this.customerPhoneNumber;
    }

    @Column(name="customerPhoneNumber")
    public String getCustomerPhoneNumber() {
        return (String)this.customerPhoneNumber.get();
    }

    public void setCustomerPhoneNumber(String value) {
        this.customerPhoneNumber.set((Object)value);
    }

    public DoubleProperty discountProperty() {
        return this.discount;
    }

    @Column(name="discount")
    public double getDiscount() {
        return this.discount == null ? 0.0 : this.discount.get();
    }

    public void setDiscount(Double value) {
        if (this.discount == null) {
            this.discount = new SimpleDoubleProperty(0.0);
        }
        this.discount.set(value == null ? 0.0 : value);
    }

    @Column
    public int getCustomerId() {
        return this.customerId;
    }

    @Column
    public String getOrderNumber() {
        return this.orderNumber;
    }

    @Column
    public LocalDateTime getCreationDateTime() {
        return this.creationDateTime;
    }

    @Column
    public LocalDateTime getToBeFinishedDateTime() {
        return this.toBeFinishedDateTime;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public ORDER_TYPE getOrderType() {
        return this.orderType;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public ORDER_STATUS getOrderStatus() {
        return this.orderStatus;
    }

    @Column
    @Enumerated(value=EnumType.STRING)
    public PAYMENT_METHOD getPaymentMethod() {
        return this.paymentMethod;
    }

    @Column
    public boolean isAnnounced() {
        return this.announced;
    }

    @ManyToOne
    @JoinColumn(name="user_confirmed_id")
    public User getUserConfirmed() {
        return this.userConfirmed;
    }

    @ManyToOne
    @JoinColumn(name="user_finished_id")
    public User getUserFinished() {
        return this.userFinished;
    }

    @Column
    public String getDiscountCode() {
        return this.discountCode;
    }

    @Column
    public String getCustomerDescription() {
        return this.customerDescription;
    }

    @Column
    public LocalDateTime getExpectedResponseTime() {
        return this.expectedResponseTime;
    }

    @Transient
    public String getCleanOrderNumber(boolean includeLetter) {
        if (this.orderNumber != null && !this.orderNumber.isEmpty()) {
            if (this.orderNumber.matches("[A-Z]?[0-9]{1,3}")) {
                String prefix = Character.isLetter(this.orderNumber.charAt(0)) ? this.orderNumber.substring(0, 1) : "";
                String numberPart = prefix.isEmpty() ? this.orderNumber : this.orderNumber.substring(1);
                int number = Integer.parseInt(numberPart);
                if (includeLetter) {
                    return prefix + number;
                }
                return String.valueOf(number);
            }
            ExceptionHandler.logException((Exception)new IllegalArgumentException("Invalid input format: " + this.orderNumber));
            return this.orderNumber;
        }
        return "";
    }

    @Column
    public Boolean isStickersPrinted() {
        return this.stickersPrinted;
    }

    @Column
    public Boolean isCustomerRegistered() {
        return this.customerRegistered;
    }

    @Column
    public Boolean isCustomerFirstOrder() {
        return this.customerFirstOrder;
    }

    @Column
    public Boolean isCustomerEvaluated() {
        return this.customerEvaluated;
    }

    @Transient
    public boolean isDelivery() {
        return this.orderType.equals((Object)ORDER_TYPE.DELIVERY) || this.orderType.equals((Object)ORDER_TYPE.FOODORA) || this.orderType.equals((Object)ORDER_TYPE.WOLT) || this.orderType.equals((Object)ORDER_TYPE.BOLT);
    }

    @Transient
    public boolean isPickup() {
        return this.orderType.equals((Object)ORDER_TYPE.PERSONAL_HERE) || this.orderType.equals((Object)ORDER_TYPE.PERSONAL_TAKE_AWAY) || this.orderType.equals((Object)ORDER_TYPE.DELIVERY_PICKUP) || this.orderType.equals((Object)ORDER_TYPE.FOODORA_PICKUP) || this.orderType.equals((Object)ORDER_TYPE.WOLT_PICKUP) || this.orderType.equals((Object)ORDER_TYPE.BOLT_PICKUP);
    }

    @Transient
    public boolean isPersonal() {
        return this.orderType.equals((Object)ORDER_TYPE.PERSONAL_HERE) || this.orderType.equals((Object)ORDER_TYPE.PERSONAL_TAKE_AWAY);
    }

    @Transient
    public boolean isSchedulable() {
        List<ORDER_TYPE> orderTypes = Arrays.asList(ORDER_TYPE.ONLINE, ORDER_TYPE.WOLT, ORDER_TYPE.BOLT, ORDER_TYPE.FOODORA, ORDER_TYPE.WOLT_PICKUP, ORDER_TYPE.BOLT_PICKUP, ORDER_TYPE.FOODORA_PICKUP, ORDER_TYPE.DELIVERY);
        return orderTypes.contains(this.orderType);
    }

    @Transient
    public boolean isOnline() {
        return this.orderType.equals((Object)ORDER_TYPE.ONLINE);
    }

    @Transient
    public boolean canBeCancelled() {
        if (this.isPersonal()) {
            return !this.orderStatus.equals((Object)ORDER_STATUS.CANCELLED);
        }
        return !this.orderStatus.equals((Object)ORDER_STATUS.PREPARING) && !this.orderStatus.equals((Object)ORDER_STATUS.CANCELLED);
    }

    @Transient
    public boolean canBePrepared() {
        return this.orderStatus.equals((Object)ORDER_STATUS.CONFIRMED);
    }

    @Transient
    public boolean canBeConfirmed() {
        return this.orderStatus.equals((Object)ORDER_STATUS.WAITING_FOR_PAYMENT) || this.orderStatus.equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT);
    }

    @Transient
    public boolean canBeFinished() {
        return this.orderStatus.equals((Object)ORDER_STATUS.WAITING_FOR_PICKUP) || this.orderStatus.equals((Object)ORDER_STATUS.WAITING_FOR_DELIVERY);
    }

    @Transient
    public boolean isPaid() {
        return !this.orderStatus.equals((Object)ORDER_STATUS.WAITING_FOR_PAYMENT) && !this.orderStatus.equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT);
    }

    @Transient
    public boolean isTaxRelevant() {
        return true;
    }

    @Transient
    public boolean isDiscountApplied() {
        return this.discountPercentage.get() > 0.0 || this.discount.get() > 0.0;
    }

    @Transient
    public boolean shouldPrintReceiptOnPickupState() {
        return ORDER_TYPE.ONLINE.equals((Object)this.orderType) || ORDER_TYPE.WOLT.equals((Object)this.orderType) || ORDER_TYPE.WOLT_PICKUP.equals((Object)this.orderType);
    }

    @Transient
    public boolean containsItemOfCategory(int category) {
        return this.orderItems != null && !this.orderItems.isEmpty() && this.orderItems.stream().anyMatch(oi -> oi.getMainProduct().getCategory() == category);
    }

    public String toString() {
        return "Order{id='" + this.id + "', creationDateTime=" + this.creationDateTime + ", toBeFinishedDateTime=" + this.toBeFinishedDateTime + ", orderType=" + this.orderType + ", orderItems=" + this.orderItems + ", orderStatus=" + this.orderStatus + ", subTotalPrice=" + this.subTotalPrice + ", discount=" + this.discountPercentage + ", totalPrice=" + this.totalPrice + "}";
    }

    public Order(String id, String customerFirstName, String customerLastName, StringProperty customerPhoneNumber, int customerId, String orderNumber, LocalDateTime creationDateTime, LocalDateTime toBeFinishedDateTime, ORDER_TYPE orderType, ListProperty<OrderItem> orderItems, ORDER_STATUS orderStatus, double subTotalPrice, DoubleProperty tip, DoubleProperty deliveryCost, DoubleProperty discountPercentage, DoubleProperty discount, PAYMENT_METHOD paymentMethod, SimpleDoubleProperty totalPrice, Boolean announced, User userConfirmed, User userFinished, String discountCode, String customerDescription, LocalDateTime expectedResponseTime, String cleanOrderNumber, Boolean stickersPrinted, Boolean customerRegistered, Boolean customerFirstOrder, Boolean customerEvaluated, DeliveryAddress deliveryAddress, LocalDateTime deliveryTime) {
        this.id = id;
        this.customerFirstName = customerFirstName;
        this.customerLastName = customerLastName;
        this.customerPhoneNumber = customerPhoneNumber;
        this.customerId = customerId;
        this.orderNumber = orderNumber;
        this.creationDateTime = creationDateTime;
        this.toBeFinishedDateTime = toBeFinishedDateTime;
        this.orderType = orderType;
        this.orderItems = orderItems;
        this.orderStatus = orderStatus;
        this.subTotalPrice = subTotalPrice;
        this.tip = tip;
        this.deliveryCost = deliveryCost;
        this.discountPercentage = discountPercentage;
        this.discount = discount;
        this.paymentMethod = paymentMethod;
        this.totalPrice = totalPrice;
        this.announced = announced;
        this.userConfirmed = userConfirmed;
        this.userFinished = userFinished;
        this.discountCode = discountCode;
        this.customerDescription = customerDescription;
        this.expectedResponseTime = expectedResponseTime;
        this.cleanOrderNumber = cleanOrderNumber;
        this.stickersPrinted = stickersPrinted;
        this.customerRegistered = customerRegistered;
        this.customerFirstOrder = customerFirstOrder;
        this.customerEvaluated = customerEvaluated;
        this.deliveryAddress = deliveryAddress;
        this.deliveryTime = deliveryTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setCustomerFirstName(String customerFirstName) {
        this.customerFirstName = customerFirstName;
    }

    public void setCustomerLastName(String customerLastName) {
        this.customerLastName = customerLastName;
    }

    public void setCustomerId(int customerId) {
        this.customerId = customerId;
    }

    public void setOrderNumber(String orderNumber) {
        this.orderNumber = orderNumber;
    }

    public void setCreationDateTime(LocalDateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public void setToBeFinishedDateTime(LocalDateTime toBeFinishedDateTime) {
        this.toBeFinishedDateTime = toBeFinishedDateTime;
    }

    public void setOrderType(ORDER_TYPE orderType) {
        this.orderType = orderType;
    }

    public void setOrderStatus(ORDER_STATUS orderStatus) {
        this.orderStatus = orderStatus;
    }

    public void setSubTotalPrice(double subTotalPrice) {
        this.subTotalPrice = subTotalPrice;
    }

    public void setPaymentMethod(PAYMENT_METHOD paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public void setAnnounced(Boolean announced) {
        this.announced = announced;
    }

    public void setUserConfirmed(User userConfirmed) {
        this.userConfirmed = userConfirmed;
    }

    public void setUserFinished(User userFinished) {
        this.userFinished = userFinished;
    }

    public void setDiscountCode(String discountCode) {
        this.discountCode = discountCode;
    }

    public void setCustomerDescription(String customerDescription) {
        this.customerDescription = customerDescription;
    }

    public void setExpectedResponseTime(LocalDateTime expectedResponseTime) {
        this.expectedResponseTime = expectedResponseTime;
    }

    public void setStickersPrinted(Boolean stickersPrinted) {
        this.stickersPrinted = stickersPrinted;
    }

    public void setCustomerRegistered(Boolean customerRegistered) {
        this.customerRegistered = customerRegistered;
    }

    public void setCustomerFirstOrder(Boolean customerFirstOrder) {
        this.customerFirstOrder = customerFirstOrder;
    }

    public void setCustomerEvaluated(Boolean customerEvaluated) {
        this.customerEvaluated = customerEvaluated;
    }

    public void setDeliveryAddress(DeliveryAddress deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }

    public void setDeliveryTime(LocalDateTime deliveryTime) {
        this.deliveryTime = deliveryTime;
    }
}

