/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class LogOutPopup
extends Popup {
    private CashierController cashierController;

    public LogOutPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        AnchorPane popupAnchor = new AnchorPane();
        popupAnchor.getStyleClass().add((Object)"logout_anchor_pane");
        Label label = new Label(cashierController.strings.getString("logoutMessage"));
        label.setTextFill((Paint)Color.web((String)"#75d2f4"));
        label.setStyle("-fx-font-size: 24px;");
        AnchorPane.setTopAnchor((Node)label, (Double)50.0);
        AnchorPane.setLeftAnchor((Node)label, (Double)150.0);
        AnchorPane.setRightAnchor((Node)label, (Double)150.0);
        Button cancelButton = new Button(cashierController.strings.getString("cancel"));
        cancelButton.setMinSize(70.0, 40.0);
        AnchorPane.setBottomAnchor((Node)cancelButton, (Double)40.0);
        AnchorPane.setLeftAnchor((Node)cancelButton, (Double)100.0);
        cancelButton.getStyleClass().add((Object)"logout_button");
        Button okButton = new Button(cashierController.strings.getString("logout"));
        okButton.setMinSize(70.0, 40.0);
        AnchorPane.setBottomAnchor((Node)okButton, (Double)40.0);
        AnchorPane.setRightAnchor((Node)okButton, (Double)100.0);
        okButton.setOnMouseClicked(mouseEvent -> this.logoutAction());
        okButton.setOnTouchPressed(touchEvent -> this.logoutAction());
        okButton.getStyleClass().add((Object)"logout_button");
        popupAnchor.setMinWidth(400.0);
        popupAnchor.setMinHeight(400.0);
        popupAnchor.getChildren().addAll((Object[])new Node[]{label, cancelButton, okButton});
        this.getContent().add((Object)popupAnchor);
        cancelButton.setOnMouseClicked(mouseEvent -> this.hide());
        cancelButton.setOnTouchPressed(touchEvent -> this.hide());
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void logoutAction() {
        this.hide();
        this.cashierController.userLogOut();
    }
}

