/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.loading;

import cz.polreich.spagetka.CustomerApp;
import cz.polreich.spagetka.MDBController;
import cz.polreich.spagetka.controllers.CustomerMainController;
import cz.polreich.spagetka.controllers.loading.BaseLoadingController;
import cz.polreich.spagetka.controllers.loading.CustomerLoadingController;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.config.CustomerConfig;
import cz.polreich.spagetka.models.config.MDBConfig;
import cz.polreich.spagetka.models.config.ScreenResolution;
import cz.polreich.spagetka.service.internet.InternetConnectivityService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import cz.polreich.spagetka.utils.BugsnagSingleton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.fxml.Initializable;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextArea;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Screen;
import javafx.util.Pair;
import javax.annotation.PostConstruct;
import javax.print.PrintService;
import org.scenicview.ScenicView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CustomerLoadingController
extends BaseLoadingController
implements Initializable {
    private static final Logger log = LoggerFactory.getLogger(CustomerLoadingController.class);
    public CustomerConfig activeConfig;
    @FXML
    private Label titleLabel;
    @FXML
    private VBox mainVBox;
    @FXML
    private Button startButton;
    private CustomerMainController customerMainController;
    private ScreenResolution screenResolution;
    private boolean failure = false;
    private BooleanProperty start = new SimpleBooleanProperty(true);
    private URL cssFile = this.getClass().getResource("/cz/polreich/spagetka/main.css");
    private ImageFactory imageFactory = new ImageFactory(new ResourceHelper());
    private InternetConnectivityService internetConnectivityService;

    @PostConstruct
    public void init() {
        this.activeConfig = this.config.getCustomer();
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.bugsnag = BugsnagSingleton.getInstance((String)"e8c5ff74682edb48da9e0f3a4cede7cb");
        ExceptionHandler globalExceptionHandler = new ExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)globalExceptionHandler);
        this.titleLabel.setText("Customer Loading");
        this.titleLabel.setStyle("-fx-font-size: 24px");
        this.mainVBox.setSpacing(20.0);
        this.startButton.visibleProperty().bind((ObservableValue)this.start.not());
        this.startButton.setOnMouseClicked(mouseEvent -> this.runApp());
        this.startButton.setOnTouchPressed(touchEvent -> this.runApp());
    }

    public void setupScene() {
        super.setupScene();
        this.initializeApp();
    }

    public void initializeApp() {
        this.bugsnag.addToTab("location", "kioskName", this.activeConfig.getKioskName());
        1 task = new /* Unavailable Anonymous Inner Class!! */;
        new Thread((Runnable)task).start();
    }

    protected void setKioskInfo(KioskInfo kioskInfo) {
        this.config.getCommon().setKioskInfo(kioskInfo);
        this.config.getCustomer().setKioskInfo(kioskInfo);
    }

    private void runTaskSection(String key, String message, String imagePath, Runnable taskLogic) {
        AtomicReference taskRow = new AtomicReference();
        Platform.runLater(() -> taskRow.set(this.createLoadingEntry(key, message, imagePath)));
        try {
            taskLogic.run();
            Platform.runLater(() -> this.confirmItemSection((Pair)taskRow.get()));
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            this.failure = true;
            Platform.runLater(() -> {
                this.failItemSection((Pair)taskRow.get(), e.getMessage());
                ExceptionHandler.logException((Exception)e);
            });
        }
    }

    private void confirmItemSection(Pair<HBox, TextArea> pair) {
        HBox hbox = (HBox)pair.getKey();
        TextArea textArea = (TextArea)pair.getValue();
        textArea.setText("Done");
    }

    private void failItemSection(Pair<HBox, TextArea> pair, String message) {
        HBox hbox = (HBox)pair.getKey();
        TextArea textArea = (TextArea)pair.getValue();
        textArea.setText(message);
    }

    private void loadDataFromDB() {
        this.activeConfig.getCurrentOffer().setCategories(this.categoryService.findAll());
        this.activeConfig.getCurrentOffer().setMenuOptions(this.menuOptionService.findAll());
        this.activeConfig.getCurrentOffer().setProducts(this.productService.findAll());
        this.activeConfig.getCurrentOffer().setProductsGroups(this.productsGroupService.findAll());
    }

    private void initMDB() {
        MDBConfig mdbConfig = this.activeConfig.getMdbConfig();
        MDBController mdbController = new MDBController(mdbConfig.getPort(), mdbConfig.getBaudRate(), mdbConfig.getBitLength(), mdbConfig.getStopBits());
        this.activeConfig.setMdbController(mdbController);
        boolean cashlessInited = mdbController.checkCashlessInited();
        System.out.println("A: " + cashlessInited);
        if (cashlessInited) {
            boolean cashlessActive = mdbController.checkCashlessActive();
            System.out.println("B: " + cashlessActive);
            if (!cashlessActive) {
                cashlessActive = mdbController.enableCashless(true);
                System.out.println("C: " + cashlessActive);
                if (!cashlessActive) {
                    System.out.println("Cashless device is inited, but cannot be enabled.");
                    throw new IllegalStateException("Cashless device is inited, but cannot be enabled.");
                }
                Pair status = mdbController.getCashlessStatus();
                System.out.println("I: " + status);
            } else {
                Pair status = mdbController.getCashlessStatus();
                System.out.println("H: " + status);
            }
        } else {
            System.out.println("Cashless device not Inited. Check if it's connected and powered on.");
            throw new IllegalStateException("Cashless device not Inited. Check if it's connected and powered on.");
        }
    }

    private void preparePrinter() throws Exception {
        String printerName = this.activeConfig.getPrinterConfig().getPrinterName();
        String encoding = this.activeConfig.getPrinterConfig().getCodepage();
        boolean alarmEnabled = this.activeConfig.getPrinterConfig().isPaperEndAlarmEnabled();
        PrintService service = ReceiptPrinter.findPrintService((String)printerName);
        if (service == null) {
            throw new Exception("Printer with the name " + printerName + " not found. Make sure it's connected and the name is configured correctly.");
        }
        ReceiptPrinter.setPaperEndAlarm((String)printerName, (boolean)alarmEnabled);
        ReceiptPrinter.setPrinterEncoding((String)printerName, (String)encoding);
    }

    private Pair<HBox, TextArea> createLoadingEntry(String id, String text, String imagePath) {
        Image image = (Image)this.imageFactory.create(imagePath).get();
        ImageView imageView = new ImageView(image);
        imageView.setPreserveRatio(true);
        imageView.setFitHeight(50.0);
        imageView.setFitWidth(50.0);
        Label label = new Label(text);
        label.setStyle("-fx-font-size: 16px");
        label.setAlignment(Pos.CENTER_LEFT);
        label.setMaxWidth(330.0);
        label.setMinWidth(330.0);
        label.setPadding(LayoutUtils.getInsets((double)0.0, (double)10.0, (double)0.0, (double)10.0));
        TextArea result = new TextArea();
        result.setId(id + "_result");
        result.setWrapText(true);
        result.setEditable(false);
        result.setMaxWidth(200.0);
        result.setMinHeight(50.0);
        result.setMaxHeight(50.0);
        HBox hbox = new HBox();
        hbox.getChildren().addAll((Object[])new Node[]{imageView, label, result});
        hbox.setAlignment(Pos.CENTER);
        this.mainVBox.getChildren().add((Object)hbox);
        Pair pair = new Pair((Object)hbox, (Object)result);
        return pair;
    }

    private void runApp() {
        try {
            Rectangle2D screenBounds;
            this.stage.close();
            ResourceBundle strings = ResourceBundle.getBundle("resources.strings.customer", this.activeConfig.getSelectedLocale());
            FXMLLoader loader = new FXMLLoader(CustomerApp.class.getResource("main.fxml"), strings);
            loader.setControllerFactory(arg_0 -> ((ApplicationContext)ApplicationContextUtils.getApplicationContext()).getBean(arg_0));
            Parent root = (Parent)loader.load();
            this.customerMainController = (CustomerMainController)loader.getController();
            this.customerMainController.setupStage(this.stage, strings);
            this.screenResolution = this.activeConfig.getDisplayConfig().getResolution();
            Scene scene = new Scene(root, (double)this.screenResolution.getWidth(), (double)this.screenResolution.getHeight());
            if (this.cssFile != null) {
                scene.getStylesheets().add((Object)this.cssFile.toExternalForm());
            }
            this.stage.setScene(scene);
            this.stage.setResizable(false);
            this.stage.setTitle("Spagetka BranchClient v0.0.1");
            if (this.activeConfig.getDisplayConfig().isFullscreen()) {
                this.stage.setFullScreen(true);
                this.stage.setFullScreenExitKeyCombination(KeyCombination.NO_MATCH);
            }
            try {
                screenBounds = ((Screen)Screen.getScreens().get(this.activeConfig.getDisplayConfig().getScreenId())).getVisualBounds();
            }
            catch (Exception e) {
                screenBounds = ((Screen)Screen.getScreens().get(0)).getVisualBounds();
            }
            this.stage.setX(screenBounds.getMinX());
            this.stage.setY(screenBounds.getMinY());
            this.stage.show();
            if (this.activeConfig.isOpenScenicView()) {
                ScenicView.show((Scene)scene);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    @Autowired
    public void setInternetConnectivityService(InternetConnectivityService internetConnectivityService) {
        this.internetConnectivityService = internetConnectivityService;
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }
}

