/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.models.StockMovementLogItem;
import cz.polreich.spagetka.models.enums.STOCK_MOVEMENT_ACTION;
import java.time.LocalDate;

public class StockMovementLogItemDTO {
    String id;
    String stockItemId;
    String ingredientId;
    LocalDate expirationDate;
    STOCK_MOVEMENT_ACTION stockMovementAction;
    Double quantity;
    String timestamp;

    public StockMovementLogItemDTO(StockMovementLogItem item) {
        this.id = item.getId();
        String string = this.stockItemId = item.getStockItem() != null ? item.getStockItem().getId() : null;
        this.ingredientId = item.getStockItem() != null ? (item.getStockItem().getIngredient() != null ? item.getStockItem().getIngredient().getId() : null) : null;
        this.expirationDate = item.getStockItem() != null ? item.getStockItem().getExpirationDate() : null;
        this.stockMovementAction = item.getStockMovementAction();
        this.quantity = item.getQuantity();
        this.timestamp = item.getTimestamp().toString();
    }

    public StockMovementLogItemDTO() {
    }

    public StockMovementLogItemDTO(String id, String stockItemId, String ingredientId, LocalDate expirationDate, STOCK_MOVEMENT_ACTION stockMovementAction, Double quantity, String timestamp) {
        this.id = id;
        this.stockItemId = stockItemId;
        this.ingredientId = ingredientId;
        this.expirationDate = expirationDate;
        this.stockMovementAction = stockMovementAction;
        this.quantity = quantity;
        this.timestamp = timestamp;
    }

    public String getId() {
        return this.id;
    }

    public String getStockItemId() {
        return this.stockItemId;
    }

    public String getIngredientId() {
        return this.ingredientId;
    }

    public LocalDate getExpirationDate() {
        return this.expirationDate;
    }

    public STOCK_MOVEMENT_ACTION getStockMovementAction() {
        return this.stockMovementAction;
    }

    public Double getQuantity() {
        return this.quantity;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setStockItemId(String stockItemId) {
        this.stockItemId = stockItemId;
    }

    public void setIngredientId(String ingredientId) {
        this.ingredientId = ingredientId;
    }

    public void setExpirationDate(LocalDate expirationDate) {
        this.expirationDate = expirationDate;
    }

    public void setStockMovementAction(STOCK_MOVEMENT_ACTION stockMovementAction) {
        this.stockMovementAction = stockMovementAction;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }
}

