/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.utils.ExceptionHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.PixelReader;
import javafx.scene.image.WritableImage;
import javafx.scene.shape.Rectangle;

public class ImageUtils {
    public static Group round(ImageView imageView, double topLeft, double topRight, double bottomRight, double bottomLeft) {
        double width = imageView.getFitWidth();
        double height = imageView.getFitHeight();
        double topEdgeHalf = (width - (topLeft *= 2.0) - (topRight *= 2.0)) / 2.0;
        double rightEdgeHalf = (height - topRight - (bottomRight *= 2.0)) / 2.0;
        double bottomEdgeHalf = (width - (bottomLeft *= 2.0) - bottomRight) / 2.0;
        double leftEdgeHalf = (height - topLeft - bottomLeft) / 2.0;
        double topLeftWidth = topEdgeHalf + 2.0 * topLeft;
        double topLeftHeight = leftEdgeHalf + 2.0 * topLeft;
        double topLeftX = 0.0;
        double topLeftY = 0.0;
        double topRightWidth = topEdgeHalf + 2.0 * topRight;
        double topRightHeight = rightEdgeHalf + 2.0 * topRight;
        double topRightX = width - topRightWidth;
        double topRightY = 0.0;
        double bottomRightWidth = bottomEdgeHalf + 2.0 * bottomRight;
        double bottomRightHeight = rightEdgeHalf + 2.0 * bottomRight;
        double bottomRightX = width - bottomRightWidth;
        double bottomRightY = height - bottomRightHeight;
        double bottomLeftWidth = bottomEdgeHalf + 2.0 * bottomLeft;
        double bottomLeftHeight = leftEdgeHalf + 2.0 * bottomLeft;
        double bottomLeftX = 0.0;
        double bottomLeftY = height - bottomLeftHeight;
        Rectangle topLeftRect = new Rectangle(topLeftX, topLeftY, topLeftWidth, topLeftHeight);
        Rectangle topRightRect = new Rectangle(topRightX, topRightY, topRightWidth, topRightHeight);
        Rectangle bottomRightRect = new Rectangle(bottomRightX, bottomRightY, bottomRightWidth, bottomRightHeight);
        Rectangle bottomLeftRect = new Rectangle(bottomLeftX, bottomLeftY, bottomLeftWidth, bottomLeftHeight);
        topLeftRect.setArcWidth(topLeft);
        topLeftRect.setArcHeight(topLeft);
        topRightRect.setArcWidth(topRight);
        topRightRect.setArcHeight(topRight);
        bottomRightRect.setArcWidth(bottomRight);
        bottomRightRect.setArcHeight(bottomRight);
        bottomLeftRect.setArcWidth(bottomLeft);
        bottomLeftRect.setArcHeight(bottomLeft);
        Group clipGroup = new Group(new Node[]{topLeftRect, topRightRect, bottomRightRect, bottomLeftRect});
        return clipGroup;
    }

    public static ImageView getCroppedImageView(Image fullImage, double imageViewFitWidth, double imageViewFitHeight) {
        ImageView imageView;
        try {
            PixelReader reader = fullImage.getPixelReader();
            double scaleFactorDown = imageViewFitWidth / fullImage.getWidth();
            double scaleFactorUp = fullImage.getWidth() / imageViewFitWidth;
            double startYPos = (fullImage.getHeight() - imageViewFitHeight) / 2.0 * scaleFactorDown;
            double scaledHeight = imageViewFitHeight * scaleFactorUp;
            if (fullImage.getHeight() >= scaledHeight && startYPos >= 0.0) {
                WritableImage newImage = new WritableImage(reader, 0, (int)startYPos, (int)fullImage.getWidth(), (int)scaledHeight);
                imageView = new ImageView((Image)newImage);
            } else {
                imageView = new ImageView(fullImage);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            imageView = new ImageView(fullImage);
        }
        return imageView;
    }

    public static void centerImage(ImageView imageView) {
        Image img = imageView.getImage();
        if (img != null) {
            double w = 0.0;
            double h = 0.0;
            double ratioX = imageView.getFitWidth() / img.getWidth();
            double ratioY = imageView.getFitHeight() / img.getHeight();
            double reducCoeff = 0.0;
            reducCoeff = ratioX >= ratioY ? ratioY : ratioX;
            w = img.getWidth() * reducCoeff;
            h = img.getHeight() * reducCoeff;
            imageView.setX((imageView.getFitWidth() - w) / 2.0);
            imageView.setY((imageView.getFitHeight() - h) / 2.0);
        }
    }
}

