/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.cashier;

import cz.polreich.spagetka.service.cashier.CashierControllerService;
import cz.polreich.spagetka.service.cashier.scheduler.GiftVoucherSchedulerService;
import cz.polreich.spagetka.service.cashier.scheduler.MainOrderSchedulerService;

public class CashierTaskManager {
    private final CashierControllerService cashierControllerService;

    public CashierTaskManager(CashierControllerService cashierControllerService) {
        this.cashierControllerService = cashierControllerService;
    }

    public void startAll() {
        this.startMainMainScheduler();
        this.startGiftVoucherScheduler();
    }

    public void shutdownAll() {
        this.shutdownMainScheduler();
        this.shutdownGiftVoucherScheduler();
    }

    public void startMainMainScheduler() {
        MainOrderSchedulerService.getInstance().start(() -> ((CashierControllerService)this.cashierControllerService).processOrders());
    }

    public void shutdownMainScheduler() {
        MainOrderSchedulerService.getInstance().stop();
    }

    public void startGiftVoucherScheduler() {
        GiftVoucherSchedulerService.getInstance().start(() -> ((CashierControllerService)this.cashierControllerService).processGiftVouchers());
    }

    public void shutdownGiftVoucherScheduler() {
        GiftVoucherSchedulerService.getInstance().stop();
    }
}

