/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.cashier;

import cz.polreich.spagetka.DTO.CustomerDetailsDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.LabelPrinterConfig;
import cz.polreich.spagetka.models.config.PrinterConfig;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.enums.PAYMENT_METHOD;
import cz.polreich.spagetka.service.GiftVoucherService;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ReceiptService;
import cz.polreich.spagetka.service.cashier.grapchical.GraphicalSwitcherForMainThread;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LabelPrinter;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.util.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CashierControllerService {
    private static final Logger log = LoggerFactory.getLogger(CashierControllerService.class);
    private final CashierController cashierController;
    private final OrderService orderService;
    private final GiftVoucherService giftVoucherService;
    private final CashierConfig activeConfig;
    private final PartnerServerRestClient partnerServerRestClient;
    private final ReceiptService receiptService;
    private static final Media soundNewOrder = new Media(Objects.requireNonNull(CashierControllerService.class.getResource("/resources/sounds/level-up-191997.mp3")).toExternalForm());
    private static final MediaPlayer mediaPlayer = new MediaPlayer(soundNewOrder);

    public CashierControllerService(CashierController cashierController, OrderService orderService, GiftVoucherService giftVoucherService, CashierConfig activeConfig, PartnerServerRestClient partnerServerRestClient, ReceiptService receiptService) {
        this.cashierController = cashierController;
        this.orderService = orderService;
        this.giftVoucherService = giftVoucherService;
        this.activeConfig = activeConfig;
        this.partnerServerRestClient = partnerServerRestClient;
        this.receiptService = receiptService;
    }

    public void processOrders() {
        GraphicalSwitcherForMainThread.getInstance().renderOrderCashierSection();
        GraphicalSwitcherForMainThread.getInstance().renderOrdersInOrderManagement();
        List<ORDER_STATUS> neededStatuses = Arrays.asList(ORDER_STATUS.CONFIRMED, ORDER_STATUS.WAITING_FOR_PAYMENT, ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT, ORDER_STATUS.PREPARING, ORDER_STATUS.WAITING_FOR_PICKUP, ORDER_STATUS.WAITING_FOR_DELIVERY);
        List ordersRaw = this.orderService.getOrdersToBeFinishedFrom6AmToNextDay6AmWithTHESEOrderStatuses(neededStatuses);
        if (ordersRaw == null || ordersRaw.isEmpty()) {
            return;
        }
        List<Order> orders = ordersRaw.stream().filter(o -> !o.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_PAYMENT) || !o.getPaymentMethod().equals((Object)PAYMENT_METHOD.CARD)).toList();
        this.safe(() -> this.announceNewOrdersAndPrintOrderNotification(orders));
        this.safe(() -> this.printStickers_PREPARING(orders));
        this.safe(() -> this.verifyReceipts_PAYMENT_METHOD_ONLINE_OR_WOLT_ONLINE(orders));
        this.safe(() -> this.autoConfirmNewOrdersWithStatus_WAITING_FOR_CASHIER_APPROVEMENT(orders));
        this.safe(() -> this.evaluateCustomerStatus(orders));
    }

    public void processGiftVouchers() {
        List<ORDER_STATUS> ignoredStatuses = Arrays.asList(ORDER_STATUS.DONE, ORDER_STATUS.CANCELLED, ORDER_STATUS.WAITING_FOR_PAYMENT, ORDER_STATUS.REJECTED);
        List orders = this.orderService.getOrdersToBeFinishedFrom6AmToNextDay6AmWithoutTHISOrderStatuses(ignoredStatuses);
        if (orders != null && !orders.isEmpty()) {
            this.giftVoucherService.checkForGiftVouchers(orders);
        }
    }

    private void safe(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    private void announceNewOrdersAndPrintOrderNotification(List<Order> orders) {
        boolean shouldAnnounce = orders.stream().anyMatch(o -> !o.isAnnounced());
        if (shouldAnnounce) {
            this.playSoundForNewOrder();
        }
        PrinterConfig printerConfig = this.activeConfig.getPrinterConfig();
        for (Order order : orders) {
            boolean printed;
            if (order.isAnnounced() || !(printed = ReceiptPrinter.printNewOrderNotification((Order)order, (String)printerConfig.getPrinterName(), (int)printerConfig.getCharacters(), (String)printerConfig.getCodepage()))) continue;
            order.setAnnounced(Boolean.valueOf(true));
            this.orderService.setAnnounced(order);
        }
    }

    private void printStickers_PREPARING(List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return;
        }
        if (this.activeConfig.getLabelPrinterConfig() == null || !this.activeConfig.getLabelPrinterConfig().isEnabled()) {
            log.debug("[PRINTING STICKERS] - Label printer config is missing or disabled. Skipping sticker printing.");
            return;
        }
        List<Order> preparingOrders = orders.stream().filter(Objects::nonNull).filter(o -> o.getOrderStatus() == ORDER_STATUS.PREPARING).filter(o -> !Boolean.TRUE.equals(o.isStickersPrinted())).toList();
        if (preparingOrders.isEmpty()) {
            log.info("[PRINTING STICKERS] - No PREPARING orders require sticker printing.");
            return;
        }
        for (Order order : preparingOrders) {
            try {
                log.info("[PRINTING STICKERS] - Printing stickers for (order id): {}", (Object)order.getOrderNumber());
                order.setStickersPrinted(Boolean.valueOf(true));
                LabelPrinter.printLabelsForOrder((LabelPrinterConfig)this.activeConfig.getLabelPrinterConfig(), (Order)order);
                this.orderService.update(order);
            }
            catch (Exception e) {
                log.error("[PRINTING STICKERS ERROR] - Failed to print stickers for orderId - {}", (Object)order.getId());
                ExceptionHandler.logException((Exception)e);
            }
        }
    }

    private void playSoundForNewOrder() {
        try {
            mediaPlayer.stop();
            mediaPlayer.seek(Duration.ZERO);
            mediaPlayer.play();
        }
        catch (Exception e) {
            log.error("[PLAYING SOUND FOR NEW ORDER ERROR] - Failed to play sound");
            ExceptionHandler.logException((Exception)e);
        }
    }

    private void verifyReceipts_PAYMENT_METHOD_ONLINE_OR_WOLT_ONLINE(List<Order> orders) {
        for (Order order : orders) {
            boolean receiptExists;
            boolean isOnlinePayment = PAYMENT_METHOD.ONLINE.equals((Object)order.getPaymentMethod()) || PAYMENT_METHOD.WOLT_ONLINE.equals((Object)order.getPaymentMethod());
            if (!isOnlinePayment || !order.isTaxRelevant() || (receiptExists = this.receiptService.existsByOrderId(order.getId()))) continue;
            this.cashierController.createReceipt(true, order);
        }
    }

    private void evaluateCustomerStatus(List<Order> orders) {
        if (orders == null || orders.isEmpty()) {
            return;
        }
        for (Order order : orders) {
            if (order == null) continue;
            String phone = order.getCustomerPhoneNumber();
            Boolean evaluated = order.isCustomerEvaluated();
            if (phone == null || phone.trim().isEmpty() || Boolean.TRUE.equals(evaluated)) continue;
            CustomerDetailsDTO customerDetails = this.partnerServerRestClient.getCustomerDetails(phone);
            if (customerDetails != null && customerDetails.isExists()) {
                order.setCustomerRegistered(Boolean.valueOf(customerDetails.isRegistered()));
                Integer orderCount = customerDetails.getNumberOfOrders();
                order.setCustomerFirstOrder(Boolean.valueOf(orderCount != null && orderCount == 0));
            }
            order.setCustomerEvaluated(Boolean.valueOf(true));
            this.orderService.update(order);
        }
    }

    private void autoConfirmNewOrdersWithStatus_WAITING_FOR_CASHIER_APPROVEMENT(List<Order> orders) {
        List<Order> deliveryOrders = orders.stream().filter(order -> order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)).toList();
        if (!deliveryOrders.isEmpty()) {
            for (Order woltOrder : deliveryOrders) {
                woltOrder.setOrderStatus(ORDER_STATUS.CONFIRMED);
                this.orderService.update(woltOrder);
            }
        }
    }
}

