/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.CashManipulationItemDTO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.time.LocalDateTime;

@Entity
@Table(name="CashManipulations")
public class CashManipulationItem {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @Column
    private LocalDateTime timestamp;
    @Column
    private Double amount;
    @Column
    private String employeeName;

    public CashManipulationItem(CashManipulationItemDTO dto) {
        this.id = dto.getId();
        this.timestamp = LocalDateTime.parse(dto.getTimestamp());
        this.amount = dto.getAmount();
        this.employeeName = dto.getEmployeeName();
    }

    public String getId() {
        return this.id;
    }

    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    public Double getAmount() {
        return this.amount;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public CashManipulationItem() {
    }

    public CashManipulationItem(String id, LocalDateTime timestamp, Double amount, String employeeName) {
        this.id = id;
        this.timestamp = timestamp;
        this.amount = amount;
        this.employeeName = employeeName;
    }
}

