/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.customerMainController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerMainController;
import cz.polreich.spagetka.controllers.popup.customerMainController.MenuOptionPopup;
import cz.polreich.spagetka.controllers.popup.customerMainController.ProductDetailPopup;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductGroupsPrice;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.panes.TouchScrollPane;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.ImageUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.TextAlignment;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.beans.factory.annotation.Autowired;

public class MenuOptionPopup
extends Popup {
    private CustomerMainController customerMainController;
    private FlowPane menuOptionMainFlowPane = new FlowPane();
    private AnchorPane productSelectionMainAnchorPane = new AnchorPane();
    private FlowPane bottomFlowPane = new FlowPane();
    private Label popupTitle = new Label();
    private TilePane topTilePane = new TilePane();
    private CancelButton backButton = new CancelButton();
    private double tileMinWidth;
    private double tileMinHeight;
    private double popupMinWidth;
    private double popupMinHeight;
    private double popupMaxWidth;
    private double popupMaxHeight;
    private List<MenuOption> menuOptions;
    private TilePane lastStepInnerTilePane;
    private TouchScrollPane lastStepInnerScrollPane;
    private ObservableMap<String, String> selectedAddProducts;
    private ConfirmButton lastStepConfirmButton;
    private ImageView greenTickImageView;
    private ImageView emptyImageView;
    private List<Product> allProducts;
    private ImageFactory imageFactory = new ImageFactory(new ResourceHelper());

    public MenuOptionPopup(CustomerMainController customerMainController) {
        this.customerMainController = customerMainController;
        this.allProducts = customerMainController.productService.findAll();
        customerMainController.bindStringToLocale((Button)this.backButton, "menuOptions.button.back", customerMainController.titleFont);
        this.backButton.setPrefWidth(296.0);
        this.backButton.setPrefHeight(100.0);
        FontUtils.setIdealFont((Button)this.backButton, (Font)customerMainController.titleFont);
        int tileColumns = 2;
        this.popupMinWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.89;
        this.popupMinHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.89;
        this.popupMaxWidth = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getWidth() * 0.89;
        this.popupMaxHeight = (double)customerMainController.activeConfig.getDisplayConfig().getResolution().getHeight() * 0.89;
        double topTileMinHeight = this.popupMinHeight * 0.7;
        this.tileMinHeight = this.tileMinWidth = this.popupMinWidth * 0.85 / (double)tileColumns;
        Insets popupPadding = new Insets(this.popupMinWidth * 0.1);
        this.menuOptionMainFlowPane.getStyleClass().add((Object)"popup-main-pane");
        this.menuOptionMainFlowPane.setStyle("-fx-background-color: " + customerMainController.popupBackgroundColor + ";");
        this.menuOptionMainFlowPane.setMinWidth(this.popupMinWidth);
        this.menuOptionMainFlowPane.setMinHeight(this.popupMinHeight);
        this.menuOptionMainFlowPane.setMaxWidth(this.popupMaxWidth);
        this.menuOptionMainFlowPane.setMaxHeight(this.popupMaxHeight);
        this.menuOptionMainFlowPane.setPadding(popupPadding);
        this.topTilePane.setMinWidth(this.popupMinWidth);
        this.topTilePane.setMinHeight(topTileMinHeight);
        this.topTilePane.setOrientation(Orientation.HORIZONTAL);
        this.topTilePane.setPrefColumns(tileColumns);
        this.topTilePane.setAlignment(Pos.CENTER);
        this.topTilePane.setHgap(50.0);
        this.topTilePane.setVgap(50.0);
        this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(1));
        this.backButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(1));
        this.bottomFlowPane.setOrientation(Orientation.HORIZONTAL);
        this.bottomFlowPane.setHgap(50.0);
        this.bottomFlowPane.setAlignment(Pos.CENTER);
        this.bottomFlowPane.getChildren().removeAll((Collection)this.bottomFlowPane.getChildren());
        this.bottomFlowPane.getChildren().add((Object)this.backButton);
        this.bottomFlowPane.setMinWidth(this.popupMinWidth);
        this.topTilePane.getChildren().removeAll((Collection)this.topTilePane.getChildren());
        this.popupTitle.setText(customerMainController.strings.getString("menuOptions.label.title1"));
        this.popupTitle.getStyleClass().add((Object)"popup-title");
        this.popupTitle.setFont(customerMainController.popupTitleFont);
        this.menuOptionMainFlowPane.setAlignment(Pos.TOP_CENTER);
        this.menuOptionMainFlowPane.setVgap(20.0);
        this.menuOptionMainFlowPane.getChildren().add(0, (Object)this.popupTitle);
        this.menuOptionMainFlowPane.getChildren().add(1, (Object)this.topTilePane);
        this.menuOptionMainFlowPane.getChildren().add(2, (Object)this.bottomFlowPane);
        this.getContent().add((Object)this.menuOptionMainFlowPane);
        this.setAutoHide(false);
    }

    public void loadPopup(List<MenuOption> menuOptions) {
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
            CustomerBaseController.lastPressTime = System.currentTimeMillis();
        });
        this.customerMainController.activeConfig.getOpenedPopups().add(this);
        this.menuOptions = menuOptions.stream().sorted(Comparator.comparing(MenuOption::getName).reversed()).toList();
        this.loadFirstMenu();
        this.show((Window)this.customerMainController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void loadFirstMenu() {
        this.topTilePane.getChildren().removeAll((Collection)this.topTilePane.getChildren());
        Product product = ((MenuOption)this.menuOptions.get(0)).getMainProduct();
        VBox menuButtonVBox = this.createFirstLevelTile(TOP_LEVEL_TYPE.MENU, this.tileMinWidth, this.tileMinHeight, product);
        VBox individualButtonVBox = this.createFirstLevelTile(TOP_LEVEL_TYPE.INDIVIDUAL, this.tileMinWidth, this.tileMinHeight, product);
        this.topTilePane.getChildren().addAll((Object[])new Node[]{menuButtonVBox, individualButtonVBox});
    }

    private void loadMenus() {
        this.topTilePane.getChildren().removeAll((Collection)this.topTilePane.getChildren());
        for (MenuOption menuOption : this.menuOptions) {
            this.topTilePane.getChildren().add((Object)this.createMenuOptionTile(menuOption, this.tileMinWidth, this.tileMinHeight));
        }
        this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(2));
        this.backButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(2));
    }

    private void handlePopupBackButtonClick(int mode) {
        switch (mode) {
            case 1: {
                this.hide();
                break;
            }
            case 2: {
                this.popupTitle.setText(this.customerMainController.strings.getString("menuOptions.label.title1"));
                this.loadFirstMenu();
                this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(1));
                this.backButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(1));
                break;
            }
            case 3: {
                this.getContent().remove((Object)this.productSelectionMainAnchorPane);
                this.getContent().add((Object)this.menuOptionMainFlowPane);
                this.bottomFlowPane.getChildren().removeAll((Collection)this.bottomFlowPane.getChildren());
                this.bottomFlowPane.getChildren().add((Object)this.backButton);
                this.menuOptionMainFlowPane.getChildren().add(2, (Object)this.bottomFlowPane);
                this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(2));
                this.backButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(2));
            }
        }
    }

    private VBox createFirstLevelTile(TOP_LEVEL_TYPE type, double tileMinWidth, double tileMinHeight, Product product) {
        double tileWidth = tileMinWidth;
        double tileHeight = tileMinHeight;
        int tileCornerRadius = 50;
        int borderWidth = 1;
        double internalTileWidth = tileWidth - (double)(2 * borderWidth);
        double internalTileHeight = tileHeight - (double)(2 * borderWidth);
        double imageHeight = internalTileHeight * 0.6;
        double imageWidth = internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageHeight + 5.0;
        double buttonWidth = tileWidth / 3.0;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize(tileWidth, tileHeight);
        vBox.setMaxSize(tileWidth, tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-color: white;\n  -fx-background-radius: " + tileCornerRadius + "px;\n  -fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize(internalTileWidth, internalTileHeight);
        anchorPane.setMinSize(internalTileWidth, internalTileHeight);
        String filePath = "";
        if (type == TOP_LEVEL_TYPE.MENU) {
            filePath = product.getCategory() == 7 ? "/resources/images/iceCreamExtra.png" : "/resources/images/menu_generic.jpg";
        } else if (type == TOP_LEVEL_TYPE.INDIVIDUAL) {
            filePath = product.getImageFilePath();
        }
        Image fullImage = (Image)this.imageFactory.create(filePath).get();
        ImageView imageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageWidth, (double)imageHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageWidth);
        imageView.setFitHeight(imageHeight);
        imageView.setClip((Node)ImageUtils.round((ImageView)imageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)imageView);
        String labelText = "";
        if (product.getCategory() == 7) {
            if (type == TOP_LEVEL_TYPE.MENU) {
                labelText = this.customerMainController.strings.getString("iceCream.label.iceCreamExtra");
            } else if (type == TOP_LEVEL_TYPE.INDIVIDUAL) {
                labelText = this.customerMainController.strings.getString("iceCream.label.iceCreamOnly");
            }
        } else if (type == TOP_LEVEL_TYPE.MENU) {
            labelText = this.customerMainController.strings.getString("menuOptions.label.mealDeal");
        } else if (type == TOP_LEVEL_TYPE.INDIVIDUAL) {
            labelText = this.customerMainController.strings.getString("menuOptions.label.separateProduct");
        }
        Label nameLabel = new Label(labelText);
        nameLabel.setFont(this.customerMainController.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        if (type == TOP_LEVEL_TYPE.MENU) {
            vBox.setOnMouseClicked(mouseEvent -> this.loadMenus());
            vBox.setOnTouchPressed(touchEvent -> this.loadMenus());
        } else if (type == TOP_LEVEL_TYPE.INDIVIDUAL) {
            vBox.setOnMouseClicked(mouseEvent -> {
                this.hide();
                this.customerMainController.addProductToOrder(product);
            });
        }
        this.backButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(1));
        return vBox;
    }

    private VBox createMenuOptionTile(MenuOption menuOption, double tileMinWidth, double tileMinHeight) {
        double tileWidth = tileMinWidth;
        double tileHeight = tileMinHeight;
        int tileCornerRadius = 50;
        int borderWidth = 1;
        double internalTileWidth = tileWidth - (double)(2 * borderWidth);
        double internalTileHeight = tileHeight - (double)(2 * borderWidth);
        double imageHeight = internalTileHeight * 0.6;
        double imageWidth = internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageHeight + 5.0;
        double buttonWidth = tileWidth / 3.0;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize(tileWidth, tileHeight);
        vBox.setMaxSize(tileWidth, tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-color: white;\n  -fx-background-radius: " + tileCornerRadius + "px;\n  -fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize(internalTileWidth, internalTileHeight);
        anchorPane.setMinSize(internalTileWidth, internalTileHeight);
        Image fullImage = (Image)this.imageFactory.create(menuOption.getImageFilePath()).get();
        ImageView imageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageWidth, (double)imageHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageWidth);
        imageView.setFitHeight(imageHeight);
        imageView.setClip((Node)ImageUtils.round((ImageView)imageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)imageView);
        Label nameLabel = new Label(menuOption.getName());
        nameLabel.setFont(this.customerMainController.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)39.0);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        Label priceLabel = new Label();
        priceLabel.setText(FormatUtils.formatCurrency((double)menuOption.getPrice(), (String)this.customerMainController.activeConfig.getKioskInfo().getCurrency().getSymbol(this.customerMainController.activeConfig.getSelectedLocale())));
        priceLabel.setFont(this.customerMainController.priceLabelFont);
        priceLabel.setAlignment(Pos.CENTER_RIGHT);
        AnchorPane.setBottomAnchor((Node)priceLabel, (Double)10.0);
        AnchorPane.setRightAnchor((Node)priceLabel, (Double)20.0);
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel, priceLabel});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        vBox.setOnMouseClicked(mouseEvent -> this.handleMenuOptionSelection(menuOption));
        vBox.setOnTouchPressed(touchEvent -> this.handleMenuOptionSelection(menuOption));
        return vBox;
    }

    private void handleMenuOptionSelection(MenuOption menuOption) {
        if (!menuOption.getAdditionalProductsGroups().isEmpty()) {
            SimpleStringProperty selectedTab = new SimpleStringProperty(((ProductsGroup)menuOption.getAdditionalProductsGroups().get(0)).getTitle());
            double leftPaneWidth = 200.0;
            Label newTitle = new Label();
            newTitle.setText(this.customerMainController.strings.getString("menuOptions.label.title2"));
            newTitle.getStyleClass().add((Object)"popup-title");
            newTitle.setFont(this.customerMainController.popupTitleFont);
            newTitle.setMinWidth(this.popupMaxWidth);
            newTitle.setAlignment(Pos.CENTER);
            AnchorPane.setTopAnchor((Node)newTitle, (Double)50.0);
            AnchorPane.setLeftAnchor((Node)newTitle, (Double)0.0);
            AnchorPane.setRightAnchor((Node)newTitle, (Double)0.0);
            OrderItem orderItem = new OrderItem(menuOption);
            this.selectedAddProducts = FXCollections.observableHashMap();
            this.lastStepConfirmButton = new ConfirmButton();
            this.customerMainController.bindStringToLocale((Button)this.lastStepConfirmButton, "menuOptions.button.confirm", this.customerMainController.titleFont);
            this.lastStepConfirmButton.setPrefWidth(296.0);
            this.lastStepConfirmButton.setPrefHeight(100.0);
            FontUtils.setIdealFont((Button)this.lastStepConfirmButton, (Font)this.customerMainController.titleFont);
            this.lastStepConfirmButton.setDisable(true);
            this.lastStepConfirmButton.setOnMouseClicked(mouseEvent -> {
                double remainingPrice = menuOption.getPrice() - menuOption.getAdditionalProductsPrices().stream().mapToDouble(ProductGroupsPrice::getPrice).sum();
                ProductGroupsPrice tempPriceGroup = new ProductGroupsPrice();
                tempPriceGroup.setPrice(Double.valueOf(remainingPrice));
                Optional<Product> mainProductSubItem = this.allProducts.stream().filter(p -> p.getId().equals(menuOption.getMainProduct().getId())).findFirst();
                if (mainProductSubItem.isPresent()) {
                    orderItem.addSubItem(new OrderItem(mainProductSubItem.get(), tempPriceGroup));
                    for (String groupId : this.selectedAddProducts.keySet()) {
                        if (Objects.equals(groupId, "-1")) continue;
                        String productId = (String)this.selectedAddProducts.get((Object)groupId);
                        Optional<Product> subItemProduct = this.allProducts.stream().filter(p -> p.getId().equals(productId)).findFirst();
                        subItemProduct.ifPresent(product -> orderItem.addSubItem(new OrderItem(product, menuOption.getAdditionalProductsPrices().stream().filter(g -> g.getProductsGroup().getId().equals(groupId)).findFirst().get())));
                    }
                }
                this.hide();
                this.customerMainController.addOrderItemToOrder(orderItem);
            });
            CancelButton secondBackButton = new CancelButton();
            this.customerMainController.bindStringToLocale((Button)secondBackButton, "menuOptions.button.back", this.customerMainController.titleFont);
            secondBackButton.setPrefWidth(296.0);
            secondBackButton.setPrefHeight(100.0);
            FontUtils.setIdealFont((Button)secondBackButton, (Font)this.customerMainController.titleFont);
            secondBackButton.setOnMouseClicked(mouseEvent -> this.handlePopupBackButtonClick(3));
            secondBackButton.setOnTouchPressed(touchEvent -> this.handlePopupBackButtonClick(3));
            this.bottomFlowPane.getChildren().removeAll((Collection)this.bottomFlowPane.getChildren());
            this.bottomFlowPane.getChildren().addAll((Object[])new Node[]{secondBackButton, this.lastStepConfirmButton});
            AnchorPane.setLeftAnchor((Node)this.bottomFlowPane, (Double)0.0);
            AnchorPane.setRightAnchor((Node)this.bottomFlowPane, (Double)0.0);
            AnchorPane.setBottomAnchor((Node)this.bottomFlowPane, (Double)50.0);
            this.productSelectionMainAnchorPane = new AnchorPane();
            this.productSelectionMainAnchorPane.getStyleClass().add((Object)"popup-main-pane");
            this.productSelectionMainAnchorPane.setStyle("-fx-background-color: " + this.customerMainController.popupBackgroundColor + ";");
            this.productSelectionMainAnchorPane.setMinWidth(this.popupMinWidth);
            this.productSelectionMainAnchorPane.setMinHeight(this.popupMaxHeight);
            this.productSelectionMainAnchorPane.setMaxWidth(this.popupMaxWidth);
            this.productSelectionMainAnchorPane.setMaxHeight(this.popupMaxHeight);
            this.lastStepInnerTilePane = new TilePane();
            this.lastStepInnerTilePane.setPadding(LayoutUtils.getInsets((double)10.0, (double)5.0, (double)10.0, (double)20.0));
            this.lastStepInnerTilePane.setStyle("-fx-background-color: " + this.customerMainController.popupBackgroundColor + ";");
            this.lastStepInnerTilePane.setPrefColumns(2);
            this.lastStepInnerTilePane.setHgap(20.0);
            this.lastStepInnerTilePane.setVgap(20.0);
            this.lastStepInnerScrollPane = new TouchScrollPane();
            this.lastStepInnerScrollPane.getStyleClass().add((Object)"edge-to-edge");
            this.lastStepInnerScrollPane.setStyle("    -fx-background-color: " + this.customerMainController.popupBackgroundColor + ";\n-fx-background-radius: 10 10 10 10;\n-fx-border-radius: 10 10 10 10;");
            this.lastStepInnerScrollPane.setContent((Node)this.lastStepInnerTilePane);
            AnchorPane.setTopAnchor((Node)this.lastStepInnerScrollPane, (Double)230.0);
            AnchorPane.setBottomAnchor((Node)this.lastStepInnerScrollPane, (Double)230.0);
            AnchorPane.setLeftAnchor((Node)this.lastStepInnerScrollPane, (Double)(leftPaneWidth + 20.0));
            AnchorPane.setRightAnchor((Node)this.lastStepInnerScrollPane, (Double)10.0);
            FlowPane leftFlowPane = new FlowPane();
            leftFlowPane.setMinWidth(leftPaneWidth);
            leftFlowPane.setMaxWidth(leftPaneWidth);
            leftFlowPane.setOrientation(Orientation.VERTICAL);
            leftFlowPane.setAlignment(Pos.TOP_CENTER);
            leftFlowPane.setVgap(30.0);
            if (menuOption.getAdditionalProductsGroups().size() >= 5) {
                leftFlowPane.setVgap(20.0);
            }
            leftFlowPane.setStyle("    -fx-background-color: " + this.customerMainController.popupBackgroundColor + ";\n-fx-background-radius: 30 30 30 30;\n-fx-border-radius: 30 30 30 30;\n");
            AnchorPane.setTopAnchor((Node)leftFlowPane, (Double)230.0);
            AnchorPane.setBottomAnchor((Node)leftFlowPane, (Double)100.0);
            AnchorPane.setLeftAnchor((Node)leftFlowPane, (Double)10.0);
            String buttonStyle = "    -fx-background-color: " + this.customerMainController.activeConfig.getColors().getPrimary() + ";\n-fx-background-radius: 30 30 30 30;\n-fx-border-radius: 30 30 30 30;\n-fx-font-size: 40px;\n-fx-font-family: \"lobster\";\n";
            String buttonStyleUnselected = buttonStyle + "\n-fx-effect: dropshadow( gaussian , rgba(0,0,0,0.75) , 4,0,0,2 );";
            String buttonStyleSelected = buttonStyle + "\n-fx-effect: innershadow( gaussian , gray , 4,0,0,2 );";
            ArrayList<ProductsGroup> invalidGroups = new ArrayList<ProductsGroup>();
            ProductsGroup mainProductGroup = new ProductsGroup();
            mainProductGroup.setId("-1");
            mainProductGroup.setTitle("Hlavn\u00ed produkt");
            mainProductGroup.getProducts().add(orderItem.getMainProduct());
            ArrayList<ProductsGroup> newProductGroups = new ArrayList<ProductsGroup>(menuOption.getAdditionalProductsGroups());
            newProductGroups.add(mainProductGroup);
            newProductGroups.sort(Comparator.comparing(ProductsGroup::getId));
            this.selectedAddProducts.put((Object)mainProductGroup.getId(), (Object)orderItem.getMainProduct().getId());
            for (ProductsGroup productGroup : newProductGroups) {
                if (productGroup != null && productGroup.getProducts().stream().anyMatch(Product::isEnabled)) {
                    Button button = this.createSelectTabButton(productGroup.getTitle());
                    button.setOnMouseClicked(arg_0 -> MenuOptionPopup.lambda$handleMenuOptionSelection$23((StringProperty)selectedTab, productGroup, arg_0));
                    button.setOnTouchPressed(arg_0 -> MenuOptionPopup.lambda$handleMenuOptionSelection$24((StringProperty)selectedTab, productGroup, arg_0));
                    button.styleProperty().bind((ObservableValue)Bindings.createStringBinding(() -> MenuOptionPopup.lambda$handleMenuOptionSelection$25((StringProperty)selectedTab, productGroup, buttonStyleSelected, buttonStyleUnselected), (Observable[])new Observable[]{selectedTab}));
                    BooleanBinding containsKeyBinding = Bindings.createBooleanBinding(() -> this.selectedAddProducts.containsKey((Object)productGroup.getId()), (Observable[])new Observable[]{this.selectedAddProducts});
                    button.graphicProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)containsKeyBinding).then((Object)this.greenTickImageView).otherwise((Object)this.emptyImageView));
                    leftFlowPane.getChildren().add((Object)button);
                    continue;
                }
                invalidGroups.add(productGroup);
            }
            newProductGroups.removeAll(invalidGroups);
            selectedTab.addListener((obs, oldValue, newValue) -> {
                this.lastStepInnerTilePane.getChildren().clear();
                ProductsGroup productGroup = newProductGroups.stream().filter(g -> g.getTitle().equals(newValue)).findFirst().orElse(null);
                this.selectTab(productGroup, menuOption);
            });
            ProductsGroup productGroup = (ProductsGroup)newProductGroups.get(0);
            selectedTab.set((Object)productGroup.getTitle());
            this.productSelectionMainAnchorPane.getChildren().addAll((Object[])new Node[]{leftFlowPane, newTitle, this.lastStepInnerScrollPane, this.bottomFlowPane});
            this.getContent().remove((Object)this.menuOptionMainFlowPane);
            this.getContent().add((Object)this.productSelectionMainAnchorPane);
        } else {
            OrderItem orderItem = new OrderItem(menuOption, false);
            this.hide();
            this.customerMainController.addOrderItemToOrder(orderItem);
        }
    }

    private Button createSelectTabButton(String title) {
        Image greenTickImage = (Image)this.imageFactory.create("/resources/images/green_tick_64.png").get();
        this.greenTickImageView = new ImageView();
        this.greenTickImageView.setImage(greenTickImage);
        this.greenTickImageView.setPreserveRatio(true);
        this.greenTickImageView.setFitWidth(60.0);
        this.greenTickImageView.setFitHeight(60.0);
        this.emptyImageView = new ImageView();
        this.emptyImageView.setFitWidth(60.0);
        this.emptyImageView.setFitHeight(60.0);
        Button button = new Button(title);
        button.setFocusTraversable(false);
        button.setMinWidth(200.0);
        button.setMaxWidth(200.0);
        button.setMinHeight(200.0);
        button.setMaxHeight(200.0);
        button.setGraphicTextGap(10.0);
        button.setContentDisplay(ContentDisplay.BOTTOM);
        button.setWrapText(true);
        button.setAlignment(Pos.TOP_CENTER);
        button.setTextAlignment(TextAlignment.CENTER);
        button.setPadding(new Insets(5.0, 2.0, 5.0, 2.0));
        return button;
    }

    private void selectTab(ProductsGroup productGroup, MenuOption menuOption) {
        if (productGroup != null && productGroup.getProducts().stream().anyMatch(Product::isEnabled)) {
            for (Product product : productGroup.getProducts()) {
                String selectedProductId;
                if (!product.isEnabled()) continue;
                VBox tile = this.createProductTile(product);
                if (this.selectedAddProducts.get((Object)productGroup.getId()) != null && (selectedProductId = (String)this.selectedAddProducts.get((Object)productGroup.getId())).equals(product.getId())) {
                    tile.getStyleClass().add((Object)"selected");
                }
                tile.setOnMouseClicked(mouseEvent -> {
                    this.lastStepInnerTilePane.getChildren().forEach(ch -> ch.getStyleClass().remove((Object)"selected"));
                    this.selectedAddProducts.put((Object)productGroup.getId(), (Object)product.getId());
                    tile.getStyleClass().add((Object)"selected");
                    this.lastStepConfirmButton.setDisable(this.selectedAddProducts.size() != menuOption.getAdditionalProductsGroups().size() + 1);
                });
                tile.setOnTouchPressed(touchEvent -> {
                    this.lastStepInnerTilePane.getChildren().forEach(ch -> ch.getStyleClass().remove((Object)"selected"));
                    this.selectedAddProducts.put((Object)productGroup.getId(), (Object)product.getId());
                    tile.getStyleClass().add((Object)"selected");
                    this.lastStepConfirmButton.setDisable(this.selectedAddProducts.size() != menuOption.getAdditionalProductsGroups().size() + 1);
                });
                this.lastStepInnerTilePane.getChildren().add((Object)tile);
            }
        }
    }

    public VBox createProductTile(Product product) {
        int tileWidth = 325;
        int tileHeight = 325;
        int tileCornerRadius = 50;
        int borderWidth = 0;
        int nameLabelHeight = 30;
        int buttonHeight = 30;
        int internalTileWidth = tileWidth - 2 * borderWidth;
        int internalTileHeight = tileHeight - 2 * borderWidth;
        double imageViewFitHeight = (double)internalTileHeight * 0.6;
        double imageViewFitWidth = (double)internalTileWidth * 1.0;
        double nameLabelTopAnchor = imageViewFitHeight + 5.0;
        double imageBottomAnchor = (double)internalTileHeight - imageViewFitHeight;
        int buttonWidth = tileWidth / 3;
        VBox vBox = new VBox(5.0);
        vBox.setMinSize((double)tileWidth, (double)tileHeight);
        vBox.setMaxSize((double)tileWidth, (double)tileHeight);
        vBox.setStyle("-fx-border-color:  lightgray;\n  -fx-border-width: " + borderWidth + "px;\n  -fx-border-style: solid;\n  -fx-border-radius: " + tileCornerRadius + "px;\n  -fx-background-radius: " + tileCornerRadius + "px;");
        vBox.getStyleClass().add((Object)"product-vbox");
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setMaxSize((double)internalTileWidth, (double)internalTileHeight);
        anchorPane.setMinSize((double)internalTileWidth, (double)internalTileHeight);
        Image fullImage = (Image)this.imageFactory.create(product.getImageFilePath()).get();
        ImageView imageView = ImageUtils.getCroppedImageView((Image)fullImage, (double)imageViewFitWidth, (double)imageViewFitHeight);
        imageView.setPreserveRatio(true);
        imageView.setFitWidth(imageViewFitWidth);
        imageView.setFitHeight(imageViewFitHeight);
        imageView.setClip((Node)ImageUtils.round((ImageView)imageView, (double)tileCornerRadius, (double)tileCornerRadius, (double)0.0, (double)0.0));
        StackPane stackPane = new StackPane();
        stackPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)stackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)stackPane, (Double)0.0);
        stackPane.getChildren().add((Object)imageView);
        Label nameLabel = new Label(product.getName());
        nameLabel.setFont(this.customerMainController.productTitleFont);
        nameLabel.setWrapText(true);
        nameLabel.setAlignment(Pos.CENTER);
        nameLabel.setTextAlignment(TextAlignment.CENTER);
        AnchorPane.setTopAnchor((Node)nameLabel, (Double)nameLabelTopAnchor);
        AnchorPane.setLeftAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setRightAnchor((Node)nameLabel, (Double)2.0);
        AnchorPane.setBottomAnchor((Node)nameLabel, (Double)39.0);
        Image tickImage = (Image)this.imageFactory.create("/resources/images/green_tick_64.png").get();
        ImageView tickImageView = new ImageView();
        tickImageView.setImage(tickImage);
        tickImageView.setPreserveRatio(true);
        tickImageView.setFitWidth(60.0);
        tickImageView.setFitHeight(60.0);
        AnchorPane.setBottomAnchor((Node)tickImageView, (Double)10.0);
        AnchorPane.setRightAnchor((Node)tickImageView, (Double)20.0);
        tickImageView.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> vBox.getStyleClass().contains((Object)"selected"), (Observable[])new Observable[]{vBox.getStyleClass()}));
        Button infoButton = LayoutUtils.createCircleButton((double)20.0, (String)"/resources/images/info_32.png");
        infoButton.setAlignment(Pos.CENTER);
        infoButton.setOnMouseClicked(mouseEvent -> {
            ProductDetailPopup detailPopup = new ProductDetailPopup(this.customerMainController);
            detailPopup.loadPopup(product);
            mouseEvent.consume();
        });
        infoButton.setOnTouchPressed(touchEvent -> {
            ProductDetailPopup detailPopup = new ProductDetailPopup(this.customerMainController);
            detailPopup.loadPopup(product);
            touchEvent.consume();
        });
        AnchorPane.setBottomAnchor((Node)infoButton, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)infoButton, (Double)20.0);
        anchorPane.getChildren().addAll((Object[])new Node[]{stackPane, nameLabel, infoButton, tickImageView});
        vBox.getChildren().add((Object)anchorPane);
        vBox.setAlignment(Pos.CENTER);
        vBox.setOnMouseClicked(mouseEvent -> this.handleProductSelection(product));
        vBox.setOnTouchPressed(touchEvent -> this.handleProductSelection(product));
        return vBox;
    }

    private void handleProductSelection(Product product) {
    }

    public void hide() {
        this.customerMainController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
        this.customerMainController.refreshMenuOptionsPopup();
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }

    private static /* synthetic */ String lambda$handleMenuOptionSelection$25(StringProperty selectedTab, ProductsGroup productGroup, String buttonStyleSelected, String buttonStyleUnselected) throws Exception {
        return ((String)selectedTab.get()).equals(productGroup.getTitle()) ? buttonStyleSelected : buttonStyleUnselected;
    }

    private static /* synthetic */ void lambda$handleMenuOptionSelection$24(StringProperty selectedTab, ProductsGroup productGroup, TouchEvent touchEvent) {
        selectedTab.set((Object)productGroup.getTitle());
    }

    private static /* synthetic */ void lambda$handleMenuOptionSelection$23(StringProperty selectedTab, ProductsGroup productGroup, MouseEvent mouseEvent) {
        selectedTab.set((Object)productGroup.getTitle());
    }
}

