/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.layout.cashierController.OrderCashierSection;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.Receipt;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ReceiptService;
import cz.polreich.spagetka.service.StockItemService;
import cz.polreich.spagetka.service.cashier.grapchical.GraphicalSwitcherForMainThread;
import cz.polreich.spagetka.utils.ExceptionHandler;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderCashierSectionService {
    private static final Logger log = LoggerFactory.getLogger(OrderCashierSectionService.class);
    @Autowired
    private OrderService orderService;
    @Autowired
    private PartnerServerRestClient partnerServerRestClient;
    private ImageFactory imageFactory;
    private CashierController cashierController;
    private CashierConfig activeConfig;
    private StockItemService stockItemService;
    private ReceiptService receiptService;
    private List<Order> orders = new ArrayList();
    private final List<ORDER_STATUS> neededStatus = Arrays.asList(ORDER_STATUS.CONFIRMED, ORDER_STATUS.PREPARING, ORDER_STATUS.WAITING_FOR_PICKUP, ORDER_STATUS.WAITING_FOR_DELIVERY);
    private Image imageEatIn;
    private Image imageTakeAway;
    private Image imageDelivery;
    private Image imagePickup;
    private Image imageOnline;
    private Image imageUnknown;
    private Image imageCustomerNote;
    private Image imageFirstOrder;
    private Image imageNotRegistered;
    private Image imageNoPhone;
    private OrderCashierSection orderCashierSection;

    public OrderCashierSectionService(CashierController cashierController, OrderService orderService, PartnerServerRestClient partnerServerRestClient, ImageFactory imageFactory, CashierConfig activeConfig, StockItemService stockItemService, ReceiptService receiptService) {
        try {
            this.cashierController = cashierController;
            this.orderService = orderService;
            this.partnerServerRestClient = partnerServerRestClient;
            this.imageFactory = imageFactory;
            this.activeConfig = activeConfig;
            this.stockItemService = stockItemService;
            this.receiptService = receiptService;
            this.imageTakeAway = (Image)imageFactory.create("/resources/images/take_away_32.png").get();
            this.imageEatIn = (Image)imageFactory.create("/resources/images/eat_in_32.png").get();
            this.imageDelivery = (Image)imageFactory.create("/resources/images/delivery_32.png").get();
            this.imagePickup = (Image)imageFactory.create("/resources/images/pickup_32.png").get();
            this.imageOnline = (Image)imageFactory.create("/resources/images/globe_32.png").get();
            this.imageUnknown = (Image)imageFactory.create("/resources/images/question-sign_32.png").get();
            this.imageCustomerNote = (Image)imageFactory.create("/resources/images/note_red_32.png").get();
            this.imageFirstOrder = (Image)imageFactory.create("/resources/images/number-1_32.png").get();
            this.imageNotRegistered = (Image)imageFactory.create("/resources/images/no-account_32.png").get();
            this.imageNoPhone = (Image)imageFactory.create("/resources/images/no-phone_32.png").get();
            this.orderCashierSection = new OrderCashierSection(this, cashierController.getOrdersFlowPane(), cashierController.getOrderScrollPane(), cashierController.normalFont, cashierController.titleFont, cashierController.subtitleFont, this.imageEatIn, this.imageTakeAway, this.imageDelivery, this.imagePickup, this.imageOnline, this.imageUnknown, this.imageCustomerNote, this.imageFirstOrder, this.imageNotRegistered, this.imageNoPhone);
            GraphicalSwitcherForMainThread.getInstance().setOrderCashierSectionService(this);
            GraphicalSwitcherForMainThread.getInstance().enableOrderCashierSection();
            this.refreshOrderSection();
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public void refreshOrderSection() {
        List orders = this.getOrdersFromDb();
        this.orderCashierSection.loadNewOrders(orders);
    }

    private List<Order> getOrdersFromDb() {
        this.orders = this.orderService.getOrdersToBeFinishedFrom6AmToNextDay6AmWithTHESEOrderStatuses(this.neededStatus);
        return this.orders;
    }

    public void clean() {
        this.cashierController.getOrdersFlowPane().getChildren().clear();
    }

    public void switchToOrderManagementScene(String orderId) {
        GraphicalSwitcherForMainThread.getInstance().disableOrderCashierSection();
        this.cashierController.switchToOrderManagementSceneWithOrder(this.cashierController.config, orderId);
    }

    public void updateOrder(Order order) {
        this.orderService.update(order);
    }

    public User getLoggedUser() {
        return (User)this.activeConfig.getLoggedInCashier().get();
    }

    public void prepareOrderForPickup(Order order) {
        Receipt receipt;
        order.setOrderStatus(ORDER_STATUS.WAITING_FOR_PICKUP);
        for (OrderItem orderItem : order.getOrderItems()) {
            for (int i = 0; i < orderItem.getQuantity(); ++i) {
                this.stockItemService.useAllStockItemsForProduct(orderItem.getMainProduct());
                for (Product addProduct : orderItem.getAdditionalProducts()) {
                    this.stockItemService.useAllStockItemsForProduct(addProduct);
                }
            }
        }
        this.updateOrder(order);
        if (order.shouldPrintReceiptOnPickupState() && this.receiptService.existsByOrderId(order.getId()) && (receipt = this.receiptService.findByOrderIdOnlyPositive(order.getId())) != null) {
            this.cashierController.printReceipt(receipt);
        }
    }

    public List<String> getCollapsedOrders() {
        return this.activeConfig.getCollapsedOrders();
    }

    public String getValueFromProperties(String key) {
        return this.cashierController.strings.getString(key);
    }

    public String getCurrencySymbol() {
        return this.activeConfig.getKioskInfo().getCurrency().getSymbol(this.activeConfig.getSelectedLocale());
    }

    public boolean isOrderLate(Order order) {
        LocalDateTime finishTime = LocalDateTime.parse(order.getToBeFinishedDateTime().toString());
        boolean stillInTime = LocalDateTime.now().isBefore(finishTime);
        return !stillInTime && order.getOrderStatus() != ORDER_STATUS.WAITING_FOR_PICKUP && order.getOrderStatus() != ORDER_STATUS.WAITING_FOR_DELIVERY;
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }

    public OrderCashierSectionService() {
    }

    public OrderService getOrderService() {
        return this.orderService;
    }

    public List<Order> getOrders() {
        return this.orders;
    }
}

