/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.Return;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.stage.Popup;
import javafx.stage.Window;
import javafx.util.Pair;
import org.controlsfx.control.SearchableComboBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CreateReturnPopup
extends Popup {
    private List<String> allOrderIds = new ArrayList();
    private Label errorMessage;
    private final BooleanProperty validData = new SimpleBooleanProperty(true);
    private StringProperty errorMessageText = new SimpleStringProperty("");
    private CashierController cashierController;
    private TextField selectedTextField;
    private TextField phoneTextField;
    private TextField amountTextField;
    private SearchableComboBox<String> orderNumberComboBox;
    private ImageFactory imageFactory = new ImageFactory(new ResourceHelper());

    public CreateReturnPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 750;
        int popupHeight = 750;
        AnchorPane popupAnchor = new AnchorPane();
        Label labelTitle = new Label();
        labelTitle.setText(cashierController.strings.getString("createReturn"));
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)5.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)100.0);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 40px;");
        Label orderNumberLabel = new Label(cashierController.strings.getString("orderId"));
        orderNumberLabel.setStyle("-fx-font-size: 24px");
        AnchorPane.setTopAnchor((Node)orderNumberLabel, (Double)85.0);
        AnchorPane.setLeftAnchor((Node)orderNumberLabel, (Double)20.0);
        AnchorPane.setRightAnchor((Node)orderNumberLabel, (Double)530.0);
        this.orderNumberComboBox = new SearchableComboBox();
        this.orderNumberComboBox.setStyle("-fx-font-size: 24px");
        AnchorPane.setTopAnchor((Node)this.orderNumberComboBox, (Double)85.0);
        AnchorPane.setLeftAnchor((Node)this.orderNumberComboBox, (Double)220.0);
        AnchorPane.setRightAnchor((Node)this.orderNumberComboBox, (Double)20.0);
        Pair phoneNumberPair = this.createLabelTextFieldPair(cashierController.strings.getString("telephoneNumber"), Double.valueOf(165.0));
        Label phoneNumberLabel = (Label)phoneNumberPair.getKey();
        this.phoneTextField = (TextField)phoneNumberPair.getValue();
        Pair amountPair = this.createLabelTextFieldPair(cashierController.strings.getString("amount"), Double.valueOf(245.0));
        Label amountLabel = (Label)amountPair.getKey();
        this.amountTextField = (TextField)amountPair.getValue();
        FlowPane keyboardFlowPane = new FlowPane();
        keyboardFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)keyboardFlowPane, (Double)325.0);
        AnchorPane.setLeftAnchor((Node)keyboardFlowPane, (Double)90.0);
        GridPane keyboardGridPane = this.createNumberKeyboard();
        keyboardFlowPane.getChildren().add((Object)keyboardGridPane);
        ConfirmButton confirmButton = new ConfirmButton();
        confirmButton.setText(cashierController.strings.getString("confirm"));
        confirmButton.setPadding(LayoutUtils.getInsets((double)5.0, (double)15.0, (double)5.0, (double)15.0));
        confirmButton.setFont(cashierController.subtitleFont);
        AnchorPane.setBottomAnchor((Node)confirmButton, (Double)15.0);
        AnchorPane.setRightAnchor((Node)confirmButton, (Double)50.0);
        CancelButton cancelButton = new CancelButton();
        cancelButton.setText(cashierController.strings.getString("cancel"));
        cancelButton.setPadding(LayoutUtils.getInsets((double)5.0, (double)15.0, (double)5.0, (double)15.0));
        cancelButton.setFont(cashierController.subtitleFont);
        AnchorPane.setBottomAnchor((Node)cancelButton, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)cancelButton, (Double)50.0);
        cancelButton.setOnMouseClicked(mouseEvent -> {
            this.hide();
            this.orderNumberComboBox.setAccessibleText("");
            this.phoneTextField.setText("");
            this.amountTextField.setText("");
        });
        cancelButton.setOnTouchPressed(touchEvent -> {
            this.hide();
            this.orderNumberComboBox.setAccessibleText("");
            this.phoneTextField.setText("");
            this.amountTextField.setText("");
        });
        confirmButton.setOnMouseClicked(mouseEvent -> this.handleReturnCreation((String)this.orderNumberComboBox.getValue(), this.phoneTextField.getText(), this.amountTextField.getText()));
        confirmButton.setOnTouchPressed(touchEvent -> this.handleReturnCreation((String)this.orderNumberComboBox.getValue(), this.phoneTextField.getText(), this.amountTextField.getText()));
        this.errorMessage = new Label();
        this.errorMessage.setStyle("-fx-font-size: 18px; -fx-color: red");
        this.errorMessage.visibleProperty().bind((ObservableValue)this.validData.not());
        this.errorMessage.textProperty().bind((ObservableValue)this.errorMessageText);
        AnchorPane.setTopAnchor((Node)this.errorMessage, (Double)500.0);
        AnchorPane.setLeftAnchor((Node)this.errorMessage, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.errorMessage, (Double)100.0);
        popupAnchor.setMinWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        popupAnchor.setStyle("-fx-background-color: khaki");
        popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, orderNumberLabel, this.orderNumberComboBox, phoneNumberLabel, this.phoneTextField, amountLabel, this.amountTextField, keyboardFlowPane, this.errorMessage, confirmButton, cancelButton});
        this.getContent().add((Object)popupAnchor);
    }

    public void loadPopup() {
        this.allOrderIds = this.cashierController.orderService.findAllIds();
        this.orderNumberComboBox.setItems(FXCollections.observableArrayList((Collection)this.allOrderIds));
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private GridPane createNumberKeyboard() {
        int i;
        LinkedList<Integer> buttonsOrder = new LinkedList<Integer>(List.of(new Integer[]{7, 8, 9, 4, 5, 6, 1, 2, 3}));
        GridPane gridPane = new GridPane();
        for (i = 0; i <= 2; ++i) {
            ColumnConstraints column = new ColumnConstraints();
            column.setHgrow(Priority.SOMETIMES);
            column.setMinWidth(10.0);
            column.setPrefWidth(100.0);
            gridPane.getColumnConstraints().add((Object)column);
        }
        for (i = 0; i <= 3; ++i) {
            RowConstraints row = new RowConstraints();
            row.setVgrow(Priority.SOMETIMES);
            row.setMinHeight(10.0);
            row.setPrefHeight(100.0);
            gridPane.getRowConstraints().add((Object)row);
        }
        Integer i2 = 1;
        while (i2 <= 9) {
            Object button = this.createKeyboardButton(String.valueOf(i2));
            int buttonIndex = buttonsOrder.indexOf(i2);
            int rowNumber = (int)Math.floor((double)buttonIndex / 3.0);
            int columnNumber = buttonIndex % 3;
            gridPane.add((Node)button, columnNumber, rowNumber);
            button = i2;
            i2 = i2 + 1;
        }
        GrayButton buttonZero = this.createKeyboardButton(String.valueOf(0));
        gridPane.add((Node)buttonZero, 1, 3);
        GrayButton buttonBackSpace = this.createKeyboardButton("x");
        buttonBackSpace.setGraphic((Node)new ImageView((Image)this.imageFactory.create("/resources/images/backspace_64.png").get()));
        gridPane.add((Node)buttonBackSpace, 2, 3);
        return gridPane;
    }

    private GrayButton createKeyboardButton(String label) {
        GrayButton button = new GrayButton();
        button.setId("keyboard_" + label);
        button.setFont(this.cashierController.subtitleFont);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(arg_0 -> this.number_keyboard_clicked(arg_0));
        button.setOnTouchPressed(arg_0 -> this.number_keyboard_clicked(arg_0));
        if (!label.equals("x")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin((Node)button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    private void number_keyboard_clicked(Event e) {
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("x")) {
            if (!this.selectedTextField.getText().isEmpty()) {
                int toDelete = 1;
                this.selectedTextField.setText(this.selectedTextField.getText().substring(0, this.selectedTextField.getText().length() - toDelete));
            }
        } else {
            this.selectedTextField.setText(this.selectedTextField.getText() + number);
        }
    }

    private void handleReturnCreation(String orderNumber, String phoneNumber, String amount) {
        Order order = null;
        if (orderNumber != null && !this.allOrderIds.contains(orderNumber)) {
            this.validData.set(false);
            this.errorMessageText.set((Object)this.cashierController.strings.getString("errorNoOrder"));
            return;
        }
        if (phoneNumber.trim().isEmpty()) {
            this.validData.set(false);
            this.errorMessageText.set((Object)this.cashierController.strings.getString("errorEmptyPhoneNumber"));
            return;
        }
        if (amount == null || amount.trim().isEmpty() || Double.parseDouble(amount) < 1.0) {
            this.validData.set(false);
            this.errorMessageText.set((Object)this.cashierController.strings.getString("errorZero"));
            return;
        }
        if (orderNumber != null) {
            order = this.cashierController.orderService.findByIdQuery(orderNumber);
            if (order == null) {
                this.validData.set(false);
                this.errorMessageText.set((Object)this.cashierController.strings.getString("errorNoOrder"));
                return;
            }
            double maxReturnAmount = order.getTotalPrice();
            if (Double.parseDouble(amount) > maxReturnAmount) {
                this.validData.set(false);
                this.errorMessageText.set((Object)this.cashierController.strings.getString("errorAmountsConflict"));
                return;
            }
        }
        this.validData.set(true);
        Return returnObject = new Return();
        returnObject.setOrder(order);
        returnObject.setAmount(Double.valueOf(Double.parseDouble(amount)));
        returnObject.setTimestamp(LocalDateTime.now());
        returnObject.setPhoneNumber(phoneNumber);
        this.cashierController.returnService.save(returnObject);
        this.orderNumberComboBox.setAccessibleText("");
        this.phoneTextField.setText("");
        this.amountTextField.setText("");
        this.hide();
    }

    private Pair<Label, TextField> createLabelTextFieldPair(String labelText, Double topAnchor) {
        Label label = new Label(labelText);
        label.setStyle("-fx-font-size: 24px");
        AnchorPane.setTopAnchor((Node)label, (Double)topAnchor);
        AnchorPane.setLeftAnchor((Node)label, (Double)20.0);
        AnchorPane.setRightAnchor((Node)label, (Double)530.0);
        TextField textField = new TextField();
        textField.setFocusTraversable(false);
        textField.getProperties().put((Object)"vkType", (Object)"none");
        textField.setFont(this.cashierController.subtitleFont);
        textField.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
            this.selectedTextField = textField;
        });
        AnchorPane.setTopAnchor((Node)textField, (Double)topAnchor);
        AnchorPane.setLeftAnchor((Node)textField, (Double)220.0);
        AnchorPane.setRightAnchor((Node)textField, (Double)20.0);
        return new Pair((Object)label, (Object)textField);
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }
}

