/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.utils.ExceptionHandler;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ResourceHelper {
    private static final Logger log = LoggerFactory.getLogger(ResourceHelper.class);
    private final String BROKEN_IMAGE_PATH = "/resources/images/broken-image.png";
    private String location = this.createLocation();

    public ResourceHelper() {
        log.info("[LOCATION] - location - {}", (Object)this.location);
    }

    public InputStream getResourceAsStream(String filePath) {
        try {
            return ResourceHelper.class.getResourceAsStream(filePath);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public InputStream getImageAsStream(String imageFilePath) {
        InputStream is = this.getResourceAsStream(imageFilePath);
        if (is == null && !"/resources/images/broken-image.png".equals(imageFilePath)) {
            is = this.getResourceAsStream("/resources/images/broken-image.png");
        }
        return is;
    }

    public InputStream getImageAsStream(String imageFilePath, String defaultImagePath) {
        InputStream is = this.getResourceAsStream(imageFilePath);
        if (is == null && !defaultImagePath.equals(imageFilePath)) {
            is = this.getResourceAsStream(defaultImagePath);
        }
        return is;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readResourceBytes(String path) {
        try (InputStream is = ResourceHelper.class.getResourceAsStream(path);){
            if (is == null) {
                log.error("Resource not found: {}", (Object)path);
                byte[] byArray2 = null;
                return byArray2;
            }
            byte[] byArray = is.readAllBytes();
            return byArray;
        }
        catch (IOException e) {
            log.error("Failed to read resource: {}", (Object)path, (Object)e);
            ExceptionHandler.logException((Exception)e);
            return null;
        }
        catch (Exception e) {
            log.error("Unexpected error reading resource: {}", (Object)path, (Object)e);
            ExceptionHandler.logException((Exception)e);
        }
        return null;
    }

    public String getBaseLocation() {
        if (this.location.contains(".jar")) {
            int i;
            String[] locArr = this.location.split("/");
            for (i = 0; i < locArr.length && !locArr[i].contains(".jar"); ++i) {
            }
            CharSequence[] newArray = Arrays.copyOfRange(locArr, 1, i);
            String result = "/" + String.join((CharSequence)"/", newArray) + "/";
            return result;
        }
        return this.location;
    }

    public BufferedImage loadImageFromFile(String imagePath) {
        try {
            return ImageIO.read(new File(imagePath));
        }
        catch (IOException e) {
            ExceptionHandler.logException((Exception)e);
            return null;
        }
    }

    public String convertImagePathFromExternal(String imagePath) {
        int index = imagePath.lastIndexOf(47);
        return "/resources/images/" + imagePath.substring(index + 1);
    }

    public void transferFileWithSCP(String sourcePath, String destinationPath, String host) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("scp", sourcePath, String.format("%s:%s", host, destinationPath));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info(line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                log.info("File transfer successful.");
            } else {
                log.error("File transfer failed with exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            log.error("An error occurred: " + e.getMessage());
        }
    }

    public void syncImagesByNameOnly(String sourceDir, String destinationDir, String host) {
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("rsync", "-r", "--ignore-existing", sourceDir + "/", String.format("%s:%s", host, destinationDir));
            processBuilder.redirectErrorStream(true);
            Process process = processBuilder.start();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    log.info(line);
                }
            }
            int exitCode = process.waitFor();
            if (exitCode == 0) {
                log.info("Image synchronization successful.");
            } else {
                log.error("Image synchronization failed with exit code: " + exitCode);
            }
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    public List<String> getAvailableImagePaths(String folder) {
        return this.getAvailableFilePaths(folder, Set.of(".png", ".jpg", ".jpeg", ".gif"));
    }

    public List<String> getAvailableMediaPaths(String folder) {
        return this.getAvailableFilePaths(folder, Set.of(".mp4"));
    }

    private List<String> getAvailableFilePaths(String folder, Set<String> extensions) {
        List<String> list;
        block10: {
            Optional pathOpt = this.getResourceToURI(folder);
            if (pathOpt.isEmpty()) {
                return List.of();
            }
            Path folderPath = (Path)pathOpt.get();
            if (!Files.exists(folderPath, new LinkOption[0]) || !Files.isDirectory(folderPath, new LinkOption[0])) {
                log.warn("Folder does not exist or invalid: {}", (Object)folderPath);
                return List.of();
            }
            Stream<Path> stream = Files.list(folderPath);
            try {
                list = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> extensions.contains(this.getFileExtension(p.getFileName().toString()))).map(p -> folder + "/" + p.getFileName()).toList();
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to list files in folder: {}", (Object)folderPath, (Object)e);
                    ExceptionHandler.logException((Exception)e);
                    return List.of();
                }
            }
            stream.close();
        }
        return list;
    }

    private String getFileExtension(String fileName) {
        int idx = fileName.lastIndexOf(46);
        return idx >= 0 ? fileName.substring(idx).toLowerCase() : "";
    }

    public Optional<Path> getResourceToURI(String resourceFolderPath) {
        URL resourceUrl = this.getResourceUrl(resourceFolderPath);
        if (resourceUrl == null) {
            log.error("{} does not exist in project", (Object)resourceFolderPath);
            return Optional.empty();
        }
        try {
            return Optional.of(Paths.get(resourceUrl.toURI()));
        }
        catch (URISyntaxException e) {
            log.error("Invalid URI syntax for resource: {}", (Object)resourceFolderPath, (Object)e);
            ExceptionHandler.logException((Exception)e);
            return Optional.empty();
        }
    }

    public boolean deleteFile(String filePath) {
        try {
            URL url = this.getResourceUrl(filePath);
            if (url == null) {
                return false;
            }
            Path path = Paths.get(url.toURI());
            File file = path.toFile();
            return file.exists() && file.delete();
        }
        catch (Exception e) {
            log.error("Error deleting file {}", (Object)filePath, (Object)e);
            return false;
        }
    }

    public URL getResourceUrl(String filePath) {
        if (filePath == null || filePath.isBlank()) {
            log.warn("Requested resource with an empty or null filePath");
            return null;
        }
        URL url = this.getResource(filePath);
        if (url == null) {
            log.error("Resource not found: {}", (Object)filePath);
        } else {
            log.debug("Resource found at path: {}", (Object)filePath);
        }
        return url;
    }

    protected URL getResource(String filePath) {
        return ResourceHelper.class.getResource(filePath);
    }

    public String createLocation() {
        String path = this.resolveCodeSourcePath();
        if (path.startsWith("/")) {
            return path.substring(1);
        }
        return path;
    }

    protected String resolveCodeSourcePath() {
        return ResourceHelper.class.getProtectionDomain().getCodeSource().getLocation().getPath();
    }

    public String getBROKEN_IMAGE_PATH() {
        Objects.requireNonNull(this);
        return "/resources/images/broken-image.png";
    }
}

