/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.utils;

import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.config.LabelPrinterConfig;
import cz.polreich.spagetka.utils.BytePrinter;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.TextImageGenerator;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import javax.print.PrintService;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public class LabelPrinter
extends BytePrinter {
    private static String HEADER_TEMPLATE = "SIZE {0}, {1}\nGAP {2}, {3}\nREFERENCE {4}, {5}\nSPEED {6}\nDENSITY {7}\nCODEPAGE {17}\nSET PEEL {8}\nSET CUTTER {9}\nSET PARTIAL_CUTTER {10}\nSET TEAR {11}\nSET RIBBON {12}\nSET DEBUG {13}\nDIRECTION {14}\nSHIFT {15}\nOFFSET {16}\n";

    public LabelPrinter() {
    }

    public LabelPrinter(PrintService printService) {
        this.setPrintService(printService);
    }

    public static void printLabelsForOrder(LabelPrinterConfig labelPrinterConfig, Order order) {
        byte[] bytes = new byte[]{};
        for (OrderItem orderItem : order.getOrderItems()) {
            bytes = LabelPrinter.appendArrays((byte[][])new byte[][]{bytes, LabelPrinter.getBytesForOrderItem((LabelPrinterConfig)labelPrinterConfig, (OrderItem)orderItem)});
        }
        if (bytes.length > 0) {
            LabelPrinter.printBytes((LabelPrinterConfig)labelPrinterConfig, (byte[])bytes);
        }
    }

    private static byte[] getBytesForOrderItem(LabelPrinterConfig labelPrinterConfig, OrderItem orderItem) {
        byte[] bytes = new byte[]{};
        if (!orderItem.getSubItems().isEmpty()) {
            for (OrderItem subItem : orderItem.getSubItems()) {
                if (!labelPrinterConfig.getEnabledCategories().contains(subItem.getMainProduct().getCategory())) continue;
                bytes = LabelPrinter.appendArrays((byte[][])new byte[][]{bytes, LabelPrinter.getPrintCommandForLabel((LabelPrinterConfig)labelPrinterConfig, (Product)subItem.getMainProduct(), (int)(orderItem.getQuantity() * subItem.getQuantity()))});
            }
        } else if (labelPrinterConfig.getEnabledCategories().contains(orderItem.getMainProduct().getCategory())) {
            bytes = LabelPrinter.appendArrays((byte[][])new byte[][]{bytes, LabelPrinter.getPrintCommandForLabel((LabelPrinterConfig)labelPrinterConfig, (Product)orderItem.getMainProduct(), (int)orderItem.getQuantity())});
        }
        return bytes;
    }

    private static byte[] getPrintCommandForLabel(LabelPrinterConfig c, Product product, int quantity) {
        String header = LabelPrinter.formatHeader((LabelPrinterConfig)c);
        String[] splitText = LabelPrinter.splitText((String)product.getStickerName());
        try {
            return LabelPrinter.combineByteArrays((byte[][])new byte[][]{LabelPrinter.getBytesForString((String)header, (String)"CP1250"), LabelPrinter.prepareBitmapCommandFromFile((byte[])c.getLogoImageBytes(), (int)50, (int)10, (int)300), LabelPrinter.prepareBitmapCommandFromFile((byte[])TextImageGenerator.getImageBytesForText((String[])splitText, (int)350, (int)300), (int)20, (int)160, (int)350), LabelPrinter.getBytesForString((String)("PRINT " + quantity + ",1\n"), (String)"CP1250")});
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return new byte[0];
        }
    }

    public static void printBytes(LabelPrinterConfig c, byte[] bytes) {
        System.out.println(LabelPrinter.getPrinters());
        PrintService printService = LabelPrinter.findPrintService((String)c.getPrinterName());
        LabelPrinter labelPrinter = new LabelPrinter(printService);
        labelPrinter.printBytes((byte[][])new byte[][]{bytes});
    }

    public static String[] splitText(String input) {
        if (input == null || input.isEmpty()) {
            return new String[0];
        }
        String[] words = input.split("\\s+");
        StringBuilder currentLine = new StringBuilder();
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < words.length; ++i) {
            String word = words[i];
            if (currentLine.length() + word.length() + (currentLine.isEmpty() ? 0 : 1) > 15) {
                String lastWord;
                String[] lineWords = currentLine.toString().split(" ");
                if (lineWords.length > 0 && (lastWord = lineWords[lineWords.length - 1]).length() <= 2) {
                    currentLine.setLength(currentLine.length() - lastWord.length() - 1);
                    lines.add(currentLine.toString());
                    currentLine.setLength(0);
                    currentLine.append(lastWord);
                    if (currentLine.length() + word.length() + 1 <= 15) {
                        currentLine.append(" ").append(word);
                        continue;
                    }
                    lines.add(currentLine.toString());
                    currentLine.setLength(0);
                    currentLine.append(word);
                    continue;
                }
                lines.add(currentLine.toString());
                currentLine.setLength(0);
            }
            if (!currentLine.isEmpty()) {
                currentLine.append(" ");
            }
            currentLine.append(word);
        }
        if (!currentLine.isEmpty()) {
            String[] lineWords = currentLine.toString().split(" ");
            if (lineWords.length > 1 && lineWords[lineWords.length - 1].length() <= 2) {
                StringBuilder newLine = new StringBuilder();
                for (int i = 0; i < lineWords.length - 1; ++i) {
                    if (i > 0) {
                        newLine.append(" ");
                    }
                    newLine.append(lineWords[i]);
                }
                lines.add(newLine.toString());
                lines.add(lineWords[lineWords.length - 1]);
            } else {
                lines.add(currentLine.toString());
            }
        }
        if (lines.size() == 1) {
            lines.add(0, "");
        }
        return lines.toArray(new String[0]);
    }

    public static byte[] combineByteArrays(byte[] ... arrays) {
        int totalLength = 0;
        for (byte[] array : arrays) {
            totalLength += array.length;
        }
        byte[] result = new byte[totalLength];
        int currentPos = 0;
        for (byte[] array : arrays) {
            System.arraycopy(array, 0, result, currentPos, array.length);
            currentPos += array.length;
        }
        return result;
    }

    @NotNull
    private static String formatHeader(LabelPrinterConfig c) {
        String header = MessageFormat.format(HEADER_TEMPLATE, c.getLabelDimensions().getWidth(), c.getLabelDimensions().getHeight(), c.getLabelDimensions().getGapSize(), c.getLabelDimensions().getGapOffset(), c.getReferenceX(), c.getReferenceY(), c.getSpeed(), c.getDensity(), c.getSetPeel(), c.getSetCutter(), c.getSetPartialCutter(), c.getSetTear(), c.getSetRibbon(), c.getSetDebug(), c.getDirection(), c.getShift(), c.getOffset(), c.getCodepage());
        return c.getAddCls() != null && c.getAddCls() != false ? header + "CLS\n" : header;
    }

    public static byte[] prepareBitmapCommandFromFile(byte[] imageData, int x, int y, int desiredWidth) throws IOException {
        BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
        int targetWidth = desiredWidth / 8 * 8;
        if (targetWidth < 8) {
            throw new IllegalArgumentException("Width must be at least 8 and divisible by 8.");
        }
        int targetHeight = (int)((double)image.getHeight() * ((double)targetWidth / (double)image.getWidth()));
        Image scaled = image.getScaledInstance(targetWidth, targetHeight, 4);
        BufferedImage resized = new BufferedImage(targetWidth, targetHeight, 12);
        Graphics2D g2d = resized.createGraphics();
        g2d.drawImage(scaled, 0, 0, null);
        g2d.dispose();
        int widthBytes = (int)Math.ceil((double)targetWidth / 8.0);
        int height = resized.getHeight();
        byte[] bitmapData = new byte[widthBytes * height];
        for (int yPos = 0; yPos < height; ++yPos) {
            for (int xByte = 0; xByte < widthBytes; ++xByte) {
                byte b = 0;
                for (int bit = 0; bit < 8; ++bit) {
                    int xPos = xByte * 8 + bit;
                    if (xPos >= targetWidth) continue;
                    int rgb = resized.getRGB(xPos, yPos);
                    int luminance = rgb >> 16 & 0xFF;
                    boolean isBlack = luminance >= 128;
                    b = (byte)(b | (byte)((isBlack ? 1 : 0) << 7 - bit));
                }
                bitmapData[yPos * widthBytes + xByte] = b;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        String header = String.format("BITMAP %d,%d,%d,%d,0,", x, y, widthBytes, height);
        baos.write(header.getBytes());
        baos.write(bitmapData);
        return baos.toByteArray();
    }
}

