/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.computer_command_service;

import cz.polreich.spagetka.models.enums.COMPUTER;
import cz.polreich.spagetka.models.enums.COMPUTER_MANAGEMENT_ACTION;
import cz.polreich.spagetka.service.computer_command_service.CommandExecutor;
import cz.polreich.spagetka.service.computer_command_service.model.CommandExecutorResult;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SshCommandExecutor {
    private static final Logger log = LoggerFactory.getLogger(SshCommandExecutor.class);
    private static final String LOG_PREFIX = "[SSH COMMAND EXECUTOR]";
    private static final String LOG_ERROR_PREFIX = "[SSH COMMAND EXECUTOR]-[ERROR]";
    private static final String AARCH_FILESYSTEM = "/dev/mmcblk0p2";
    private static final String UBUNTU_FILESYSTEM = "/dev/sdc";
    private final CommandExecutor commandExecutor;

    @Autowired
    public SshCommandExecutor(CommandExecutor commandExecutor) {
        this.commandExecutor = commandExecutor;
    }

    public CommandExecutorResult getFreeSpaceInMBInformation(COMPUTER computer, COMPUTER_MANAGEMENT_ACTION action) {
        CommandExecutorResult result = new CommandExecutorResult(computer, action);
        Object[] command = this.buildCommand(computer, action);
        try {
            Optional processOptional = this.commandExecutor.executeCommand((String[])command);
            if (processOptional.isEmpty()) {
                log.error("{} - Process is null for computer: {}. Command: {}", new Object[]{LOG_ERROR_PREFIX, result.getComputer().getName(), Arrays.toString(command)});
                result.setComputerIsReachable(false);
                return result;
            }
            Process process = (Process)processOptional.get();
            this.parseDiskInfo(process, result);
            int exitCode = process.waitFor();
            result.setComputerIsReachable(exitCode == 0);
            this.logExitCode(result.getComputer().getName(), exitCode, (String[])command);
        }
        catch (Exception e) {
            log.error("{} - Error executing command for computer: {}: {}", new Object[]{LOG_ERROR_PREFIX, result.getComputer().getName(), e.getMessage()});
            result.setComputerIsReachable(false);
        }
        return result;
    }

    public void executeComputerAction(COMPUTER computer, COMPUTER_MANAGEMENT_ACTION action, boolean isRemote) {
        log.info("{} - [EXECUTE COMPUTER ACTION] - Computer: {} | Action: {} | IsRemote: {}", new Object[]{LOG_PREFIX, computer.getHostname(), action.getCommand(), isRemote});
        String[] command = this.buildCommand(computer, action);
        try {
            Optional processOptional = this.commandExecutor.executeCommand(command);
            if (processOptional.isEmpty()) {
                log.error("{} - [EXECUTE COMPUTER ACTION] - Process is null. Command: {}", (Object)LOG_PREFIX, (Object)command);
                return;
            }
            int exitCode = ((Process)processOptional.get()).waitFor();
            this.logExitCode(computer.getHostname(), exitCode, command);
        }
        catch (Exception e) {
            log.error("{} - [EXECUTE COMPUTER ACTION] - Error executing command for {}: {}", new Object[]{LOG_PREFIX, computer.getHostname(), e.getMessage()});
        }
    }

    public String[] buildCommand(COMPUTER computer, COMPUTER_MANAGEMENT_ACTION action) {
        if (computer.isRemote()) {
            return new String[]{"ssh", computer.getSshRemoteAddress(), action.getCommandRemoteFormat()};
        }
        return action.getCommandAsArray();
    }

    private void parseDiskInfo(Process process, CommandExecutorResult result) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(AARCH_FILESYSTEM) && !line.contains(UBUNTU_FILESYSTEM)) continue;
                log.debug(line);
                String[] elements = line.replaceAll("\\s{2,}", " ").trim().split(" ");
                result.setFreeSpaceMB((long)(Integer.parseInt(elements[3]) / 1024));
                result.setFreeSpaceInPercent(elements[4]);
                break;
            }
        }
    }

    private void logExitCode(String computerName, int exitCode, String[] command) {
        String status = exitCode == 0 ? "available" : "not available";
        log.debug("{} - Computer {} is {}", new Object[]{LOG_PREFIX, computerName, status});
        log.debug("{} - Exit code: {} | Command: {}", new Object[]{LOG_PREFIX, exitCode, Arrays.toString(command)});
    }
}

