/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.cashier.grapchical;

import cz.polreich.spagetka.controllers.layout.orderManagementController.OrderFlowPaneForOrderManagement;
import cz.polreich.spagetka.controllers.popup.cashierController.OrderCashierSectionService;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.application.Platform;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphicalSwitcherForMainThread {
    private static final Logger log = LoggerFactory.getLogger(GraphicalSwitcherForMainThread.class);
    private static final GraphicalSwitcherForMainThread INSTANCE = new GraphicalSwitcherForMainThread();
    private AtomicBoolean renderOrderCashierSection = new AtomicBoolean(false);
    private AtomicBoolean renderOrdersInOrderManagement = new AtomicBoolean(false);
    private OrderCashierSectionService orderCashierSectionService;
    private OrderFlowPaneForOrderManagement orderFlowPaneForOrderManagement;

    public static GraphicalSwitcherForMainThread getInstance() {
        return INSTANCE;
    }

    private GraphicalSwitcherForMainThread() {
    }

    public void renderOrderCashierSection() {
        if (this.renderOrderCashierSection.get()) {
            log.debug("LOAD NEW ORDERS IN ORDER VBOX");
            Platform.runLater(() -> this.orderCashierSectionService.refreshOrderSection());
        }
    }

    public void enableOrderCashierSection() {
        this.renderOrderCashierSection.set(true);
        this.renderOrdersInOrderManagement.set(false);
    }

    public void disableOrderCashierSection() {
        this.renderOrderCashierSection.set(false);
        this.renderOrdersInOrderManagement.set(true);
    }

    public void renderOrdersInOrderManagement() {
        if (this.renderOrdersInOrderManagement.get()) {
            log.debug("REFRESHING ORDER FLOW PANE");
            Platform.runLater(() -> this.orderFlowPaneForOrderManagement.refresh());
        }
    }

    public void enableOrdersInOrderManagement() {
        this.renderOrdersInOrderManagement.set(true);
        this.renderOrderCashierSection.set(false);
    }

    public void disableOrdersInOrderManagement() {
        this.renderOrdersInOrderManagement.set(false);
        this.renderOrderCashierSection.set(true);
    }

    public void disableAll() {
        this.renderOrdersInOrderManagement.set(false);
        this.renderOrderCashierSection.set(false);
    }

    public void setOrderCashierSectionService(OrderCashierSectionService orderCashierSectionService) {
        this.orderCashierSectionService = orderCashierSectionService;
    }

    public void setOrderFlowPaneForOrderManagement(OrderFlowPaneForOrderManagement orderFlowPaneForOrderManagement) {
        this.orderFlowPaneForOrderManagement = orderFlowPaneForOrderManagement;
    }
}

