/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.DTO.discountCodes.DiscountCodeCreateResponse;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.config.CashierConfig;
import cz.polreich.spagetka.models.config.PrinterConfig;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.ReceiptPrinter;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GiftVoucherService {
    private static final Logger log = LoggerFactory.getLogger(GiftVoucherService.class);
    private final OrderService orderService;
    private final PartnerServerRestClient partnerServerRestClient;
    private final CashierConfig activeConfig;

    public GiftVoucherService(OrderService orderService, PartnerServerRestClient partnerServerRestClient, CashierConfig cashierConfig) {
        this.orderService = orderService;
        this.partnerServerRestClient = partnerServerRestClient;
        this.activeConfig = cashierConfig;
    }

    public void checkForGiftVouchers(List<Order> orders) {
        for (Order order : orders) {
            this.checkForGiftVouchers(order);
        }
    }

    public void checkForGiftVouchers(Order order) {
        if (!order.isPaid() || !this.orderContainsGiftCertificate(order)) {
            return;
        }
        List<OrderItem> voucherItems = order.getOrderItems().stream().filter(oi -> oi.getMainProduct().getCategory() == this.activeConfig.getGiftVouchersCategoryId()).toList();
        for (OrderItem item : voucherItems) {
            this.processVoucherItem(order, item);
        }
    }

    public boolean orderContainsGiftCertificate(Order order) {
        return order != null && order.containsItemOfCategory(this.activeConfig.getGiftVouchersCategoryId());
    }

    private void processVoucherItem(Order order, OrderItem orderItem) {
        if (orderItem.getGiftVoucherCode() != null) {
            return;
        }
        int quantity = orderItem.getQuantity();
        if (quantity == 1) {
            this.requestVoucherAndPersist(order, orderItem);
            return;
        }
        this.splitAndProcessMultiple(order, orderItem, quantity);
    }

    private void splitAndProcessMultiple(Order order, OrderItem originalItem, int quantity) {
        for (int i = 0; i < quantity - 1; ++i) {
            OrderItem newItem = new OrderItem(originalItem);
            newItem.setQuantity(1);
            this.requestVoucherAndPersist(order, newItem);
            order.addOrderItem(newItem, false);
        }
        originalItem.setQuantity(1);
        this.requestVoucherAndPersist(order, originalItem);
    }

    private void requestVoucherAndPersist(Order order, OrderItem item) {
        try {
            this.requestVoucherCode(item);
            Order refreshedOrder = this.orderService.findByIdNamed(order.getId());
            if (refreshedOrder != null) {
                order.setAnnounced(Boolean.valueOf(refreshedOrder.isAnnounced()));
            }
            this.orderService.update(order);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }

    private void requestVoucherCode(OrderItem orderItem) {
        try {
            Double amount = orderItem.getMainProduct().getActualPrice();
            DiscountCodeCreateResponse response = this.partnerServerRestClient.requestDiscountCodeCreation(amount.doubleValue(), null);
            orderItem.setGiftVoucherCode(response.getDiscountCode());
            orderItem.setGiftVoucherValidity(LocalDateTime.parse(response.getValidUntil(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            ReceiptPrinter.printGiftVoucherCode((PrinterConfig)this.activeConfig.getPrinterConfig(), (DiscountCodeCreateResponse)response, (double)amount);
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }
}

