/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.VatAmountDTO;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Entity
public class VatAmount {
    @Id
    @GeneratedValue(strategy=GenerationType.UUID)
    private String id;
    @Column
    private Double vatPercent;
    @Column(precision=10, scale=2)
    private BigDecimal baseAmount = new BigDecimal(0);
    @Column(precision=10, scale=2)
    private BigDecimal vatAmount = new BigDecimal(0);
    @Column(precision=10, scale=2)
    private BigDecimal totalAmount = new BigDecimal(0);

    public void addBaseAmount(BigDecimal addedValue) {
        this.baseAmount = this.baseAmount.add(addedValue);
    }

    public void addVatAmount(BigDecimal addedValue) {
        this.vatAmount = this.vatAmount.add(addedValue);
    }

    public void addTotalAmount(BigDecimal addedValue) {
        this.totalAmount = this.totalAmount.add(addedValue);
    }

    public VatAmount(VatAmountDTO dto) {
        this.id = dto.getId();
        this.vatPercent = dto.getVatPercent();
        this.baseAmount = BigDecimal.valueOf(dto.getBaseAmount()).setScale(2, RoundingMode.HALF_UP);
        this.vatAmount = BigDecimal.valueOf(dto.getVatAmount()).setScale(2, RoundingMode.HALF_UP);
        this.totalAmount = BigDecimal.valueOf(dto.getTotalAmount()).setScale(2, RoundingMode.HALF_UP);
    }

    public String getId() {
        return this.id;
    }

    public Double getVatPercent() {
        return this.vatPercent;
    }

    public BigDecimal getBaseAmount() {
        return this.baseAmount;
    }

    public BigDecimal getVatAmount() {
        return this.vatAmount;
    }

    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setVatPercent(Double vatPercent) {
        this.vatPercent = vatPercent;
    }

    public void setBaseAmount(BigDecimal baseAmount) {
        this.baseAmount = baseAmount;
    }

    public void setVatAmount(BigDecimal vatAmount) {
        this.vatAmount = vatAmount;
    }

    public void setTotalAmount(BigDecimal totalAmount) {
        this.totalAmount = totalAmount;
    }

    public VatAmount() {
    }

    public VatAmount(String id, Double vatPercent, BigDecimal baseAmount, BigDecimal vatAmount, BigDecimal totalAmount) {
        this.id = id;
        this.vatPercent = vatPercent;
        this.baseAmount = baseAmount;
        this.vatAmount = vatAmount;
        this.totalAmount = totalAmount;
    }
}

