/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.factory;

import cz.polreich.spagetka.DTO.ProductFreeVariantDTO;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import javax.xml.bind.DatatypeConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductFreeVariantFactory {
    private ResourceHelper resourceHelper;

    public ProductFreeVariant create(ProductFreeVariantDTO dto, boolean fromExternal) {
        ProductFreeVariant freeVariant = new ProductFreeVariant();
        freeVariant.setId(dto.getId());
        freeVariant.setName(dto.getName());
        freeVariant.setPrice(dto.getPrice());
        if (fromExternal) {
            freeVariant.setImageFilePath(this.resourceHelper.convertImagePathFromExternal(dto.getImageFilePath()));
        } else {
            freeVariant.setImageFilePath(dto.getImageFilePath());
        }
        freeVariant.setRemoteImagePath(dto.getImageFilePath());
        if (ValidationUtils.isStringNotNullOrEmpty((String)dto.getImageBytesBase64())) {
            freeVariant.setImageBytes(DatatypeConverter.parseBase64Binary((String)dto.getImageBytesBase64()));
        } else {
            freeVariant.setImageBytes(new byte[0]);
        }
        freeVariant.setEnabled(Boolean.TRUE.equals(dto.getAllowedAtKiosk()));
        freeVariant.setItemOrder(dto.getOrder() != null ? dto.getOrder() : 999);
        return freeVariant;
    }

    @Autowired
    public void setResourceHelper(ResourceHelper resourceHelper) {
        this.resourceHelper = resourceHelper;
    }
}

