/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.controllers.Controller;
import cz.polreich.spagetka.models.config.CashierConfig;
import java.util.ResourceBundle;
import javafx.scene.text.Font;
import javax.annotation.PostConstruct;

public class CashierBaseController
extends Controller {
    public CashierConfig activeConfig;
    public Font titleFont;
    public Font subtitleFont;
    public Font mainSceneButtonsFont;
    public Font orderManagementActionButtonsFont;
    public Font normalFont;

    @PostConstruct
    public void init() {
        super.init();
        this.activeConfig = this.config.getCashier();
    }

    public void setupScene() {
        super.setupScene();
        this.strings = ResourceBundle.getBundle("resources/strings/cashier", this.activeConfig.getSelectedLocale());
    }

    public void setupFonts() {
        super.setupFonts();
        this.registerFonts(this.activeConfig.getFonts());
        this.titleFont = this.setupCashierFont("title");
        this.subtitleFont = this.setupCashierFont("subtitle");
        this.mainSceneButtonsFont = this.setupCashierFont("mainSceneButtons");
        this.orderManagementActionButtonsFont = this.setupCashierFont("orderManagementActionButtons");
        this.normalFont = this.setupCashierFont("normal");
    }

    public void setupColors() {
        super.setupColors();
    }

    public CashierConfig getActiveConfig() {
        return this.activeConfig;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public Font getSubtitleFont() {
        return this.subtitleFont;
    }

    public Font getMainSceneButtonsFont() {
        return this.mainSceneButtonsFont;
    }

    public Font getOrderManagementActionButtonsFont() {
        return this.orderManagementActionButtonsFont;
    }

    public Font getNormalFont() {
        return this.normalFont;
    }
}

