/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.restControllers;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.config.Config;
import cz.polreich.spagetka.models.config.RestClientConfig;
import cz.polreich.spagetka.service.AllergenService;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.service.KioskInfoService;
import cz.polreich.spagetka.service.MenuOptionService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.ProductsGroupService;
import cz.polreich.spagetka.service.RecipeStepService;
import cz.polreich.spagetka.service.UserService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.PasswordDecryptor;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/control"})
@Tag(name="Kiosk Control API", description="Handles Kiosk Control operations")
public class KioskControlController {
    @Autowired
    public Config config;
    private RestClientConfig clientConfig;
    private String apiKey = "";
    @Autowired
    private CategoryService categoryService;
    @Autowired
    private IngredientService ingredientService;
    @Autowired
    private MenuOptionService menuOptionService;
    @Autowired
    private ProductService productService;
    @Autowired
    private ProductsGroupService productsGroupService;
    @Autowired
    private RecipeStepService recipeStepService;
    @Autowired
    private UserService userService;
    @Autowired
    private AllergenService allergenService;
    @Autowired
    private KioskInfoService kioskInfoService;
    @Autowired
    private CashierController cashierController;

    @PostConstruct
    public void init() {
        this.clientConfig = this.config.getCommon().getRestClientConfig();
        this.apiKey = PasswordDecryptor.decryptPassword((String)this.clientConfig.getEncAPIKey());
    }

    @GetMapping(value={"/updateData"})
    @ResponseBody
    @Operation(summary="Forces kiosk to update all data from Partner server")
    public ResponseEntity<String> updateData() {
        try {
            return ResponseEntity.ok().body((Object)"Update finished.");
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return ResponseEntity.internalServerError().body((Object)"Update failed.");
        }
    }
}

