/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.OrderManagementController;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class ShowGiftVoucherPopup
extends Popup {
    private OrderManagementController orderManagementController;
    private Label descriptionLabel;
    private List<Product> filteredProducts = new ArrayList();
    private VBox vouchersVBox = new VBox();

    public ShowGiftVoucherPopup(OrderManagementController orderManagementController) {
        this.orderManagementController = orderManagementController;
        int popupWidth = 900;
        int popupHeight = 700;
        AnchorPane popupAnchor = new AnchorPane();
        Label labelTitle = new Label();
        labelTitle.setText("D\u00e1rkov\u00e9 poukazy");
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)10.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)10.0);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 40px;");
        this.descriptionLabel = new Label("");
        this.descriptionLabel.setMaxWidth(300.0);
        this.descriptionLabel.setAlignment(Pos.CENTER);
        this.descriptionLabel.setFont(orderManagementController.mainSceneButtonsFont);
        this.descriptionLabel.setVisible(false);
        AnchorPane.setTopAnchor((Node)this.descriptionLabel, (Double)170.0);
        AnchorPane.setLeftAnchor((Node)this.descriptionLabel, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.descriptionLabel, (Double)10.0);
        this.vouchersVBox = new VBox();
        this.vouchersVBox.setAlignment(Pos.TOP_LEFT);
        AnchorPane.setTopAnchor((Node)this.vouchersVBox, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.vouchersVBox, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.vouchersVBox, (Double)10.0);
        CancelButton closeButton = new CancelButton("Zav\u0159\u00edt");
        closeButton.setOnMouseClicked(e -> this.hidePopup());
        closeButton.setFont(orderManagementController.mainSceneButtonsFont);
        AnchorPane.setBottomAnchor((Node)closeButton, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)closeButton, (Double)100.0);
        AnchorPane.setRightAnchor((Node)closeButton, (Double)100.0);
        popupAnchor.setMinWidth((double)popupWidth);
        popupAnchor.setMaxWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        popupAnchor.setMaxHeight((double)popupHeight);
        popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, this.descriptionLabel, this.vouchersVBox, closeButton});
        this.getContent().add((Object)popupAnchor);
    }

    public void loadPopup(Order order) {
        int categoryId = this.orderManagementController.activeConfig.getGiftVouchersCategoryId();
        if (order.isPaid()) {
            this.descriptionLabel.setVisible(false);
            this.descriptionLabel.setText("");
            for (OrderItem orderItem : order.getOrderItems()) {
                if (orderItem.getMainProduct().getCategory() != categoryId) continue;
                HBox hbox = new HBox();
                hbox.setAlignment(Pos.CENTER_LEFT);
                hbox.setSpacing(30.0);
                Label nameLabel = new Label(orderItem.getMainProduct().getName());
                nameLabel.setFont(this.orderManagementController.mainSceneButtonsFont);
                nameLabel.setAlignment(Pos.CENTER_LEFT);
                Label codeLabel = new Label(orderItem.getGiftVoucherCode());
                codeLabel.setFont(this.orderManagementController.mainSceneButtonsFont);
                codeLabel.setAlignment(Pos.CENTER_LEFT);
                Label validityLabel = new Label(orderItem.getGiftVoucherValidity().format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
                validityLabel.setFont(this.orderManagementController.mainSceneButtonsFont);
                validityLabel.setAlignment(Pos.CENTER_LEFT);
                ConfirmButton printButton = new ConfirmButton("Tisk");
                printButton.setFont(this.orderManagementController.mainSceneButtonsFont);
                printButton.setOnMouseClicked(e -> this.orderManagementController.printGiftVoucher(orderItem.getGiftVoucherCode(), orderItem.getGiftVoucherValidity(), orderItem.getMainProduct().getActualPrice().doubleValue()));
                hbox.getChildren().addAll((Object[])new Node[]{nameLabel, codeLabel, validityLabel, printButton});
                this.vouchersVBox.getChildren().add((Object)hbox);
            }
        } else {
            this.descriptionLabel.setVisible(true);
            this.descriptionLabel.setText("Objedn\u00e1vka nen\u00ed zaplacen\u00e1. Poukazy nejsou k dispozici.");
        }
        this.show((Window)this.orderManagementController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void hidePopup() {
        this.hide();
    }
}

