/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.utils.LayoutUtils;
import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import javafx.stage.Popup;
import javafx.stage.Window;

public class ProductsSettingsPopup
extends Popup {
    private CashierController cashierController;
    private AnchorPane popupAnchor;
    private FlowPane buttonsFlowPane;
    private List<CheckBox> checkboxesList = new ArrayList();
    private List<Category> categories;
    private List<Product> products;
    private List<MenuOption> menuOptions;

    public ProductsSettingsPopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 900;
        int popupHeight = 700;
        int minButtonWidth = 220;
        int maxButtonWidth = 300;
        this.popupAnchor = new AnchorPane();
        this.popupAnchor.setMinWidth((double)popupWidth);
        this.popupAnchor.setMaxWidth((double)popupWidth);
        this.popupAnchor.setMinHeight((double)popupHeight);
        this.popupAnchor.setMaxHeight((double)popupHeight);
        this.popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        Label titleLabel = new Label("Nastaven\u00ed produkt\u016f");
        titleLabel.setFont(cashierController.titleFont);
        titleLabel.setMaxWidth(400.0);
        titleLabel.setMaxHeight(100.0);
        titleLabel.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)titleLabel, (Double)10.0);
        AnchorPane.setRightAnchor((Node)titleLabel, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)titleLabel, (Double)10.0);
        this.buttonsFlowPane = new FlowPane();
        this.buttonsFlowPane.setOrientation(Orientation.VERTICAL);
        this.buttonsFlowPane.setPrefHeight(600.0);
        this.buttonsFlowPane.setMaxHeight(600.0);
        this.buttonsFlowPane.setPrefWidth(880.0);
        this.buttonsFlowPane.setMaxWidth(880.0);
        this.buttonsFlowPane.setHgap(20.0);
        this.buttonsFlowPane.setVgap(20.0);
        AnchorPane.setTopAnchor((Node)this.buttonsFlowPane, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)this.buttonsFlowPane, (Double)10.0);
        AnchorPane.setBottomAnchor((Node)this.buttonsFlowPane, (Double)0.0);
        this.popupAnchor.getChildren().addAll((Object[])new Node[]{titleLabel, this.buttonsFlowPane});
        this.getContent().add((Object)this.popupAnchor);
    }

    public void loadPopup(List<Category> categories, List<Product> products, List<MenuOption> menuOptions) {
        this.categories = categories;
        this.products = products;
        this.menuOptions = menuOptions;
        for (Category category : categories) {
            if (products.stream().filter(p -> p.getCategory() == category.getId() && p.isEnabled()).toList().isEmpty()) continue;
            Button button = this.createCategoryButton(category);
            button.setPrefHeight(100.0);
            this.buttonsFlowPane.getChildren().add((Object)button);
        }
        this.show((Window)this.cashierController.stage);
    }

    private Button createCategoryButton(Category category) {
        Button button = this.createButton(category.getName());
        button.setOnMouseClicked(mouseEvent -> this.loadCategory(category));
        button.setOnTouchPressed(touchEvent -> this.loadCategory(category));
        return button;
    }

    private Button createButton(String label) {
        Button button = new Button(label);
        button.setPrefWidth(225.0);
        button.setMaxWidth(225.0);
        button.setPrefHeight(50.0);
        button.setFont(this.cashierController.normalFont);
        button.setStyle("-fx-background-color: gray");
        button.setWrapText(true);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)5.0, (double)10.0, (double)5.0));
        return button;
    }

    private void loadCategory(Category category) {
        this.buttonsFlowPane.getChildren().clear();
        List<Product> enabledProducts = this.products.stream().filter(p -> p.getCategory() == category.getId() && p.isEnabled()).toList();
        VBox productsVBox = new VBox();
        productsVBox.setSpacing(10.0);
        AnchorPane.setLeftAnchor((Node)productsVBox, (Double)10.0);
        AnchorPane.setTopAnchor((Node)productsVBox, (Double)100.0);
        AnchorPane.setBottomAnchor((Node)productsVBox, (Double)0.0);
        for (Product product : enabledProducts) {
            CheckBox productHBox = this.createProductCheckBox(product);
            if (enabledProducts.size() < 10) {
                productHBox.setPrefHeight(100.0);
            }
            productsVBox.getChildren().add((Object)productHBox);
        }
        this.popupAnchor.getChildren().clear();
        this.popupAnchor.getChildren().add((Object)productsVBox);
    }

    private CheckBox createProductCheckBox(Product product) {
        CheckBox checkBox = new CheckBox();
        checkBox.setText(product.getName());
        checkBox.setFont(this.cashierController.normalFont);
        checkBox.setId(product.getId());
        checkBox.setSelected(false);
        checkBox.setDisable(!product.isEnabled());
        this.checkboxesList.add(checkBox);
        return checkBox;
    }
}

