/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service.cashier.scheduler;

import cz.polreich.spagetka.factory.scheduler.NamedSchedulerFactory;
import cz.polreich.spagetka.utils.ExceptionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SchedulerService {
    private static final Logger log = LoggerFactory.getLogger(SchedulerService.class);
    private final AtomicBoolean schedulerRunning = new AtomicBoolean(false);
    private final AtomicBoolean jobRunning = new AtomicBoolean(false);
    private ScheduledExecutorService executor;
    private final NamedSchedulerFactory schedulerFactory = new NamedSchedulerFactory();

    protected abstract String threadName();

    protected abstract boolean useFixedDelay();

    public final void start(Runnable job) {
        if (!this.schedulerRunning.compareAndSet(false, true)) {
            log.debug("{} already started", (Object)this.threadName());
            return;
        }
        this.createScheduler(job);
    }

    public final void stop() {
        log.debug("Stopping {} ...", (Object)this.threadName());
        if (this.schedulerRunning.compareAndSet(true, false) && this.executor != null && !this.executor.isShutdown()) {
            this.executor.shutdownNow();
        }
    }

    private void createScheduler(Runnable job) {
        this.executor = this.schedulerFactory.create(this.threadName(), 1);
        Runnable wrappedJob = () -> {
            if (!this.jobRunning.compareAndSet(false, true)) {
                log.info("{} skipping run \u2014 previous execution still running", (Object)this.threadName());
                return;
            }
            try {
                job.run();
            }
            catch (Exception e) {
                ExceptionHandler.logException((Exception)e);
            }
            finally {
                this.jobRunning.set(false);
            }
        };
        if (this.useFixedDelay()) {
            this.executor.scheduleWithFixedDelay(wrappedJob, 0L, 5L, TimeUnit.SECONDS);
        } else {
            this.executor.scheduleAtFixedRate(wrappedJob, 0L, 5L, TimeUnit.SECONDS);
        }
    }
}

