/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.RecipeStepDTO;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.enums.PREPARATION_TYPE;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.security.InvalidParameterException;

@Entity
@Table(name="RecipeSteps")
public class RecipeStep {
    @Id
    private String id;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Product product;
    @Column
    private int stepOrder;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    private Ingredient ingredient;
    @Column
    private double quantity;
    @Column
    @Enumerated(value=EnumType.STRING)
    private PREPARATION_TYPE preparationType;

    public RecipeStep(RecipeStepDTO dto) {
        this.id = dto.getId();
        IngredientService ingredientService = (IngredientService)ApplicationContextUtils.getApplicationContext().getBean(IngredientService.class);
        ProductService productService = (ProductService)ApplicationContextUtils.getApplicationContext().getBean(ProductService.class);
        if (!productService.existsById(dto.getProductId())) {
            throw new InvalidParameterException("Product with ID " + dto.getProductId() + " not found.");
        }
        this.product = productService.findById(dto.getProductId());
        this.stepOrder = dto.getStepOrder();
        if (!ingredientService.existsById(dto.getIngredientId())) {
            throw new InvalidParameterException("Ingredient with ID " + dto.getIngredientId() + " not found.");
        }
        this.ingredient = ingredientService.findById(dto.getIngredientId());
        this.quantity = dto.getQuantity();
        this.preparationType = dto.getPreparationType();
    }

    public RecipeStep() {
    }

    public RecipeStep(String id, Product product, int stepOrder, Ingredient ingredient, double quantity, PREPARATION_TYPE preparationType) {
        this.id = id;
        this.product = product;
        this.stepOrder = stepOrder;
        this.ingredient = ingredient;
        this.quantity = quantity;
        this.preparationType = preparationType;
    }

    public String getId() {
        return this.id;
    }

    public Product getProduct() {
        return this.product;
    }

    public int getStepOrder() {
        return this.stepOrder;
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public double getQuantity() {
        return this.quantity;
    }

    public PREPARATION_TYPE getPreparationType() {
        return this.preparationType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public void setStepOrder(int stepOrder) {
        this.stepOrder = stepOrder;
    }

    public void setIngredient(Ingredient ingredient) {
        this.ingredient = ingredient;
    }

    public void setQuantity(double quantity) {
        this.quantity = quantity;
    }

    public void setPreparationType(PREPARATION_TYPE preparationType) {
        this.preparationType = preparationType;
    }
}

