/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.Product;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.util.List;

@Entity
@Table(name="ProductVariants")
public class ProductVariant {
    @Id
    private String id;
    @Column
    private String name;
    @Column(length=1000)
    private String description;
    @Column
    private Double price;
    @Column
    private String imageFilePath;
    @Column
    private byte[] imageBytes;
    @Column
    private String remoteImagePath;
    @ManyToMany(cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    @JoinTable(name="ProductVariantsIngredients", joinColumns={@JoinColumn(name="ingredientId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    private List<CompositionItem> ingredients;
    @Column
    private boolean enabled;
    @ManyToMany(mappedBy="productVariants")
    private List<Product> products;
    @Column(columnDefinition="int default 999")
    private int itemOrder = 999;

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public Double getPrice() {
        return this.price;
    }

    public String getImageFilePath() {
        return this.imageFilePath;
    }

    public byte[] getImageBytes() {
        return this.imageBytes;
    }

    public String getRemoteImagePath() {
        return this.remoteImagePath;
    }

    public List<CompositionItem> getIngredients() {
        return this.ingredients;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public int getItemOrder() {
        return this.itemOrder;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setPrice(Double price) {
        this.price = price;
    }

    public void setImageFilePath(String imageFilePath) {
        this.imageFilePath = imageFilePath;
    }

    public void setImageBytes(byte[] imageBytes) {
        this.imageBytes = imageBytes;
    }

    public void setRemoteImagePath(String remoteImagePath) {
        this.remoteImagePath = remoteImagePath;
    }

    public void setIngredients(List<CompositionItem> ingredients) {
        this.ingredients = ingredients;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public void setItemOrder(int itemOrder) {
        this.itemOrder = itemOrder;
    }

    public ProductVariant() {
    }

    public ProductVariant(String id, String name, String description, Double price, String imageFilePath, byte[] imageBytes, String remoteImagePath, List<CompositionItem> ingredients, boolean enabled, List<Product> products, int itemOrder) {
        this.id = id;
        this.name = name;
        this.description = description;
        this.price = price;
        this.imageFilePath = imageFilePath;
        this.imageBytes = imageBytes;
        this.remoteImagePath = remoteImagePath;
        this.ingredients = ingredients;
        this.enabled = enabled;
        this.products = products;
        this.itemOrder = itemOrder;
    }
}

