/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.factory;

import cz.polreich.spagetka.DTO.ProductVariantDTO;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import jakarta.xml.bind.DatatypeConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductVariantFactory {
    private ResourceHelper resourceHelper;

    public ProductVariant create(Product product) {
        ProductVariant variant = new ProductVariant();
        variant.setId("PROD_" + product.getId());
        variant.setName(product.getName());
        variant.setDescription(product.getDescription());
        variant.setPrice(product.getActualPrice());
        variant.setImageFilePath(product.getImageFilePath());
        variant.setImageBytes(product.getImageBytes());
        variant.setRemoteImagePath(product.getRemoteImagePath());
        variant.setIngredients(product.getIngredients());
        variant.setEnabled(product.isEnabled());
        variant.setItemOrder(product.getItemOrder());
        return variant;
    }

    public ProductVariant create(ProductVariantDTO dto, boolean fromExternal) {
        ProductVariant variant = new ProductVariant();
        variant.setId(dto.getId());
        variant.setName(dto.getName());
        variant.setDescription(dto.getDescription());
        variant.setPrice(dto.getPrice());
        if (fromExternal) {
            variant.setImageFilePath(this.resourceHelper.convertImagePathFromExternal(dto.getImageFilePath()));
        } else {
            variant.setImageFilePath(dto.getImageFilePath());
        }
        variant.setRemoteImagePath(dto.getImageFilePath());
        if (ValidationUtils.isStringNotNullOrEmpty((String)dto.getImageBytesBase64())) {
            variant.setImageBytes(DatatypeConverter.parseBase64Binary((String)dto.getImageBytesBase64()));
        } else {
            variant.setImageBytes(new byte[0]);
        }
        variant.setIngredients(dto.getComposition().stream().map(CompositionItem::new).toList());
        variant.setEnabled(Boolean.TRUE.equals(dto.getAllowedAtKiosk()));
        variant.setItemOrder(dto.getOrder() != null ? dto.getOrder() : 999);
        return variant;
    }

    @Autowired
    public void setResourceHelper(ResourceHelper resourceHelper) {
        this.resourceHelper = resourceHelper;
    }
}

