/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.factory;

import cz.polreich.spagetka.DTO.ProductDTO;
import cz.polreich.spagetka.factory.ProductFreeVariantCategoryFactory;
import cz.polreich.spagetka.factory.ProductVariantFactory;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariantCategory;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import jakarta.xml.bind.DatatypeConverter;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductFactory {
    private ResourceHelper resourceHelper;
    private ProductFreeVariantCategoryFactory productFreeVariantCategoryFactory;
    private ProductVariantFactory productVariantFactory;

    public Product create(ProductVariant variant, Product originalProduct, boolean fromExternal) {
        Product product = new Product();
        product.setId("VAR_" + variant.getId());
        product.setName(variant.getName());
        product.setCategory(originalProduct.getCategory());
        product.setDescription(variant.getDescription());
        product.setIngredientsString(originalProduct.getIngredientsString());
        product.setIngredients(variant.getIngredients());
        product.setTags(originalProduct.getTags());
        product.setOriginalPrice(originalProduct.getOriginalPrice());
        product.setActualPrice(variant.getPrice());
        product.setVatPercent(originalProduct.getVatPercent());
        if (fromExternal) {
            int index = variant.getImageFilePath().lastIndexOf("/");
            String fileName = variant.getImageFilePath().substring(index + 1);
            product.setImageFilePath("/resources/images/" + fileName);
        } else {
            product.setImageFilePath(variant.getImageFilePath());
        }
        product.setImageBytes(variant.getImageBytes());
        product.setRemoteImagePath(variant.getRemoteImagePath());
        product.setEnabled(variant.isEnabled());
        product.setItemOrder(variant.getItemOrder());
        return product;
    }

    public Product create(ProductDTO dto, boolean fromExternal) {
        Product product = new Product();
        product.setId(dto.getId());
        product.setName(dto.getName());
        product.setShortName(dto.getShortName());
        product.setCookMonitorName(dto.getCookMonitorName());
        product.setReceiptName(dto.getReceiptName());
        product.setStickerName(dto.getStickerName());
        product.setCategory(dto.getCategory());
        product.setDescription(dto.getDescription());
        product.setAmountValue(dto.getAmountValue());
        product.setAmountUnit(dto.getAmountUnit());
        product.setIngredientsString(dto.getIngredients());
        product.setIngredients(dto.getComposition().stream().map(CompositionItem::new).collect(Collectors.toList()));
        product.setProductVariants(new ArrayList<ProductVariant>(dto.getVariants().stream().map(v -> this.productVariantFactory.create(v, fromExternal)).toList()));
        product.setProductFreeVariantCategories(new ArrayList<ProductFreeVariantCategory>(dto.getCategoriesVariants().stream().map(c -> this.productFreeVariantCategoryFactory.create(c, fromExternal)).toList()));
        product.setAlergens(new ArrayList(dto.getAlergens()));
        product.setTags(new ArrayList<String>(dto.getTags().stream().map(String::valueOf).toList()));
        product.setOriginalPrice(dto.getOriginalPrice());
        product.setActualPrice(dto.getActualPrice());
        product.setVatPercent(dto.getVatPercent());
        if (fromExternal) {
            product.setImageFilePath(this.resourceHelper.convertImagePathFromExternal(dto.getImageFilePath()));
        } else {
            product.setImageFilePath(dto.getImageFilePath());
        }
        if (ValidationUtils.isStringNotNullOrEmpty((String)dto.getImageBytesBase64())) {
            product.setImageBytes(DatatypeConverter.parseBase64Binary((String)dto.getImageBytesBase64()));
        } else {
            product.setImageBytes(new byte[0]);
        }
        product.setRemoteImagePath(dto.getImageFilePath());
        product.setEnabled(dto.isAllowedAtKiosk());
        product.setItemOrder(dto.getOrder() != null ? dto.getOrder() : 999);
        product.setPackagingItem(dto.getIsPackaging());
        return product;
    }

    @Autowired
    public void setResourceHelper(ResourceHelper resourceHelper) {
        this.resourceHelper = resourceHelper;
    }

    @Autowired
    public void setProductFreeVariantCategoryFactory(ProductFreeVariantCategoryFactory productFreeVariantCategoryFactory) {
        this.productFreeVariantCategoryFactory = productFreeVariantCategoryFactory;
    }

    @Autowired
    public void setProductVariantFactory(ProductVariantFactory productVariantFactory) {
        this.productVariantFactory = productVariantFactory;
    }
}

