/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.AttendanceLogItem;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.enums.ATTENDANCE_ACTION;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.time.LocalDateTime;
import java.util.LinkedList;
import java.util.List;
import javafx.event.Event;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class AttendancePopup
extends Popup {
    private Label infoLabel;
    private CashierController cashierController;
    private TextField passwordTextField = new TextField("");
    private String keyboardPresses = "";
    private FlowPane keyboardFlowPane;
    private User userByCard = null;
    private ImageFactory imageFactory = new ImageFactory(new ResourceHelper());

    public AttendancePopup(CashierController cashierController) {
        this.cashierController = cashierController;
        int popupWidth = 650;
        int popupHeight = 700;
        AnchorPane popupAnchor = new AnchorPane();
        this.infoLabel = new Label("");
        this.infoLabel.setMaxWidth(450.0);
        this.infoLabel.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.infoLabel, (Double)60.0);
        AnchorPane.setLeftAnchor((Node)this.infoLabel, (Double)150.0);
        AnchorPane.setRightAnchor((Node)this.infoLabel, (Double)150.0);
        this.infoLabel.setStyle("-fx-font-size: 20px;-fx-text-fill : #001d3f;");
        this.passwordTextField.setPromptText(cashierController.strings.getString("password"));
        this.passwordTextField.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.passwordTextField, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)this.passwordTextField, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.passwordTextField, (Double)100.0);
        this.passwordTextField.setPrefHeight(40.0);
        this.passwordTextField.setFocusTraversable(false);
        this.passwordTextField.getStyleClass().add((Object)"login_text_field");
        this.passwordTextField.getProperties().put((Object)"vkType", (Object)"none");
        this.keyboardFlowPane = new FlowPane();
        this.keyboardFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setTopAnchor((Node)this.keyboardFlowPane, (Double)80.0);
        AnchorPane.setLeftAnchor((Node)this.keyboardFlowPane, (Double)100.0);
        AnchorPane.setRightAnchor((Node)this.keyboardFlowPane, (Double)100.0);
        GridPane keyboardGridPane = this.createNumberKeyboard();
        this.keyboardFlowPane.getChildren().add((Object)keyboardGridPane);
        Button inButton = new Button(cashierController.strings.getString("arrival"));
        inButton.setMinSize(160.0, 40.0);
        AnchorPane.setBottomAnchor((Node)inButton, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)inButton, (Double)100.0);
        inButton.getStyleClass().add((Object)"login_button");
        Button outButton = new Button(cashierController.strings.getString("exit"));
        outButton.setMinSize(160.0, 40.0);
        AnchorPane.setBottomAnchor((Node)outButton, (Double)100.0);
        AnchorPane.setRightAnchor((Node)outButton, (Double)100.0);
        outButton.getStyleClass().add((Object)"login_button");
        Button cancelButton = new Button(cashierController.strings.getString("cancel"));
        cancelButton.setMinSize(160.0, 40.0);
        AnchorPane.setBottomAnchor((Node)cancelButton, (Double)15.0);
        AnchorPane.setRightAnchor((Node)cancelButton, (Double)100.0);
        AnchorPane.setLeftAnchor((Node)cancelButton, (Double)100.0);
        cancelButton.getStyleClass().add((Object)"login_button");
        inButton.setOnMouseClicked(mouseEvent -> this.handleAttendanceAction(this.passwordTextField.getText(), ATTENDANCE_ACTION.IN));
        inButton.setOnTouchPressed(touchEvent -> this.handleAttendanceAction(this.passwordTextField.getText(), ATTENDANCE_ACTION.IN));
        outButton.setOnMouseClicked(mouseEvent -> this.handleAttendanceAction(this.passwordTextField.getText(), ATTENDANCE_ACTION.OUT));
        outButton.setOnTouchPressed(touchEvent -> this.handleAttendanceAction(this.passwordTextField.getText(), ATTENDANCE_ACTION.OUT));
        cancelButton.setOnMouseClicked(mouseEvent -> {
            this.invokeStateInit();
            this.hide();
        });
        cancelButton.setOnTouchPressed(touchEvent -> {
            this.invokeStateInit();
            this.hide();
        });
        popupAnchor.setMinWidth((double)popupWidth);
        popupAnchor.setMaxWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        popupAnchor.setMaxHeight((double)popupHeight);
        popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{this.passwordTextField, this.infoLabel, this.keyboardFlowPane, inButton, outButton, cancelButton});
        this.getContent().add((Object)popupAnchor);
        popupAnchor.setOnKeyPressed(event -> {
            KeyCode code = event.getCode();
            if (code.isDigitKey()) {
                this.keyboardPresses = this.keyboardPresses + event.getText();
                System.out.println("keyboardPresses: " + this.keyboardPresses);
            }
            if (code == KeyCode.ENTER && !this.keyboardPresses.isEmpty()) {
                System.out.println("Trying login with: " + this.keyboardPresses);
                System.out.println("tapping card");
                try {
                    User user = cashierController.userService.findByRfid(this.keyboardPresses);
                    if (user != null) {
                        this.userByCard = user;
                        this.invokeStateChipExists();
                    } else {
                        this.infoLabel.setText(cashierController.strings.getString("noEmployee"));
                    }
                }
                catch (Exception e) {
                    ExceptionHandler.logException((Exception)e);
                    this.infoLabel.setText(cashierController.strings.getString("errorEmployeeDataReading"));
                }
                this.keyboardPresses = "";
            }
        });
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
    }

    public void handleAttendanceAction(String password, ATTENDANCE_ACTION action) {
        block6: {
            if (this.userByCard != null) {
                AttendanceLogItem newEvent = new AttendanceLogItem();
                newEvent.setAttendanceAction(action);
                newEvent.setTimestamp(LocalDateTime.now());
                newEvent.setUserId(this.userByCard.getId());
                this.cashierController.attendanceLogItemsService.save(newEvent);
                this.invokeStateInit();
                this.hide();
                return;
            }
            if (!password.isEmpty()) {
                try {
                    User user = this.cashierController.userService.findByPassword(password);
                    if (user == null) {
                        this.infoLabel.setText(this.cashierController.strings.getString("noEmployee"));
                        break block6;
                    }
                    AttendanceLogItem newEvent = new AttendanceLogItem();
                    newEvent.setAttendanceAction(action);
                    newEvent.setTimestamp(LocalDateTime.now());
                    newEvent.setUserId(user.getId());
                    this.cashierController.attendanceLogItemsService.save(newEvent);
                    this.passwordTextField.setText("");
                    this.hide();
                }
                catch (Exception e) {
                    ExceptionHandler.logException((Exception)e);
                    this.infoLabel.setText(this.cashierController.strings.getString("errorEmployeeDataReading"));
                }
            } else {
                this.infoLabel.setText(this.cashierController.strings.getString("emptyPassword"));
            }
        }
        ((Node)this.getContent().get(0)).requestFocus();
    }

    private GridPane createNumberKeyboard() {
        int i;
        LinkedList<Integer> buttonsOrder = new LinkedList<Integer>(List.of(new Integer[]{7, 8, 9, 4, 5, 6, 1, 2, 3}));
        GridPane gridPane = new GridPane();
        for (i = 0; i <= 2; ++i) {
            ColumnConstraints column = new ColumnConstraints();
            column.setHgrow(Priority.SOMETIMES);
            column.setMinWidth(10.0);
            column.setPrefWidth(100.0);
            gridPane.getColumnConstraints().add((Object)column);
        }
        for (i = 0; i <= 3; ++i) {
            RowConstraints row = new RowConstraints();
            row.setVgrow(Priority.SOMETIMES);
            row.setMinHeight(10.0);
            row.setPrefHeight(100.0);
            gridPane.getRowConstraints().add((Object)row);
        }
        Integer i2 = 1;
        while (i2 <= 9) {
            Object button = this.createKeyboardButton(String.valueOf(i2));
            int buttonIndex = buttonsOrder.indexOf(i2);
            int rowNumber = (int)Math.floor((double)buttonIndex / 3.0);
            int columnNumber = buttonIndex % 3;
            gridPane.add((Node)button, columnNumber, rowNumber);
            button = i2;
            i2 = i2 + 1;
        }
        GrayButton buttonZero = this.createKeyboardButton(String.valueOf(0));
        gridPane.add((Node)buttonZero, 1, 3);
        GrayButton buttonBackSpace = this.createKeyboardButton("x");
        ImageView imageView = new ImageView((Image)this.imageFactory.create("/resources/images/backspace_64.png").orElse(null));
        buttonBackSpace.setGraphic((Node)imageView);
        gridPane.add((Node)buttonBackSpace, 2, 3);
        return gridPane;
    }

    private GrayButton createKeyboardButton(String label) {
        GrayButton button = new GrayButton();
        button.setId("keyboard_" + label);
        button.setFont(this.cashierController.subtitleFont);
        button.setAlignment(Pos.CENTER);
        button.setContentDisplay(ContentDisplay.CENTER);
        button.setFocusTraversable(false);
        button.setOnMouseClicked(arg_0 -> this.number_keyboard_clicked(arg_0));
        button.setOnTouchPressed(arg_0 -> this.number_keyboard_clicked(arg_0));
        if (!label.equals("x")) {
            button.setText(label);
        }
        button.setMinWidth(70.0);
        button.setMinHeight(70.0);
        button.setMaxWidth(70.0);
        button.setMaxHeight(70.0);
        button.setPadding(LayoutUtils.getInsets((double)10.0, (double)30.0, (double)10.0, (double)30.0));
        GridPane.setMargin((Node)button, (Insets)LayoutUtils.getInsets((double)0.0, (double)0.0, (double)0.0, (double)33.0));
        return button;
    }

    private void number_keyboard_clicked(Event e) {
        String buttonId = ((GrayButton)e.getSource()).getId();
        String number = buttonId.split("_")[1];
        if (number.equals("x")) {
            if (!this.passwordTextField.getText().isEmpty()) {
                int toDelete = 1;
                this.passwordTextField.setText(this.passwordTextField.getText().substring(0, this.passwordTextField.getText().length() - toDelete));
            }
        } else {
            this.passwordTextField.setText(this.passwordTextField.getText() + number);
        }
    }

    private void invokeStateInit() {
        this.passwordTextField.setText("");
        this.passwordTextField.setVisible(true);
        this.keyboardFlowPane.setVisible(true);
        this.infoLabel.setText("");
        this.infoLabel.setStyle("-fx-font-size: 20px;-fx-text-fill : #001d3f;");
        this.userByCard = null;
    }

    private void invokeStateChipExists() {
        this.passwordTextField.setVisible(false);
        this.keyboardFlowPane.setVisible(false);
        StringBuilder userInfo = new StringBuilder().append(this.userByCard.getFirstName()).append(" ").append(this.userByCard.getLastName());
        this.infoLabel.setText(userInfo.toString());
        this.infoLabel.setStyle("-fx-font-size: 40px;-fx-text-fill : #001d3f;");
    }

    @Autowired
    public void setImageFactory(ImageFactory imageFactory) {
        this.imageFactory = imageFactory;
    }
}

