/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class OrderItemDTO {
    private String id;
    private String mainProductId;
    private String variantId;
    private String menuId;
    private List<String> additionalProductsIds = new ArrayList();
    private List<OrderItemDTO> subItems = new ArrayList();
    private List<String> freeVariantsIds = new ArrayList();
    private String affix;
    private String suffix;
    private Double discount;
    private Double subTotalPrice;
    private Double finalPrice;
    private int quantity;
    private String displayName;

    public OrderItemDTO(OrderItem item) {
        this.id = item.getId();
        this.mainProductId = item.getMainProduct().getId();
        this.variantId = item.getMainProductVariant() != null ? item.getMainProductVariant().getId() : null;
        this.menuId = item.getMenuOption() != null ? item.getMenuOption().getId() : "";
        this.additionalProductsIds = item.getAdditionalProducts().stream().map(Product::getId).toList();
        this.subItems = item.getSubItems().stream().map(OrderItemDTO::new).collect(Collectors.toList());
        this.freeVariantsIds = item.getFreeVariants().stream().map(ProductFreeVariant::getId).toList();
        this.affix = item.getAffix();
        this.suffix = item.getSuffix();
        this.discount = item.getDiscount();
        this.subTotalPrice = item.getSubTotalPrice();
        this.finalPrice = item.getFinalPrice();
        this.quantity = item.getQuantity();
        this.displayName = item.getDisplayName();
    }

    public String getId() {
        return this.id;
    }

    public String getMainProductId() {
        return this.mainProductId;
    }

    public String getVariantId() {
        return this.variantId;
    }

    public String getMenuId() {
        return this.menuId;
    }

    public List<String> getAdditionalProductsIds() {
        return this.additionalProductsIds;
    }

    public List<OrderItemDTO> getSubItems() {
        return this.subItems;
    }

    public List<String> getFreeVariantsIds() {
        return this.freeVariantsIds;
    }

    public String getAffix() {
        return this.affix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Double getDiscount() {
        return this.discount;
    }

    public Double getSubTotalPrice() {
        return this.subTotalPrice;
    }

    public Double getFinalPrice() {
        return this.finalPrice;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMainProductId(String mainProductId) {
        this.mainProductId = mainProductId;
    }

    public void setVariantId(String variantId) {
        this.variantId = variantId;
    }

    public void setMenuId(String menuId) {
        this.menuId = menuId;
    }

    public void setAdditionalProductsIds(List<String> additionalProductsIds) {
        this.additionalProductsIds = additionalProductsIds;
    }

    public void setSubItems(List<OrderItemDTO> subItems) {
        this.subItems = subItems;
    }

    public void setFreeVariantsIds(List<String> freeVariantsIds) {
        this.freeVariantsIds = freeVariantsIds;
    }

    public void setAffix(String affix) {
        this.affix = affix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setDiscount(Double discount) {
        this.discount = discount;
    }

    public void setSubTotalPrice(Double subTotalPrice) {
        this.subTotalPrice = subTotalPrice;
    }

    public void setFinalPrice(Double finalPrice) {
        this.finalPrice = finalPrice;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public OrderItemDTO() {
    }

    public OrderItemDTO(String id, String mainProductId, String variantId, String menuId, List<String> additionalProductsIds, List<OrderItemDTO> subItems, List<String> freeVariantsIds, String affix, String suffix, Double discount, Double subTotalPrice, Double finalPrice, int quantity, String displayName) {
        this.id = id;
        this.mainProductId = mainProductId;
        this.variantId = variantId;
        this.menuId = menuId;
        this.additionalProductsIds = additionalProductsIds;
        this.subItems = subItems;
        this.freeVariantsIds = freeVariantsIds;
        this.affix = affix;
        this.suffix = suffix;
        this.discount = discount;
        this.subTotalPrice = subTotalPrice;
        this.finalPrice = finalPrice;
        this.quantity = quantity;
        this.displayName = displayName;
    }
}

