/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.DTO.ProductsGroupDTO;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.utils.ApplicationContextUtils;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.Table;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;

@Entity
@Table(name="AdditionalProductsGroups")
public class ProductsGroup {
    @Id
    private String id;
    @Column
    private String title;
    @ManyToMany(cascade={CascadeType.PERSIST}, fetch=FetchType.EAGER)
    @JoinTable(name="ProductsGroupsProducts", joinColumns={@JoinColumn(name="groupId", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="productId", referencedColumnName="id")})
    private List<Product> products = new ArrayList();

    public ProductsGroup(ProductsGroupDTO dto) {
        this.id = dto.getId();
        this.title = dto.getTitle();
        ProductService productService = (ProductService)ApplicationContextUtils.getApplicationContext().getBean(ProductService.class);
        for (String productId : dto.getProductIds()) {
            if (productService.existsById(productId)) {
                this.products.add(productService.findById(productId));
                continue;
            }
            throw new InvalidParameterException("Product with ID " + productId + " not found.");
        }
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public List<Product> getProducts() {
        return this.products;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setProducts(List<Product> products) {
        this.products = products;
    }

    public ProductsGroup() {
    }

    public ProductsGroup(String id, String title, List<Product> products) {
        this.id = id;
        this.title = title;
        this.products = products;
    }
}

