/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.factory;

import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.net.URL;
import java.util.Optional;
import javafx.scene.media.Media;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MediaFactory {
    private static final Logger log = LoggerFactory.getLogger(MediaFactory.class);
    private final ResourceHelper resourceHelper;

    public MediaFactory(ResourceHelper resourceHelper) {
        this.resourceHelper = resourceHelper;
    }

    public Optional<Media> createFromResources(String path) {
        if (path == null) {
            log.error("Media path is null. Returns Optional.empty()");
            return Optional.empty();
        }
        URL url = this.resourceHelper.getResourceUrl(path);
        if (url == null) {
            return Optional.empty();
        }
        return this.create(url.toExternalForm());
    }

    public Optional<Media> create(String path) {
        if (path == null) {
            log.error("Media path is null. Returns Optional.empty()");
            return Optional.empty();
        }
        try {
            return Optional.of(this.createMedia(path));
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
            return Optional.empty();
        }
    }

    protected Media createMedia(String path) {
        return new Media(path);
    }
}

