/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.cashierController;

import cz.polreich.spagetka.DTO.CategoryDTO;
import cz.polreich.spagetka.DTO.ProductFreeVariantCategoryDTO;
import cz.polreich.spagetka.DTO.ProductFreeVariantDTO;
import cz.polreich.spagetka.DTO.ProductVariantDTO;
import cz.polreich.spagetka.PartnerServerRestClient;
import cz.polreich.spagetka.controllers.CashierController;
import cz.polreich.spagetka.controllers.popup.cashierController.UpdatePopup;
import cz.polreich.spagetka.factory.UserFactory;
import cz.polreich.spagetka.models.Allergen;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.KioskInfo;
import cz.polreich.spagetka.models.MenuOption;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductFreeVariantCategory;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.ProductsGroup;
import cz.polreich.spagetka.models.User;
import cz.polreich.spagetka.models.external.UserExternal;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.ProductVariantService;
import cz.polreich.spagetka.utils.ResourceHelper;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Popup;
import javafx.stage.Window;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdatePopup
extends Popup {
    private CashierController cashierController;
    private Label descriptionLabel;
    private List<Product> filteredProducts = new ArrayList();
    private CategoryService categoryService;
    private ProductService productService;
    private ResourceHelper resourceHelper;
    private ProductVariantService productVariantService;
    private final PartnerServerRestClient partnerServerRestClient;
    private UserFactory userFactory;

    public UpdatePopup(CashierController cashierController) {
        this.cashierController = cashierController;
        this.partnerServerRestClient = cashierController.activeConfig.getPartnerServerRestClient();
        this.resourceHelper = new ResourceHelper();
        this.userFactory = new UserFactory();
        int popupWidth = 650;
        int popupHeight = 700;
        AnchorPane popupAnchor = new AnchorPane();
        Label labelTitle = new Label();
        labelTitle.setText("Aktualizace dat");
        AnchorPane.setTopAnchor((Node)labelTitle, (Double)15.0);
        AnchorPane.setLeftAnchor((Node)labelTitle, (Double)10.0);
        AnchorPane.setRightAnchor((Node)labelTitle, (Double)10.0);
        labelTitle.setAlignment(Pos.CENTER);
        labelTitle.setPadding(new Insets(20.0));
        labelTitle.setStyle("-fx-font-size: 40px;");
        this.descriptionLabel = new Label("");
        this.descriptionLabel.setMaxWidth(300.0);
        this.descriptionLabel.setAlignment(Pos.CENTER);
        this.descriptionLabel.setFont(cashierController.mainSceneButtonsFont);
        AnchorPane.setTopAnchor((Node)this.descriptionLabel, (Double)170.0);
        AnchorPane.setLeftAnchor((Node)this.descriptionLabel, (Double)10.0);
        AnchorPane.setRightAnchor((Node)this.descriptionLabel, (Double)10.0);
        popupAnchor.setMinWidth((double)popupWidth);
        popupAnchor.setMaxWidth((double)popupWidth);
        popupAnchor.setMinHeight((double)popupHeight);
        popupAnchor.setMaxHeight((double)popupHeight);
        popupAnchor.getStyleClass().add((Object)"login_anchor_pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{labelTitle, this.descriptionLabel});
        this.getContent().add((Object)popupAnchor);
    }

    public void loadPopup() {
        this.show((Window)this.cashierController.stage);
        ((Node)this.getContent().get(0)).requestFocus();
        1 downloadTask = new /* Unavailable Anonymous Inner Class!! */;
        new Thread((Runnable)downloadTask).start();
    }

    private void downloadDataFromPartnerServer() {
        Platform.runLater(() -> this.descriptionLabel.setText("Pripravuji databazi..."));
        this.prepareDB();
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji kategorie..."));
        List categoriesDTO = this.partnerServerRestClient.getCategories();
        List<Category> categories = categoriesDTO.stream().map(c -> this.cashierController.categoryService.createFromDTO(c, true)).toList();
        this.cashierController.categoryService.saveAll(categories);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji ingredience..."));
        List<Ingredient> ingredients = this.partnerServerRestClient.getIngredients().stream().map(Ingredient::new).toList();
        this.cashierController.ingredientService.saveAll(ingredients);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji produkty..."));
        List productsDTO = this.partnerServerRestClient.getProducts();
        List<Product> products = productsDTO.stream().map(p -> this.cashierController.productService.createProductFromExternalDTO(p)).toList();
        this.filteredProducts = new ArrayList<Product>(products);
        for (Product product : products) {
            this.calculateProductAvailability(product);
            if (product.getCategory() == this.cashierController.activeConfig.getSpaghettiCategoryId() || product.getCategory() == this.cashierController.activeConfig.getFusilliCategoryId()) {
                this.processPastaIngredients(product);
            }
            if (product.getProductVariants() != null && !product.getProductVariants().isEmpty() && product.getCategory() == this.cashierController.activeConfig.getCoffeeCategoryId()) {
                this.processCoffeeVariants(product);
            }
            if (product.getProductFreeVariantCategories() == null || product.getProductFreeVariantCategories().isEmpty() || product.getCategory() != this.cashierController.activeConfig.getIceCreamCategoryId()) continue;
            this.processIceCreamVariants(product);
        }
        this.cashierController.productService.saveAll(this.filteredProducts);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji prod. skupiny..."));
        List<ProductsGroup> productsGroups = this.partnerServerRestClient.getProductsGroups().stream().map(ProductsGroup::new).toList();
        this.cashierController.productsGroupService.saveAll(productsGroups);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji menu..."));
        List menuOptionsDTO = this.partnerServerRestClient.getMenuOptions();
        List<MenuOption> menuOptions = menuOptionsDTO.stream().map(m -> new MenuOption(m, true)).toList();
        this.cashierController.menuOptionService.saveAll(menuOptions);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji informace o kiosku..."));
        KioskInfo kioskInfo = new KioskInfo(this.partnerServerRestClient.getInfo());
        this.cashierController.activeConfig.setKioskInfo(kioskInfo);
        this.cashierController.kioskInfoService.save(kioskInfo);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji uzivatele..."));
        List usersExternal = this.partnerServerRestClient.getUsers();
        List<User> kioskUsers = usersExternal.stream().filter(UserExternal::isAccessKiosk).map(x -> this.userFactory.create(x)).toList();
        this.cashierController.userService.deactivateUsersNotInList(kioskUsers);
        this.cashierController.userService.saveAll(kioskUsers);
        Platform.runLater(() -> this.descriptionLabel.setText("Aktualizuji alergeny..."));
        List<Allergen> allergens = this.partnerServerRestClient.getAllergens().stream().map(Allergen::new).toList();
        this.cashierController.allergenService.saveAll(allergens);
        Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky kategorii..."));
        for (CategoryDTO dto : categoriesDTO) {
            System.out.println("Downloading Category image: " + dto.getImageFilePath());
            this.partnerServerRestClient.downloadResource(dto.getImageFilePath());
        }
        Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky produktu..."));
        for (CategoryDTO dto : productsDTO) {
            System.out.println("Downloading Product image: " + dto.getImageFilePath());
            this.partnerServerRestClient.downloadResource(dto.getImageFilePath());
            Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky variant..."));
            for (ProductVariantDTO variantDTO : dto.getVariants()) {
                System.out.println("Downloading Variant image: " + variantDTO.getImageFilePath());
                this.partnerServerRestClient.downloadResource(variantDTO.getImageFilePath());
            }
            Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky freeVariant..."));
            for (ProductFreeVariantCategoryDTO variantCategory : dto.getCategoriesVariants()) {
                for (ProductFreeVariantDTO variantDTO : variantCategory.getFreeVariants()) {
                    System.out.println("Downloading FreeVariant image: " + variantDTO.getImageFilePath());
                    this.partnerServerRestClient.downloadResource(variantDTO.getImageFilePath());
                }
            }
        }
        Platform.runLater(() -> this.descriptionLabel.setText("Stahuji obrazky menu..."));
        for (CategoryDTO dto : menuOptionsDTO) {
            System.out.println("Downloading MenuOption image: " + dto.getImageFilePath());
            this.partnerServerRestClient.downloadResource(dto.getImageFilePath());
        }
        Platform.runLater(() -> this.descriptionLabel.setText("Synchronizuji obrazky..."));
        this.syncImagesToOrder();
    }

    protected void syncImagesToOrder() {
        System.out.println("Syncing images to Order1");
        this.resourceHelper.syncImagesByNameOnly("/home/user/spagetka/resources/images", "/home/user/spagetka/resources/images", "kioskOrder1.local");
        System.out.println("Syncing images to Order2");
        this.resourceHelper.syncImagesByNameOnly("/home/user/spagetka/resources/images", "/home/user/spagetka/resources/images", "kioskOrder2.local");
    }

    private void prepareDB() {
        this.cashierController.productService.removeAllCompositionItemsFromProducts();
        this.cashierController.productVariantService.removeAllCompositionItemsFromProductVariants();
        this.cashierController.compositionItemService.deleteAll();
        this.createPastaIngredients();
        this.cashierController.menuOptionService.disableAllMenuOptions();
    }

    private void processCoffeeVariants(Product product) {
        List variants = product.getProductVariants();
        for (ProductVariant variant : variants) {
            ProductVariant variantFromProduct = this.cashierController.productVariantService.createFromProduct(product);
            List existingProductList = this.filteredProducts.stream().filter(p -> p.getName().equals(variant.getName())).collect(Collectors.toList());
            if (existingProductList.isEmpty()) {
                Product productFromVariant = this.cashierController.productService.createProductFromExternalProductVariant(variant, product);
                productFromVariant.addVariant(variantFromProduct);
                this.calculateProductAvailability(productFromVariant);
                this.filteredProducts.add(productFromVariant);
                continue;
            }
            Product existingProduct = (Product)existingProductList.get(0);
            Product newProduct = new Product(existingProduct);
            newProduct.addVariant(variantFromProduct);
            this.filteredProducts.remove(existingProduct);
            this.filteredProducts.add(newProduct);
        }
        this.filteredProducts.remove(product);
        product.setEnabled(false);
        for (ProductVariant vari : product.getProductVariants()) {
            vari.setEnabled(false);
        }
        this.filteredProducts.add(product);
    }

    private void processIceCreamVariants(Product product) {
        for (ProductFreeVariantCategory variantCategory : product.getProductFreeVariantCategories()) {
            if (!ValidationUtils.isListNotNullOrEmpty((List)variantCategory.getFreeVariants())) continue;
            for (ProductFreeVariant variant : variantCategory.getFreeVariants()) {
                if (variant.getPrice() != null) continue;
                variant.setPrice(this.cashierController.activeConfig.getFreeVariantPrice());
            }
            ProductFreeVariant emptyVariant = new ProductFreeVariant();
            emptyVariant.setId("0" + variantCategory.getId());
            emptyVariant.setName("\u017d\u00e1dn\u00e9");
            emptyVariant.setImageFilePath("/resources/images/red_cross.png");
            emptyVariant.setPrice(Double.valueOf(0.0));
            emptyVariant.setEnabled(true);
            emptyVariant.setImageBytes(new byte[0]);
            ArrayList<ProductFreeVariant> newVariantList = new ArrayList<ProductFreeVariant>(variantCategory.getFreeVariants());
            newVariantList.add(emptyVariant);
            variantCategory.setFreeVariants(newVariantList);
        }
    }

    private void createPastaIngredients() {
        String spaghettiId = this.cashierController.activeConfig.getSpaghettiIngredientId();
        String fusilliId = this.cashierController.activeConfig.getFusilliIngredientId();
        if (!this.cashierController.ingredientService.existsById(spaghettiId)) {
            Ingredient spaghettiIngredient = new Ingredient();
            spaghettiIngredient.setId(spaghettiId);
            spaghettiIngredient.setName("\u0160pagety");
            spaghettiIngredient.setUnit("pc");
            spaghettiIngredient.setCookSee(Boolean.valueOf(true));
            spaghettiIngredient.setAlternativeUnit("pc");
            spaghettiIngredient.setAlternativeUnitRatio(Double.valueOf(1.0));
            spaghettiIngredient.setCriticalComponent(Boolean.valueOf(true));
            this.cashierController.ingredientService.save(spaghettiIngredient);
        }
        if (!this.cashierController.ingredientService.existsById(fusilliId)) {
            Ingredient fusilliIngredient = new Ingredient();
            fusilliIngredient.setId(fusilliId);
            fusilliIngredient.setName("Fusilli");
            fusilliIngredient.setUnit("pc");
            fusilliIngredient.setCookSee(Boolean.valueOf(true));
            fusilliIngredient.setAlternativeUnit("pc");
            fusilliIngredient.setAlternativeUnitRatio(Double.valueOf(1.0));
            fusilliIngredient.setCriticalComponent(Boolean.valueOf(true));
            this.cashierController.ingredientService.save(fusilliIngredient);
        }
    }

    private void processPastaIngredients(Product product) {
        CompositionItem compositionItem = new CompositionItem();
        if (product.getCategory() == this.cashierController.activeConfig.getSpaghettiCategoryId()) {
            compositionItem.setIngredient(this.cashierController.ingredientService.findById(this.cashierController.activeConfig.getSpaghettiIngredientId()));
            compositionItem.setQuantity(this.cashierController.activeConfig.getSpaghettiPortionMultiplier());
        } else if (product.getCategory() == this.cashierController.activeConfig.getFusilliCategoryId()) {
            compositionItem.setIngredient(this.cashierController.ingredientService.findById(this.cashierController.activeConfig.getFusilliIngredientId()));
            compositionItem.setQuantity(this.cashierController.activeConfig.getFusilliPortionMultiplier());
        }
        product.getIngredients().add(compositionItem);
    }

    private void calculateProductAvailability(Product product) {
        boolean available = true;
        for (CompositionItem compositionItem : product.getIngredients()) {
            if (!compositionItem.getIngredient().getCriticalComponent().booleanValue()) continue;
        }
        product.setAvailable(available);
    }

    public void hidePopup() {
        this.descriptionLabel.setText("");
        this.hide();
    }

    @Autowired
    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    @Autowired
    public void setProductService(ProductService productService) {
        this.productService = productService;
    }

    @Autowired
    public void setResourceHelper(ResourceHelper resourceHelper) {
        this.resourceHelper = resourceHelper;
    }

    @Autowired
    public void setProductVariantService(ProductVariantService productVariantService) {
        this.productVariantService = productVariantService;
    }

    @Autowired
    public void setUserFactory(UserFactory userFactory) {
        this.userFactory = userFactory;
    }
}

