/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.models;

import cz.polreich.spagetka.models.enums.KIOSK_ROLE;
import cz.polreich.spagetka.models.external.UserExternal;
import cz.polreich.spagetka.utils.UserUtils;
import jakarta.persistence.CollectionTable;
import jakarta.persistence.Column;
import jakarta.persistence.ElementCollection;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.Table;
import java.util.List;
import java.util.Objects;

@Entity
@Table(name="Users")
public class User {
    @Id
    private int id;
    @Column
    private String firstName;
    @Column
    private String lastName;
    @Column
    private String username;
    @Column
    private String password;
    @Column
    private String rfid;
    @ElementCollection(targetClass=KIOSK_ROLE.class, fetch=FetchType.EAGER)
    @CollectionTable(name="users_kiosk_roles", joinColumns={@JoinColumn(name="user_id")})
    @Enumerated(value=EnumType.STRING)
    @Column(name="role_name")
    private List<KIOSK_ROLE> kioskRoles;
    @Column(nullable=false, columnDefinition="BOOLEAN DEFAULT FALSE")
    private boolean isActive = false;

    public User(UserExternal userExternal) {
        this.id = Integer.parseInt(userExternal.getId());
        this.firstName = userExternal.getFirstName();
        this.lastName = userExternal.getLastName();
        this.username = userExternal.getFirstName() + " " + userExternal.getLastName();
        this.password = userExternal.getPincode();
        this.rfid = userExternal.getRfid();
        this.kioskRoles = userExternal.getKioskRoles().stream().filter(Objects::nonNull).map(KIOSK_ROLE::fromCode).filter(Objects::nonNull).toList();
    }

    public boolean hasKioskRole(KIOSK_ROLE role) {
        return UserUtils.checkKioskRole((User)this, (KIOSK_ROLE)role);
    }

    public int getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getRfid() {
        return this.rfid;
    }

    public List<KIOSK_ROLE> getKioskRoles() {
        return this.kioskRoles;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRfid(String rfid) {
        this.rfid = rfid;
    }

    public void setKioskRoles(List<KIOSK_ROLE> kioskRoles) {
        this.kioskRoles = kioskRoles;
    }

    public void setActive(boolean isActive) {
        this.isActive = isActive;
    }

    public User() {
    }

    public User(int id, String firstName, String lastName, String username, String password, String rfid, List<KIOSK_ROLE> kioskRoles, boolean isActive) {
        this.id = id;
        this.firstName = firstName;
        this.lastName = lastName;
        this.username = username;
        this.password = password;
        this.rfid = rfid;
        this.kioskRoles = kioskRoles;
        this.isActive = isActive;
    }
}

