/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.popup.orderConfirmationController;

import cz.polreich.spagetka.controllers.CustomerBaseController;
import cz.polreich.spagetka.controllers.CustomerOrderConfirmationController;
import cz.polreich.spagetka.guiElements.RadioToggleButton;
import cz.polreich.spagetka.models.gui.buttons.CancelButton;
import cz.polreich.spagetka.models.gui.buttons.ConfirmButton;
import cz.polreich.spagetka.utils.FontUtils;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.TouchEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.text.Font;
import javafx.stage.Popup;
import javafx.stage.Window;

public class TipPopup
extends Popup {
    private CustomerOrderConfirmationController orderConfirmationController;
    private CancelButton cancelButton;
    private ConfirmButton confirmButton;
    private RadioToggleButton noTip;

    public TipPopup(CustomerOrderConfirmationController orderConfirmationController) {
        this.orderConfirmationController = orderConfirmationController;
        int tileCornerRadius = 20;
        boolean borderWidth = true;
        AnchorPane popupAnchor = new AnchorPane();
        Label title = new Label();
        title.setMaxWidth(800.0);
        orderConfirmationController.bindStringToLocale(title, "tip.label.title", orderConfirmationController.titleFont);
        FontUtils.setIdealFont((Label)title, (Font)orderConfirmationController.titleFont);
        AnchorPane.setTopAnchor((Node)title, (Double)30.0);
        AnchorPane.setLeftAnchor((Node)title, (Double)100.0);
        AnchorPane.setRightAnchor((Node)title, (Double)100.0);
        title.setAlignment(Pos.CENTER);
        title.setPadding(new Insets(20.0));
        Label subtitle = new Label();
        subtitle.setAlignment(Pos.CENTER);
        subtitle.setMaxWidth(800.0);
        orderConfirmationController.bindStringToLocale(subtitle, "tip.label.text", orderConfirmationController.titleFont);
        subtitle.setPadding(new Insets(20.0));
        AnchorPane.setTopAnchor((Node)subtitle, (Double)150.0);
        AnchorPane.setLeftAnchor((Node)subtitle, (Double)100.0);
        AnchorPane.setRightAnchor((Node)subtitle, (Double)100.0);
        ToggleGroup tipToggleGroup = new ToggleGroup();
        this.noTip = new RadioToggleButton();
        this.noTip.setFont(orderConfirmationController.subtitleFont);
        this.noTip.setToggleGroup(tipToggleGroup);
        this.noTip.setSelected(true);
        this.noTip.setText("0 K\u010d");
        this.noTip.setId("0");
        RadioToggleButton tip1 = new RadioToggleButton();
        tip1.setFont(orderConfirmationController.subtitleFont);
        tip1.setToggleGroup(tipToggleGroup);
        tip1.setText("15 K\u010d");
        tip1.setId("15");
        RadioToggleButton tip2 = new RadioToggleButton();
        tip2.setFont(orderConfirmationController.subtitleFont);
        tip2.setToggleGroup(tipToggleGroup);
        tip2.setText("30 K\u010d");
        tip2.setId("30");
        RadioToggleButton tip3 = new RadioToggleButton();
        tip3.setFont(orderConfirmationController.subtitleFont);
        tip3.setToggleGroup(tipToggleGroup);
        tip3.setText("50 K\u010d");
        tip3.setId("50");
        RadioToggleButton tip4 = new RadioToggleButton();
        tip4.setFont(orderConfirmationController.subtitleFont);
        tip4.setToggleGroup(tipToggleGroup);
        tip4.setText("100 K\u010d");
        tip4.setId("100");
        FlowPane tipButtonsFlowPane = new FlowPane();
        tipButtonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        tipButtonsFlowPane.setAlignment(Pos.CENTER);
        tipButtonsFlowPane.setHgap(30.0);
        AnchorPane.setTopAnchor((Node)tipButtonsFlowPane, (Double)300.0);
        AnchorPane.setLeftAnchor((Node)tipButtonsFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)tipButtonsFlowPane, (Double)0.0);
        tipButtonsFlowPane.getChildren().addAll((Object[])new Node[]{this.noTip, tip1, tip2, tip3, tip4});
        this.confirmButton = new ConfirmButton();
        orderConfirmationController.bindStringToLocale((Button)this.confirmButton, "tip.button.confirm", orderConfirmationController.titleFont);
        this.confirmButton.setMaxWidth(300.0);
        this.confirmButton.setMinSize(160.0, 40.0);
        FontUtils.setIdealFont((Button)this.confirmButton, (Font)orderConfirmationController.titleFont);
        this.cancelButton = new CancelButton();
        this.cancelButton.setMaxWidth(300.0);
        orderConfirmationController.bindStringToLocale((Button)this.cancelButton, "tip.button.cancel", orderConfirmationController.titleFont);
        this.cancelButton.setMinSize(160.0, 40.0);
        FontUtils.setIdealFont((Button)this.cancelButton, (Font)orderConfirmationController.titleFont);
        FlowPane bottomButtonsFlowPane = new FlowPane();
        bottomButtonsFlowPane.setHgap(50.0);
        bottomButtonsFlowPane.setOrientation(Orientation.HORIZONTAL);
        bottomButtonsFlowPane.setAlignment(Pos.CENTER);
        AnchorPane.setBottomAnchor((Node)bottomButtonsFlowPane, (Double)40.0);
        AnchorPane.setLeftAnchor((Node)bottomButtonsFlowPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)bottomButtonsFlowPane, (Double)0.0);
        bottomButtonsFlowPane.getChildren().addAll((Object[])new Node[]{this.cancelButton, this.confirmButton});
        popupAnchor.setMinWidth(900.0);
        popupAnchor.setMinHeight(650.0);
        popupAnchor.setStyle("-fx-background-color: " + orderConfirmationController.popupBackgroundColor + ";");
        popupAnchor.getStyleClass().add((Object)"popup-main-pane");
        popupAnchor.getChildren().addAll((Object[])new Node[]{title, subtitle, tipButtonsFlowPane, bottomButtonsFlowPane});
        this.getContent().add((Object)popupAnchor);
        this.cancelButton.setOnMouseClicked(mouseEvent -> {
            this.hide();
            orderConfirmationController.activeConfig.getCurrentOrder().setTip(Double.valueOf(0.0));
            orderConfirmationController.goToPayment();
        });
        this.confirmButton.setOnMouseClicked(mouseEvent -> {
            this.hide();
            orderConfirmationController.activeConfig.getCurrentOrder().setTip(Double.valueOf(Double.parseDouble(((RadioToggleButton)tipToggleGroup.getSelectedToggle()).getId())));
            orderConfirmationController.updateCartContent();
            orderConfirmationController.goToPayment();
        });
    }

    public void loadPopup() {
        if (this.orderConfirmationController.activeConfig.getCurrentOrder().getTip() > 0.0) {
            this.orderConfirmationController.goToPayment();
        } else {
            this.addEventFilter(MouseEvent.MOUSE_PRESSED, mouseEvent -> {
                CustomerBaseController.lastPressTime = System.currentTimeMillis();
            });
            this.addEventFilter(TouchEvent.TOUCH_PRESSED, touchEvent -> {
                CustomerBaseController.lastPressTime = System.currentTimeMillis();
            });
            this.noTip.setSelected(true);
            this.show((Window)this.orderConfirmationController.stage);
            ((Node)this.getContent().get(0)).requestFocus();
        }
    }

    public void hide() {
        this.orderConfirmationController.activeConfig.getOpenedPopups().remove(this);
        super.hide();
    }
}

