/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers.layout.orderManagementController;

import cz.polreich.spagetka.controllers.OrderManagementController;
import cz.polreich.spagetka.controllers.layout.orderManagementController.OrderFlowPane;
import cz.polreich.spagetka.factory.ImageFactory;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.models.gui.buttons.GrayButton;
import cz.polreich.spagetka.utils.ResourceHelper;
import java.time.format.DateTimeFormatter;
import java.util.List;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.text.Font;

public class OrderFlowPane {
    private final OrderManagementController orderManagementController;
    private FlowPane pagingFlowPane = new FlowPane();
    private GrayButton previousPageButton = new GrayButton();
    private GrayButton nextPageButton = new GrayButton();
    private IntegerProperty currentPage = new SimpleIntegerProperty(0);
    private IntegerProperty pages = new SimpleIntegerProperty(0);
    private Label pagingLabel = new Label();
    private ImageFactory imageFactory = new ImageFactory(new ResourceHelper());
    private final List<Order> orderList;
    private final int ordersPerPage = 9;
    private BooleanProperty paging = new SimpleBooleanProperty(false);

    public OrderFlowPane(OrderManagementController orderManagementController) {
        this.orderManagementController = orderManagementController;
        List<ORDER_STATUS> orderStatuses = List.of(ORDER_STATUS.DONE, ORDER_STATUS.WAITING_FOR_DELIVERY, ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT, ORDER_STATUS.WAITING_FOR_PICKUP);
        this.orderList = orderManagementController.orderService.findByOrderStatusesAndByTodayAndTheNewestOnTHeTop(orderStatuses);
        this.pagingFlowPane.setAlignment(Pos.TOP_CENTER);
        this.pagingFlowPane.setVgap(20.0);
        AnchorPane.setTopAnchor((Node)this.pagingFlowPane, (Double)20.0);
        AnchorPane.setLeftAnchor((Node)this.pagingFlowPane, (Double)10.0);
        orderManagementController.getMainAnchorPane().getChildren().add((Object)this.pagingFlowPane);
        this.previousPageButton.setText("<<");
        this.previousPageButton.setFont(new Font(20.0));
        this.previousPageButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.currentPage.get() < 1, (Observable[])new Observable[]{this.currentPage, this.pages}));
        this.previousPageButton.setOnAction(e -> {
            if (this.currentPage.get() > 0) {
                this.currentPage.set(this.currentPage.get() - 1);
                this.refreshPage();
            }
        });
        this.nextPageButton.setText(">>");
        this.nextPageButton.setFont(new Font(20.0));
        this.nextPageButton.disableProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.currentPage.get() >= this.pages.get() - 1, (Observable[])new Observable[]{this.currentPage, this.pages}));
        this.nextPageButton.setOnAction(e -> {
            if (this.currentPage.get() < this.pages.get() - 1) {
                this.currentPage.set(this.currentPage.get() + 1);
                this.refreshPage();
            }
        });
        this.pagingLabel.setVisible(true);
        this.pagingLabel.setStyle("-fx-text-fill: white");
        this.pagingLabel.setAlignment(Pos.CENTER);
        this.pagingLabel.setFont(orderManagementController.subtitleFont);
        this.pagingLabel.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> this.currentPage.get() + 1 + " / " + this.pages.get(), (Observable[])new Observable[]{this.currentPage, this.pages}));
        this.pagingLabel.visibleProperty().bind((ObservableValue)Bindings.createBooleanBinding(() -> this.pagingFlowPane.isVisible(), (Observable[])new Observable[]{this.pagingFlowPane.visibleProperty()}));
        this.pages.set((int)Math.ceil((double)this.orderList.size() / 9.0));
        if (this.orderList.size() > 9) {
            this.paging.set(true);
        } else {
            this.paging.set(false);
        }
        this.refreshPage();
    }

    private HBox createBottomPaging(GrayButton previousPageButton, Label pagingLabel, GrayButton nextPageButton) {
        HBox hBox = new HBox();
        hBox.setPrefWidth(460.0);
        hBox.setPrefHeight(50.0);
        hBox.setAlignment(Pos.CENTER);
        previousPageButton.setPrefHeight(50.0);
        nextPageButton.setPrefHeight(50.0);
        pagingLabel.setPrefHeight(40.0);
        pagingLabel.setPrefWidth(hBox.getPrefWidth() / 3.0);
        hBox.getChildren().addAll((Object[])new Node[]{previousPageButton, pagingLabel, nextPageButton});
        return hBox;
    }

    private void refreshPage() {
        this.pagingFlowPane.getChildren().clear();
        int start = this.currentPage.get() * 9;
        int end = Math.min(start + 9, this.orderList.size());
        for (int i = start; i < end; ++i) {
            HBox orderItem = this.createOrderItem((Order)this.orderList.get(i));
            this.pagingFlowPane.getChildren().add((Object)orderItem);
        }
        if (this.currentPage.get() + 1 == this.pages.get()) {
            int it = this.pages.get() * 9 - this.orderList.size();
            for (int i = 0; i < it; ++i) {
                this.pagingFlowPane.getChildren().add((Object)this.createEmptyHBox());
            }
        }
        if (this.paging.get()) {
            HBox pagingTop = this.createBottomPaging(this.previousPageButton, this.pagingLabel, this.nextPageButton);
            this.pagingFlowPane.getChildren().add((Object)pagingTop);
        }
    }

    private HBox createEmptyHBox() {
        HBox hBox = new HBox();
        hBox.setPrefWidth(460.0);
        hBox.setPrefHeight(50.0);
        hBox.setVisible(false);
        return hBox;
    }

    private HBox createOrderItem(Order order) {
        HBox hBox = new HBox();
        hBox.setPrefWidth(460.0);
        hBox.setPrefHeight(50.0);
        switch (1.$SwitchMap$cz$polreich$spagetka$models$enums$ORDER_STATUS[order.getOrderStatus().ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                hBox.setStyle("-fx-background-color: #9FE2BF; -fx-background-radius: 50 0 0 50");
                break;
            }
            case 4: {
                hBox.setStyle("-fx-background-color: #A9A9A9; -fx-background-radius: 50 0 0 50");
            }
        }
        hBox.setAlignment(Pos.CENTER);
        Label dateLabel = new Label(order.getToBeFinishedDateTime().toLocalTime().format(DateTimeFormatter.ofPattern("HH:mm")));
        dateLabel.setFont(new Font(20.0));
        dateLabel.setAlignment(Pos.CENTER);
        dateLabel.setStyle("-fx-text-fill: white ; -fx-background-color: #32343D");
        if (order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)) {
            dateLabel.setStyle("-fx-text-fill: white ; -fx-background-color: #32343D; -fx-font-style: italic;");
        }
        dateLabel.setPrefWidth(hBox.getPrefWidth() / 4.0);
        Label idLabel = new Label("\u2116 " + order.getOrderNumber());
        idLabel.setFont(new Font(20.0));
        idLabel.setAlignment(Pos.CENTER);
        idLabel.setStyle("-fx-text-fill: white ; -fx-background-color: #32343D");
        if (order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)) {
            idLabel.setStyle("-fx-text-fill: white ; -fx-background-color: #32343D; -fx-font-style: italic;");
        }
        idLabel.setPrefWidth(hBox.getPrefWidth() / 4.0);
        Label costLabel = new Label(order.getTotalPrice() + " K\u010d");
        costLabel.setFont(new Font(20.0));
        costLabel.setAlignment(Pos.CENTER);
        costLabel.setStyle("-fx-text-fill: white ; -fx-background-color: #32343D");
        if (order.getOrderStatus().equals((Object)ORDER_STATUS.WAITING_FOR_CASHIER_APPROVEMENT)) {
            costLabel.setStyle("-fx-text-fill: white ; -fx-background-color: #32343D; -fx-font-style: italic;");
        }
        costLabel.setPrefWidth(hBox.getPrefWidth() / 4.0);
        Button seeMoreButton = new Button();
        ImageView view = new ImageView((Image)this.imageFactory.create("/resources/images/search-white.png").get());
        view.setFitHeight(40.0);
        view.setFitWidth(40.0);
        seeMoreButton.setGraphic((Node)view);
        seeMoreButton.setStyle("-fx-background-radius: 0 0 0 0; -fx-background-color: #32343D");
        seeMoreButton.setPrefWidth(hBox.getPrefWidth() / 4.0);
        seeMoreButton.setPrefHeight(hBox.getPrefHeight());
        seeMoreButton.setOnAction(x -> {
            this.pagingFlowPane.setVisible(false);
            this.pagingFlowPane.getChildren().clear();
            this.orderManagementController.setOrder(order);
        });
        hBox.getChildren().addAll((Object[])new Node[]{dateLabel, idLabel, costLabel, seeMoreButton});
        return hBox;
    }

    public void hide() {
        this.pagingFlowPane.getChildren().clear();
    }
}

