/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.service;

import cz.polreich.spagetka.factory.ProductVariantFactory;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.repository.ProductVariantRepository;
import jakarta.persistence.EntityNotFoundException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductVariantService {
    @Autowired
    private ProductVariantRepository productVariantRepository;
    private ProductVariantFactory productVariantFactory;

    public void saveAll(List<ProductVariant> productVariants) {
        this.productVariantRepository.saveAll(productVariants);
    }

    public List<ProductVariant> findAll() {
        return this.productVariantRepository.findAll();
    }

    public boolean existById(String id) {
        return this.productVariantRepository.findById((Object)id).isPresent();
    }

    public ProductVariant findById(String id) {
        return (ProductVariant)this.productVariantRepository.findById((Object)id).get();
    }

    public List<ProductVariant> findByProductId(String productId) {
        return this.productVariantRepository.findByProductsId(productId);
    }

    public void save(ProductVariant productVariant) {
        this.productVariantRepository.save((Object)productVariant);
    }

    public void deleteById(String id) {
        if (!this.productVariantRepository.findById((Object)id).isPresent()) {
            throw new EntityNotFoundException("[ProductVariantService] - Product Variant with ID: " + id + "was not found. (E-154)");
        }
        this.productVariantRepository.deleteById((Object)id);
    }

    public void removeAllCompositionItemsFromProductVariants() {
        List allProductVariants = this.productVariantRepository.findAll();
        for (ProductVariant product : allProductVariants) {
            product.setIngredients(null);
        }
        this.productVariantRepository.saveAll((Iterable)allProductVariants);
    }

    public ProductVariant createFromProduct(Product product) {
        return this.productVariantFactory.create(product);
    }

    @Autowired
    public void setProductVariantFactory(ProductVariantFactory productVariantFactory) {
        this.productVariantFactory = productVariantFactory;
    }
}

