/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.controllers;

import cz.polreich.spagetka.controllers.Controller;
import cz.polreich.spagetka.controllers.CookController;
import cz.polreich.spagetka.controllers.popup.cashierController.InventoryPopup;
import cz.polreich.spagetka.models.Category;
import cz.polreich.spagetka.models.CompositionItem;
import cz.polreich.spagetka.models.FinishedItem;
import cz.polreich.spagetka.models.Ingredient;
import cz.polreich.spagetka.models.Order;
import cz.polreich.spagetka.models.OrderItem;
import cz.polreich.spagetka.models.Product;
import cz.polreich.spagetka.models.ProductFreeVariant;
import cz.polreich.spagetka.models.ProductVariant;
import cz.polreich.spagetka.models.StockItem;
import cz.polreich.spagetka.models.config.CategoryColor;
import cz.polreich.spagetka.models.config.CookConfig;
import cz.polreich.spagetka.models.enums.ORDER_STATUS;
import cz.polreich.spagetka.service.CategoryService;
import cz.polreich.spagetka.service.FinishedItemService;
import cz.polreich.spagetka.service.IngredientService;
import cz.polreich.spagetka.service.OrderService;
import cz.polreich.spagetka.service.ProductService;
import cz.polreich.spagetka.service.StockItemService;
import cz.polreich.spagetka.utils.ExceptionHandler;
import cz.polreich.spagetka.utils.FontUtils;
import cz.polreich.spagetka.utils.FormatUtils;
import cz.polreich.spagetka.utils.LayoutUtils;
import cz.polreich.spagetka.utils.MockDataHandler;
import cz.polreich.spagetka.utils.ValidationUtils;
import java.net.URL;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class CookController
extends Controller
implements Initializable {
    public CookConfig activeConfig;
    @FXML
    private FlowPane mainFlowPane;
    @FXML
    private HBox topPanel;
    @Autowired
    private OrderService orderService;
    @Autowired
    private ProductService productService;
    @Autowired
    private MockDataHandler mockDataHandler;
    @Autowired
    private IngredientService ingredientService;
    @Autowired
    private StockItemService stockItemService;
    @Autowired
    private FinishedItemService finishedItemService;
    @Autowired
    private CategoryService categoryService;
    public Font titleFont;
    public Font subtitleFont;
    public Font topPanelFont;
    public Font normalFont;
    public Font orderItemTitleFont;
    public Font ingredientLabelFont;
    public Font locationLabelFont;
    private TimerTask task;
    private Timer timer;
    private List<Ingredient> allIngredients;
    private LocalDateTime lastUpdate = LocalDateTime.now();
    private Label currentTimeLabel = new Label();
    private Label stopwatch1Label = new Label();
    private Label stopwatch2Label = new Label();
    private LocalDateTime stopwatch1Start;
    private LocalDateTime stopwatch1Stop;
    private LocalDateTime stopwatch2Start;
    private LocalDateTime stopwatch2Stop;
    private List<Integer> allowedCategories = new ArrayList();
    private static final Media soundSuccess = new Media(Objects.requireNonNull(InventoryPopup.class.getResource("/resources/sounds/success-1-6297-2.mp3")).toExternalForm());
    private static MediaPlayer successMediaPlayer = new MediaPlayer(soundSuccess);

    @PostConstruct
    public void init() {
        super.init();
        this.activeConfig = this.config.getCook();
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
    }

    public void setupScene() {
        super.setupScene();
        this.mainFlowPane.setPadding(LayoutUtils.getInsets((double)0.0, (double)5.0, (double)0.0, (double)5.0));
        this.mainFlowPane.setHgap(6.0);
        this.mainFlowPane.setVgap(6.0);
        this.allIngredients = this.ingredientService.findAll();
        this.currentTimeLabel.setFont(this.topPanelFont);
        this.stopwatch1Label.setFont(this.topPanelFont);
        this.stopwatch1Label.setOnMouseClicked(mouseEvent -> {
            if (this.stopwatch1Start == null && this.stopwatch1Stop == null) {
                this.stopwatch1Start = LocalDateTime.now();
            } else if (this.stopwatch1Start != null && this.stopwatch1Stop == null) {
                this.stopwatch1Stop = LocalDateTime.now();
            } else {
                this.stopwatch1Start = null;
                this.stopwatch1Stop = null;
            }
        });
        this.stopwatch2Label.setFont(this.topPanelFont);
        this.stopwatch2Label.setOnMouseClicked(mouseEvent -> {
            if (this.stopwatch2Start == null && this.stopwatch2Stop == null) {
                this.stopwatch2Start = LocalDateTime.now();
            } else if (this.stopwatch2Start != null && this.stopwatch2Stop == null) {
                this.stopwatch2Stop = LocalDateTime.now();
            } else {
                this.stopwatch2Start = null;
                this.stopwatch2Stop = null;
            }
        });
        this.topPanel.setSpacing(250.0);
        this.topPanel.getChildren().addAll((Object[])new Node[]{this.stopwatch1Label, this.currentTimeLabel, this.stopwatch2Label});
        this.startOrderCheckThread();
        this.addStopwatches();
        this.createTimer();
    }

    public void setupFonts() {
        super.setupFonts();
        this.registerFonts(this.activeConfig.getFonts());
        this.titleFont = this.setupCookFont("title");
        this.subtitleFont = this.setupCookFont("subtitle");
        this.topPanelFont = this.setupCookFont("topPanel");
        this.normalFont = this.setupCookFont("normal");
        this.orderItemTitleFont = this.setupCookFont("orderItemTitle");
        this.ingredientLabelFont = this.setupCookFont("ingredientLabel");
        this.locationLabelFont = this.setupCookFont("locationLabel");
    }

    private void startOrderCheckThread() {
        this.task = new /* Unavailable Anonymous Inner Class!! */;
        this.timer = new Timer(true);
        this.timer.scheduleAtFixedRate(this.task, 0L, 2000L);
    }

    private void loadNewOrders(List<Order> orders) {
        System.out.println("Cook - Found " + orders.size() + " orders.");
        this.removeAllChildren((Pane)this.mainFlowPane);
        ArrayList<ScheduledOrderItem> orderItems = new ArrayList<ScheduledOrderItem>();
        this.allowedCategories = this.activeConfig.getServingPositions().stream().flatMap(c -> this.categoryService.findByCookPosition(c.intValue()).stream()).map(Category::getId).toList();
        for (Order order : orders) {
            if (order.getOrderStatus() != ORDER_STATUS.PREPARING) {
                order.setOrderStatus(ORDER_STATUS.PREPARING);
                this.orderService.update(order);
                if (order.isSchedulable()) {
                    this.playSuccessSound();
                }
            }
            orderItems.addAll(order.getOrderItems().stream().map(oi -> new ScheduledOrderItem(oi, order)).toList());
        }
        orderItems.sort(Comparator.comparing(ScheduledOrderItem::getToBeFinishedDateTime));
        for (ScheduledOrderItem orderItem : orderItems) {
            for (int i = 0; i < orderItem.getQuantity(); ++i) {
                if (orderItem.getQuantity() > 1) {
                    long dashCount = orderItem.getId().chars().filter(ch -> ch == 45).count();
                    String strippedId = dashCount > 4L ? orderItem.getId().substring(0, orderItem.getId().lastIndexOf("-")) : orderItem.getId();
                    orderItem.setId(strippedId + "-" + i);
                }
                if (orderItem.getSubItems() != null && !orderItem.getSubItems().isEmpty()) {
                    for (OrderItem originalSubItem : orderItem.getSubItems()) {
                        ScheduledOrderItem subItem = new ScheduledOrderItem(originalSubItem, orderItem.getToBeFinishedDateTime());
                        if (subItem.getQuantity() > 1) {
                            long dashCount2 = subItem.getId().chars().filter(ch -> ch == 45).count();
                            String strippedId2 = dashCount2 > 4L ? subItem.getId().substring(0, subItem.getId().lastIndexOf("-")) : subItem.getId();
                            subItem.setId(strippedId2 + "-" + i);
                        }
                        if (!this.allowedCategories.contains(subItem.getMainProduct().getCategory()) || this.finishedItemService.existsById(subItem.getId())) continue;
                        this.createProductTile(subItem);
                    }
                    continue;
                }
                if (!this.allowedCategories.contains(orderItem.getMainProduct().getCategory()) || this.finishedItemService.existsById(orderItem.getId())) continue;
                this.createProductTile(orderItem);
            }
        }
    }

    private void createProductTile(ScheduledOrderItem orderItem) {
        VBox ingredientVBox;
        HBox quantityHBox;
        HBox ingredientHBox;
        String orderItemId = orderItem.getId();
        Product product = orderItem.getMainProduct();
        ProductVariant variant = orderItem.getMainProductVariant();
        List freeVariants = orderItem.getFreeVariants();
        String title = variant != null ? variant.getName() : product.getName();
        List categoryColors = this.activeConfig.getColors().getCategories();
        VBox orderItemVBox = new VBox();
        orderItemVBox.setPrefSize(196.0, 100.0);
        orderItemVBox.setMaxSize(196.0, 740.0);
        String color = categoryColors.stream().filter(c -> c.getCategoryId().intValue() == product.getCategory()).findFirst().orElse(categoryColors.stream().filter(c -> c.getCategoryId() == -1).findFirst().orElse(new CategoryColor("#aaa7ad"))).getColor();
        int borderWidth = 1;
        int innerBorderWidth = 2;
        orderItemVBox.setStyle("-fx-background-color: " + color + ";\n-fx-border-color:  gray;\n-fx-border-width: " + borderWidth + "px;\n-fx-border-style: solid;");
        orderItemVBox.setOnMouseClicked(mouseEvent -> {
            this.finishedItemService.save(new FinishedItem(orderItemId));
            this.mainFlowPane.getChildren().remove((Object)orderItemVBox);
        });
        orderItemVBox.setOnTouchPressed(touchEvent -> {
            this.finishedItemService.save(new FinishedItem(orderItemId));
            this.mainFlowPane.getChildren().remove((Object)orderItemVBox);
        });
        Label itemName = this.replaceItemName(product, title);
        itemName.setPrefWidth(196.0);
        itemName.setAlignment(Pos.CENTER);
        if (title.length() > 15) {
            itemName.setWrapText(true);
            itemName.setFont(this.orderItemTitleFont);
        } else {
            itemName.setWrapText(false);
            FontUtils.setIdealFont((Label)itemName, (Font)this.orderItemTitleFont, (int)4);
        }
        VBox.setMargin((Node)itemName, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
        VBox ingredientsVBox = new VBox();
        ingredientsVBox.setPrefSize(100.0, 196.0);
        ingredientsVBox.setSpacing(5.0);
        VBox.setMargin((Node)ingredientsVBox, (Insets)LayoutUtils.getInsets((double)10.0, (double)0.0, (double)10.0, (double)0.0));
        for (CompositionItem compositionItem : product.getIngredients()) {
            if (compositionItem.getIngredient() == null || !compositionItem.getIngredient().getCookSee().booleanValue()) continue;
            ingredientHBox = this.createIngredientHBox(compositionItem.getIngredient().getName().split("-")[0]);
            quantityHBox = this.createQuantityHBox(compositionItem);
            ingredientVBox = new VBox();
            VBox.setVgrow((Node)ingredientHBox, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)quantityHBox, (Priority)Priority.ALWAYS);
            ingredientVBox.setStyle("-fx-border-color:  lightgray transparent transparent transparent;\n-fx-border-width: " + innerBorderWidth + "px 0 0 0;\n-fx-border-style: solid;");
            ingredientVBox.setSpacing(5.0);
            ingredientVBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)color), CornerRadii.EMPTY, Insets.EMPTY)}));
            ingredientVBox.getChildren().addAll((Object[])new Node[]{ingredientHBox, quantityHBox});
            ingredientVBox.setMaxHeight(75.0);
            VBox.setVgrow((Node)ingredientVBox, (Priority)Priority.ALWAYS);
            ingredientsVBox.getChildren().add((Object)ingredientVBox);
        }
        if (variant != null) {
            for (CompositionItem compositionItem : variant.getIngredients()) {
                if (compositionItem.getIngredient() == null || !compositionItem.getIngredient().getCookSee().booleanValue()) continue;
                ingredientHBox = this.createIngredientHBox(compositionItem.getIngredient().getName().split("-")[0]);
                quantityHBox = this.createQuantityHBox(compositionItem);
                ingredientVBox = new VBox();
                ingredientVBox.setStyle("-fx-border-color:  lightgray transparent transparent transparent;\n-fx-border-width: " + innerBorderWidth + "px 0 0 0;\n-fx-border-style: solid;");
                ingredientVBox.setSpacing(5.0);
                ingredientVBox.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)color), CornerRadii.EMPTY, Insets.EMPTY)}));
                ingredientVBox.getChildren().addAll((Object[])new Node[]{ingredientHBox, quantityHBox});
                ingredientsVBox.getChildren().add((Object)ingredientVBox);
            }
        }
        for (ProductFreeVariant freeVariant : freeVariants) {
            ingredientHBox = this.createIngredientHBox(freeVariant.getName());
            VBox ingredientVBox2 = new VBox();
            ingredientVBox2.setStyle("-fx-border-color:  lightgray transparent transparent transparent;\n-fx-border-width: " + innerBorderWidth + "px 0 0 0;\n-fx-border-style: solid;");
            ingredientVBox2.setSpacing(5.0);
            ingredientVBox2.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.valueOf((String)color), CornerRadii.EMPTY, Insets.EMPTY)}));
            ingredientVBox2.getChildren().addAll((Object[])new Node[]{ingredientHBox});
            ingredientsVBox.getChildren().add((Object)ingredientVBox2);
        }
        orderItemVBox.getChildren().addAll((Object[])new Node[]{itemName, ingredientsVBox});
        this.mainFlowPane.getChildren().add((Object)orderItemVBox);
    }

    private Font getItemLabelSize(Label itemName) {
        Font font = itemName.getText().length() <= 15 ? this.orderItemTitleFont : (itemName.getText().length() <= 19 ? new Font(this.orderItemTitleFont.getFamily(), this.orderItemTitleFont.getSize() * 0.9) : (itemName.getText().length() <= 25 ? new Font(this.orderItemTitleFont.getFamily(), this.orderItemTitleFont.getSize() * 0.8) : new Font(this.orderItemTitleFont.getFamily(), this.orderItemTitleFont.getSize() * 0.7)));
        return font;
    }

    private Label replaceItemName(Product product, String title) {
        Label itemName = new Label(title);
        if (product.getCategory() == 1) {
            itemName.setText(itemName.getText().replace("\u0160pagety", "\u0160."));
        }
        if (product.getCategory() == 6) {
            itemName.setText(itemName.getText().replace("Fusilli", "F."));
        }
        if (product.getCategory() == 3) {
            itemName.setText(itemName.getText().replace("limon\u00e1da", "lim.").replace("Limon\u00e1da", "Lim."));
        }
        if (product.getCategory() == 2) {
            itemName.setText(itemName.getText().replace("pol\u00e9vka", "p.").replace("Pol\u00e9vka", "P."));
        }
        if (product.getCategory() == 7) {
            itemName.setText(itemName.getText().replace("zmrzlina", "zm.").replace("Zmrzlina", "Zm."));
        }
        return itemName;
    }

    private HBox createIngredientHBox(String label) {
        HBox hBox = new HBox();
        hBox.setMinSize(196.0, 30.0);
        hBox.setPrefSize(196.0, 100.0);
        hBox.setSpacing(2.0);
        hBox.setPadding(new Insets(1.0, 0.0, 1.0, 0.0));
        Label label1 = new Label(label);
        label1.setText(label1.getText().replace("om\u00e1\u010dka", "om."));
        label1.setMaxHeight(48.0);
        Font font = this.getFontSize(label1);
        label1.setAlignment(Pos.TOP_LEFT);
        label1.setFont(font);
        label1.setWrapText(true);
        HBox.setMargin((Node)label1, (Insets)new Insets(2.0, 0.0, 0.0, 0.0));
        hBox.getChildren().addAll((Object[])new Node[]{label1});
        return hBox;
    }

    private Font getFontSize(Label label1) {
        Font font;
        if (label1.getText().length() <= 15) {
            font = this.ingredientLabelFont;
            label1.setMinHeight(16.0);
        } else if (label1.getText().length() <= 20) {
            font = new Font(this.ingredientLabelFont.getFamily(), this.ingredientLabelFont.getSize() * 0.9);
            label1.setMinHeight(32.0);
        } else if (label1.getText().length() <= 25) {
            font = new Font(this.ingredientLabelFont.getFamily(), this.ingredientLabelFont.getSize() * 0.85);
            label1.setMinHeight(48.0);
        } else {
            font = new Font(this.ingredientLabelFont.getFamily(), this.ingredientLabelFont.getSize() * 0.75);
            label1.setMinHeight(48.0);
        }
        return font;
    }

    private HBox createQuantityHBox(CompositionItem compositionItem) {
        HBox hBox = new HBox();
        hBox.setMinSize(196.0, 30.0);
        hBox.setPrefSize(196.0, 100.0);
        Label quantityLabel = this.getQuantityLabel(compositionItem);
        HBox.setMargin((Node)quantityLabel, (Insets)new Insets(2.0, 0.0, 0.0, 0.0));
        Region region = new Region();
        region.setPrefSize(1.0, 1.0);
        HBox.setHgrow((Node)region, (Priority)Priority.ALWAYS);
        Label locationLabel = new Label(this.getRecommendedLocationForIngredient(compositionItem.getIngredient(), compositionItem.getQuantity().doubleValue()));
        locationLabel.setFont(this.locationLabelFont);
        locationLabel.setAlignment(Pos.TOP_RIGHT);
        locationLabel.setPadding(new Insets(0.0, 2.0, 0.0, 0.0));
        hBox.getChildren().addAll((Object[])new Node[]{quantityLabel, region, locationLabel});
        return hBox;
    }

    private Label getQuantityLabel(CompositionItem compositionItem) {
        String ingredientUnit = ValidationUtils.isStringNotNullOrEmpty((String)compositionItem.getIngredient().getAlternativeUnit()) ? compositionItem.getIngredient().getAlternativeUnit() : (ValidationUtils.isStringNotNullOrEmpty((String)compositionItem.getIngredient().getUnit()) ? compositionItem.getIngredient().getUnit() : "");
        String ingredientQuantity = ValidationUtils.isDoubleNotNull((Double)compositionItem.getQuantity()) ? FormatUtils.formatCurrency((double)compositionItem.getQuantity()) : "?";
        Label label1 = new Label(ingredientQuantity + " " + ingredientUnit);
        label1.setFont(this.ingredientLabelFont);
        label1.setMaxHeight(48.0);
        label1.setWrapText(true);
        label1.setAlignment(Pos.TOP_LEFT);
        return label1;
    }

    private String getRecommendedLocationForIngredient(Ingredient ingredient, double quantity) {
        StockItem recommendedItem = this.stockItemService.findSoonestExpiringByIngredientId(ingredient.getId(), quantity);
        if (recommendedItem != null) {
            return recommendedItem.getLocation();
        }
        return "N/A";
    }

    private void addStopwatches() {
        2 timer1 = new /* Unavailable Anonymous Inner Class!! */;
        timer1.start();
        3 timer2 = new /* Unavailable Anonymous Inner Class!! */;
        timer2.start();
    }

    private void createTimer() {
        4 timer = new /* Unavailable Anonymous Inner Class!! */;
        timer.start();
    }

    private void playSuccessSound() {
        try {
            successMediaPlayer.stop();
            successMediaPlayer.seek(Duration.ZERO);
            successMediaPlayer.play();
        }
        catch (Exception e) {
            ExceptionHandler.logException((Exception)e);
        }
    }
}

