/*
 * Decompiled with CFR 0.152.
 */
package cz.polreich.spagetka.DTO;

import cz.polreich.spagetka.models.ReceiptItem;
import cz.polreich.spagetka.utils.CalcUtils;
import java.math.BigDecimal;
import java.util.List;

public class ReceiptItemDTO {
    private String id;
    private String title;
    private List<String> addProductsTitles;
    private List<ReceiptItemDTO> subitems;
    private int quantity;
    private Double unitPrice;
    private Double totalPrice;
    private Double vatPercent;
    private Double vatAmount;
    private Double baseAmount;
    private String orderItemId;

    public ReceiptItemDTO(ReceiptItem receiptItem) {
        this.id = receiptItem.getId();
        this.title = receiptItem.getTitle();
        this.addProductsTitles = receiptItem.getAddProductsTitles();
        this.subitems = receiptItem.getSubItems().stream().map(ReceiptItemDTO::new).toList();
        this.quantity = receiptItem.getQuantity();
        this.unitPrice = CalcUtils.toDouble((BigDecimal)receiptItem.getUnitPrice());
        this.totalPrice = CalcUtils.toDouble((BigDecimal)receiptItem.getTotalPrice());
        this.vatPercent = receiptItem.getVatPercent();
        this.vatAmount = CalcUtils.toDouble((BigDecimal)receiptItem.getVatAmount());
        this.baseAmount = CalcUtils.toDouble((BigDecimal)receiptItem.getBaseAmount());
    }

    public String getId() {
        return this.id;
    }

    public String getTitle() {
        return this.title;
    }

    public List<String> getAddProductsTitles() {
        return this.addProductsTitles;
    }

    public List<ReceiptItemDTO> getSubitems() {
        return this.subitems;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public Double getUnitPrice() {
        return this.unitPrice;
    }

    public Double getTotalPrice() {
        return this.totalPrice;
    }

    public Double getVatPercent() {
        return this.vatPercent;
    }

    public Double getVatAmount() {
        return this.vatAmount;
    }

    public Double getBaseAmount() {
        return this.baseAmount;
    }

    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAddProductsTitles(List<String> addProductsTitles) {
        this.addProductsTitles = addProductsTitles;
    }

    public void setSubitems(List<ReceiptItemDTO> subitems) {
        this.subitems = subitems;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public void setUnitPrice(Double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public void setTotalPrice(Double totalPrice) {
        this.totalPrice = totalPrice;
    }

    public void setVatPercent(Double vatPercent) {
        this.vatPercent = vatPercent;
    }

    public void setVatAmount(Double vatAmount) {
        this.vatAmount = vatAmount;
    }

    public void setBaseAmount(Double baseAmount) {
        this.baseAmount = baseAmount;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public ReceiptItemDTO() {
    }

    public ReceiptItemDTO(String id, String title, List<String> addProductsTitles, List<ReceiptItemDTO> subitems, int quantity, Double unitPrice, Double totalPrice, Double vatPercent, Double vatAmount, Double baseAmount, String orderItemId) {
        this.id = id;
        this.title = title;
        this.addProductsTitles = addProductsTitles;
        this.subitems = subitems;
        this.quantity = quantity;
        this.unitPrice = unitPrice;
        this.totalPrice = totalPrice;
        this.vatPercent = vatPercent;
        this.vatAmount = vatAmount;
        this.baseAmount = baseAmount;
        this.orderItemId = orderItemId;
    }
}

